<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Authentication Language Lines
    |--------------------------------------------------------------------------
    |
    | The following language lines are used during authentication for various
    | messages that we need to display to the user. You are free to modify
    | these language lines according to your application's requirements.
    |
    */

    /** dashboard */
    'welcome' => 'उपस्थिति डैशबोर्ड में आपका स्वागत है',
    'total_employees' => 'कुल कर्मचारी',
    'total_departments' => 'कुल विभाग',
    'total_holidays' => 'कुल छुट्टियाँ',
    'paid_leaves' => 'वेतनयुक्त छुट्टियाँ',
    'on_leave_today' => 'आज छुट्टी पर',
    'pending_leave_requests' => 'लंबित अवकाश अनुरोध',
    'total_check_in_today' => 'आज कुल चेक इन',
    'total_check_out_today' => 'आज कुल चेक आउट',
    'projects_detail' => 'प्रोजेक्ट विवरण',
    'total_projects' => 'कुल प्रोजेक्ट्स',
    'pending_projects' => 'लंबित प्रोजेक्ट्स',
    'on_hold_projects' => 'रुके हुए प्रोजेक्ट्स',
    'in_progress_projects' => 'प्रगति पर प्रोजेक्ट्स',
    'finished_projects' => 'समाप्त प्रोजेक्ट्स',
    'cancelled_projects' => 'रद्द प्रोजेक्ट्स',
    'top_clients' => 'शीर्ष ग्राहक',
    'task_details' => 'कार्य विवरण',
    'recent_projects' => 'हाल के प्रोजेक्ट्स',
    'title' => 'शीर्षक',
    'date_start' => 'प्रारंभ तिथि',
    'deadline' => 'अंतिम तिथि',
    'leader' => 'नेता',
    'completion' => 'समापन',
    'priority' => 'प्राथमिकता',
    'check_in_at' => 'चेक इन समय',
    'check_out_at' => 'चेक आउट समय',
    'punch_in' => 'पंच इन करें',
    'punch_out' => 'पंच आउट करें',
    'no_records_found' => 'कोई रिकॉर्ड नहीं मिला!',
    'project_management' => 'प्रोजेक्ट प्रबंधन',
    'view_all_clients' => 'सभी ग्राहकों को देखें',
    'view_all_projects' => 'सभी प्रोजेक्ट्स देखें',
    'error_message' => 'त्रुटि: अनुरोध संसाधित नहीं किया जा सका।',
    'success_message' => 'सफलता: क्रिया सफलतापूर्वक पूरी हुई।',
    'name' => 'नाम',
    'email' => 'ईमेल',
    'contact' => 'संपर्क',
    'project' => 'परियोजना',
    'pending' => 'लंबित',
    'on_hold' => 'रुका हुआ',
    'in_progress' => 'प्रगति में',
    'completed' => 'पूरा हुआ',
    'cancelled' => 'रद्द किया गया',
    'search_menu' => 'खोज मेनू',

    /** nav */
    'latest_notifications' => 'नवीनतम सूचनाएं',
    'view_all' => 'सभी देखें',
    'profile' => 'प्रोफ़ाइल',
    'edit_profile' => 'प्रोफ़ाइल संपादित करें',
    'request_leave' => 'छुट्टी का अनुरोध करें',
    'log_out' => 'लॉग आउट',
    'light_mode' => 'लाइट मोड',
    'dark_mode' => 'डार्क मोड',

    /** menu */
    'dashboard' => 'डैशबोर्ड',
    'company_management' => 'कंपनी प्रबंधन',
    'company' => 'कंपनी',
    'branch' => 'शाखा',
    'department' => 'विभाग',
    'post' => 'पोस्ट',
    'employee_management' => 'कर्मचारी प्रबंधन',
    'employees' => 'कर्मचारी',
    'logout_requests' => 'लॉगआउट अनुरोध',
    'attendance_section' => 'उपस्थिति खंड',
    'clients' => 'ग्राहक',
    'task_management' => 'कार्य प्रबंधन',
    'holidays' => 'छुट्टियां',
    'notice' => 'नोटिस',
    'payroll_management' => 'पेरोल प्रबंधन',
    'payroll' => 'पेरोल',
    'payroll_setting' => 'पेरोल सेटिंग',
    'advance_salary' => 'अग्रिम वेतन',
    'employee_salary' => 'कर्मचारी वेतन',
    'leave' => 'छुट्टी',
    'team_meeting' => 'टीम की मीटिंग',
    'tada' => 'टड़ा',
    'shift_management' => 'शिफ्ट प्रबंधन',
    'office_time' => 'कार्यालय का समय',
    'award_management' => 'पुरस्कार प्रबंधन',
    'award_types' => 'पुरस्कार प्रकार',
    'awards' => 'पुरस्कार',
    'asset_management' => 'संपत्ति प्रबंधन',
    'asset_types' => 'संपत्ति प्रकार',
    'assets' => 'संपत्ति',
    'content_management' => 'सामग्री प्रबंधन',
    'support' => 'समर्थन',
    'attendance_methods' => 'उपस्थिति विधियां',
    'routers' => 'राउटर्स',
    'qr' => 'क्यूआर कोड',
    'nfc' => 'एनएफसी',
    'settings' => 'सेटिंग्स',
    'roles_permissions' => 'भूमिकाएँ और अनुमतियाँ',
    'general_settings' => 'सामान्य सेटिंग्स',
    'app_settings' => 'ऐप सेटिंग्स',
    'notifications' => 'सूचनाएँ',
    'payment_currency' => 'भुगतान मुद्रा',
    'feature_control' => 'सुविधा नियंत्रण',
    'salary_component' => 'वेतन घटक',
    'salary_group' => 'वेतन समूह',
    'salary_tds' => 'वेतन टीडीएस',
    'overtime' => 'अतिरिक्त समय',
    'undertime' => 'कम समय',
    'payment_method' => 'भुगतान का तरीका',
    'leave_types' => 'छुट्टी के प्रकार',
    'leave_request' => 'छुट्टी का अनुरोध',
    'time_leave_request' => 'समय छुट्टी अनुरोध',

    /** company */
    'company_profile' => 'कंपनी प्रोफाइल',
    'update_company' => 'कंपनी अपडेट करें',
    'create_company' => 'कंपनी बनाएं',
    'company_name' => 'कंपनी का नाम',
    'company_owner' => 'कंपनी के मालिक',
    'address' => 'पता',
    'email_address' => 'ईमेल पता',
    'phone_no' => 'फोन नंबर',
    'website_url' => 'वेबसाइट यूआरएल',
    'check_office_off_days' => 'ऑफिस छुट्टियों की जाँच करें',
    'upload_logo' => 'लोगो अपलोड करें',
    'update' => 'अपडेट करें',
    'save' => 'सहेजें',

    /** Branch */
    'title_branch' => 'शाखा',
    'branch_section' => 'शाखा अनुभाग',
    'branches' => 'शाखाएं',
    'add_branch' => 'शाखा जोड़ें',
    'branch_lists' => 'शाखा सूचियाँ',
    'search_by_branch_name' => 'शाखा के नाम से खोजें',
    'filter' => 'फ़िल्टर',
    'reset' => 'रीसेट',
    'phone' => 'फोन',
    'total_employee' => 'कुल कर्मचारी',
    'action' => 'कार्रवाई',
    'are_you_sure_change_status' => 'क्या आप वाकई स्थिति बदलना चाहते हैं?',
    'are_you_sure_delete_branch' => 'क्या आप वाकई शाखा को हटाना चाहते हैं?',
    'branch_create' => 'शाखा बनाएँ',
    'branch_update' => 'शाखा अपडेट करें',
    'branch_name' => 'शाखा का नाम',
    'required_field' => 'आवश्यक क्षेत्र',
    'branch_head' => 'शाखा प्रमुख',
    'select_branch_head' => 'शाखा प्रमुख चुनें',
    'phone_number' => 'फोन नंबर',
    'branch_location_latitude' => 'शाखा स्थान अक्षांश',
    'enter_branch_location_latitude' => 'शाखा स्थान अक्षांश दर्ज करें',
    'branch_location_longitude' => 'शाखा स्थान देशांतर',
    'enter_branch_location_longitude' => 'शाखा स्थान देशांतर दर्ज करें',
    'status' => 'स्थिति',
    'select_status' => 'स्थिति चुनें',
    'active' => 'सक्रिय',
    'inactive' => 'निष्क्रिय',
    'create' => 'बनाएं',

    /** Department */
    'department_section' => 'विभाग अनुभाग',
    'departments' => 'विभाग',
    'add_department' => 'विभाग जोड़ें',
    'department_lists' => 'विभाग सूचियाँ',
    'search_by_department_name' => 'विभाग के नाम से खोजें',
    'select_branch' => 'शाखा चुनें',
    'edit' => 'संपादित करें',
    'delete' => 'हटाएं',
    'are_you_sure_delete_department' => 'क्या आप वाकई विभाग को हटाना चाहते हैं?',
    'edit_department' => 'विभाग संपादित करें',
    'button_back' => 'वापस',
    'breadcrumb' => 'ब्रेडक्रंब',
    'update_department' => 'विभाग अपडेट करें',
    'create_department' => 'विभाग बनाएं',
    'department_name' => 'विभाग का नाम',
    'department_head' => 'विभाग प्रमुख',
    'select_department_head' => 'विभाग प्रमुख चुनें',
    'create_update_department' => 'विभाग बनाएँ/अपडेट करें',

    /** Post */
    'post_section' => 'पोस्ट अनुभाग',
    'posts' => 'पोस्ट्स',
    'add_post' => 'पोस्ट जोड़ें',
    'search_by_department' => 'विभाग से खोजें',
    'search_by_post_name' => 'पोस्ट के नाम से खोजें',
    'post_name' => 'पोस्ट का नाम',
    'post_empty' => 'पोस्ट खाली',
    'edit_post_title' => 'पोस्ट संपादित करें',
    'create_post_title' => 'पोस्ट बनाएं',
    'department_label' => 'विभाग',
    'post_name_label' => 'पोस्ट का नाम',
    'status_label' => 'स्थिति',
    'select_department' => 'विभाग चुनें',
    'active_option' => 'सक्रिय',
    'inactive_option' => 'निष्क्रिय',
    'update_update_button' => 'पोस्ट अपडेट करें',
    'change_status_confirmation' => 'क्या आप वाकई स्थिति बदलना चाहते हैं?',
    'delete_post_confirmation' => 'क्या आप वाकई पोस्ट को हटाना चाहते हैं?',
    'employee_list_title' => 'कर्मचारी सूची',

    /** Employee List */
    'employees_title' => 'कर्मचारी',
    'employees_action' => 'सूचियाँ',
    'add_employee' => 'कर्मचारी जोड़ें',
    'employee_section' => 'कर्मचारी अनुभाग',
    'employee_create' => 'कर्मचारी बनाएँ',
    'employee_name' => 'कर्मचारी का नाम',
    'employee_email' => 'कर्मचारी का ईमेल',
    'employee_phone' => 'कर्मचारी का फोन नंबर',
    'full_name' => 'पूरा नाम',
    'designation' => 'पदनाम',
    'role' => 'भूमिका',
    'shift' => 'शिफ्ट',
    'workplace' => 'कार्यस्थल',
    'is_active' => 'सक्रिय है',
    'edit_detail' => 'विवरण संपादित करें',
    'delete_user' => 'उपयोगकर्ता हटाएं',
    'change_password' => 'पासवर्ड बदलें',
    'force_logout' => 'बलपूर्वक लॉग आउट',
    'all_fields_required' => 'सभी (<span style="color: red">*</span>) क्षेत्र आवश्यक हैं',
    'personal_detail' => 'व्यक्तिगत विवरण',
    'employee_code' => 'कर्मचारी कोड',
    'enter_name' => 'नाम दर्ज करें',
    'enter_employee_address' => 'कर्मचारी का पता दर्ज करें',
    'enter_email' => 'ईमेल दर्ज करें',
    'dob' => 'जन्म तिथि',
    'gender' => 'लिंग',
    'select_gender' => 'लिंग चुनें',
    'marital_status' => 'वैवाहिक स्थिति',
    'choose_marital_status' => 'वैवाहिक स्थिति चुनें',
    'upload_avatar' => 'अवतार अपलोड करें',
    'description' => 'विवरण',
    'username' => 'उपयोगकर्ता नाम',
    'enter_username' => 'उपयोगकर्ता नाम दर्ज करें',
    'password' => 'पासवर्ड',
    'enter_password' => 'पासवर्ड दर्ज करें',
    'select_role' => 'भूमिका चुनें',
    'company_detail' => 'कंपनी का विवरण',
    'supervisor' => 'पर्यवेक्षक',
    'employment_type' => 'रोजगार का प्रकार',
    'select_employment_type' => 'रोजगार का प्रकार चुनें',
    'joining_date' => 'शामिल होने की तिथि',
    'enter_joining_date' => 'शामिल होने की तिथि दर्ज करें',
    'workspace' => 'कार्यस्थान',
    'select_workspace' => 'कार्यस्थल चुनें',
    'field' => 'क्षेत्र',
    'office' => 'कार्यालय',
    'leave_detail' => 'छुट्टी का विवरण',
    'leave_allocated' => 'छुट्टी आवंटित',
    'assigned_leaves' => 'आवंटित छुट्टियाँ',
    'no_of_days' => 'दिनों की संख्या',
    'total_leave_days' => 'कुल छुट्टी के दिन',
    'bank_detail' => 'बैंक विवरण',
    'bank_name' => 'बैंक का नाम',
    'bank_account_number' => 'बैंक खाता संख्या',
    'account_holder_name' => 'खाता धारक का नाम',
    'bank_account_type' => 'बैंक खाता प्रकार',
    'select_account_type' => 'खाता प्रकार चुनें',
    'create_user' => 'उपयोगकर्ता बनाएं',
    'update_user' => 'उपयोगकर्ता अपडेट करें',
    'new_password' => 'नया पासवर्ड',
    'enter_new_password' => 'नया पासवर्ड दर्ज करें',
    'confirm_password' => 'पासवर्ड की पुष्टि करें',
    'confirm_password_placeholder' => 'पासवर्ड की पुष्टि करें',
    'submit' => 'प्रस्तुत करें',
    'user_change_password' => 'उपयोगकर्ता पासवर्ड बदलें',
    'confirm_delete_employee' => 'क्या आप वाकई कर्मचारी को हटाना चाहते हैं?',
    'confirm_force_logout' => 'क्या आप वाकई उपयोगकर्ता को बलपूर्वक लॉग आउट करना चाहते हैं?',
    'confirm_change_workplace' => 'क्या आप वाकई कार्यस्थल को बदलना चाहते हैं?',
    'select_supervisor' => 'पर्यवेक्षक चुनें',
    'select_office_time' => 'कार्यालय का समय चुनें',
    'select_option' => 'विकल्प चुनें',
    'enter_address' => 'कृपया पता दर्ज करें।',
    'enter_valid_email' => 'कृपया एक मान्य ईमेल पता दर्ज करें।',
    'enter_phone_number' => 'कृपया फोन नंबर दर्ज करें।',
    'create_employee' => 'कर्मचारी बनाएं',
    'add' => 'जोड़ें',
    'edit_user_detail' => 'उपयोगकर्ता विवरण संपादित करें',
    'show_user_details' => 'उपयोगकर्ता विवरण दिखाएँ',
    'detail' => 'विवरण',
    'back' => 'वापस',
    'user_detail' => 'उपयोगकर्ता विवरण',
    'date_of_birth' => 'जन्म तिथि',
    'not_applicable' => 'लागू नहीं',
    'office_detail' => 'कार्यालय का विवरण',
    'home' => 'मुख्य पृष्ठ',
    'account_detail' => 'खाता विवरण',
    'account_number' => 'खाता संख्या',
    'account_type' => 'खाता प्रकार',
    'account_holder' => 'खाता धारक',
    'not_available' => 'उपलब्ध नहीं',

    /** logout requests */
    'logout_request_status' => 'लॉगआउट अनुरोध स्थिति',
    'take_action' => 'कार्रवाई करें',
    'confirm_accept_logout_request' => 'क्या आप वाकई लॉगआउट अनुरोध को स्वीकार करना चाहते हैं?',

    /** attendance */
    'attendance' => 'उपस्थिति',
    'employee_attendance_lists' => 'कर्मचारी उपस्थिति सूचियाँ',
    'attendance_of_the_day' => 'दिन की उपस्थिति',
    'date_placeholder_bs' => 'वर्ष/माह/दिन',
    'csv_export' => 'CSV निर्यात',
    'attendance_status' => 'उपस्थिति स्थिति',
    'attendance_by' => 'द्वारा उपस्थिति',
    'show_detail' => 'विवरण दिखाएँ',
    'show_checkin_location' => 'चेक-इन स्थान दिखाएँ',
    'show_checkout_location' => 'चेक-आउट स्थान दिखाएँ',
    'checkin' => 'चेक-इन',
    'checkout' => 'चेक-आउट',
    'approved' => 'स्वीकृत',
    'rejected' => 'अस्वीकृत',
    'self' => 'स्वयं',
    'admin' => 'प्रशासक',
    'edit_attendance_time' => 'उपस्थिति समय संपादित करें',
    'employee_attendance_detail' => 'कर्मचारी उपस्थिति विवरण',
    'attendance_of' => 'की उपस्थिति',
    'total_days_in_month' => 'महीने में कुल दिन',
    'present_days' => 'उपस्थित दिन',
    'absent_days' => 'अनुपस्थित दिन',
    'weekend_days' => 'सप्ताहांत दिन',
    'holiday_days' => 'छुट्टी के दिन',
    'leave_days' => 'छुट्टी के दिन',
    'working_hours' => 'कार्य के घंटे',
    'worked_hours' => 'काम किए घंटे',
    'attendance_details_of' => 'की उपस्थिति विवरण',
    'all_month' => 'सभी महीने',
    'worked_hour' => 'काम किए घंटे',
    'add_attendance_time' => 'उपस्थिति समय जोड़ें',
    'confirm_change_attendance_status' => 'क्या आप वाकई उपस्थिति स्थिति बदलना चाहते हैं?',
    'check_in' => 'चेक इन',
    'check_out' => 'चेक आउट',
    'attendance_title' => 'उपस्थिति',
    'attendance_action' => 'कर्मचारी उपस्थिति विवरण',
    'filter_placeholder' => 'उपस्थिति वर्ष उदाहरण: :min_year',
    'filter_button' => 'फ़िल्टर',
    'csv_export_button' => 'CSV निर्यात',
    'reset_button' => 'रीसेट',
    'total_days' => 'महीने में कुल दिन',
    'attendance_details' => 'की उपस्थिति विवरण :monthName',
    'date' => 'तिथि',
    'change_attendance_status' => 'उपस्थिति स्थिति बदलें',
    'create_attendance' => 'उपस्थिति बनाएं',
    'admin_remark' => 'प्रशासक टिप्पणी',
    'edit_attendance' => 'उपस्थिति संपादित करें',
    'admin_edit_remark' => 'प्रशासक संपादित टिप्पणी',
    'confirm_check_in' => 'क्या आप वाकई कर्मचारी को चेक-इन करना चाहते हैं?',
    'confirm_check_out' => 'क्या आप वाकई कर्मचारी को चेक-आउट करना चाहते हैं?',
    'edit_attendance_title' => 'उपस्थिति संपादित करें(:name) :date का समय',
    'create_attendance_title' => 'उपस्थिति बनाएं(:name) :date का समय',
    'total_worked_hours' => 'कुल काम किए घंटे',
    'attendance_report' => 'उपस्थिति रिपोर्ट',

    /** clients */
    'client_listing' => 'ग्राहक सूची',
    'add_client' => 'ग्राहक जोड़ें',
    'client_name' => 'ग्राहक का नाम',
    'client_email' => 'ग्राहक ईमेल',
    'edit_client_detail' => 'ग्राहक विवरण संपादित करें',
    'show_client_detail' => 'ग्राहक विवरण देखें',
    'delete_client_detail' => 'ग्राहक विवरण हटाएं',
    'client_invoices' => 'ग्राहक चालान',
    'client_detail' => 'ग्राहक विवरण:',
    'client_project_lists' => 'ग्राहक परियोजना सूची:',
    'country' => 'देश',
    'edit_client' => 'ग्राहक संपादित करें',
    'create_client' => 'ग्राहक बनाएं',
    'client_section' => 'ग्राहक खंड',
    'client_contact' => 'ग्राहक संपर्क',
    'client_address' => 'पता',
    'client_country' => 'देश',
    'upload_profile' => 'ग्राहक प्रोफ़ाइल अपलोड करें',
    'enter_client_name' => 'ग्राहक का नाम दर्ज करें',
    'enter_client_email' => 'ग्राहक ईमेल दर्ज करें',
    'enter_contact_number' => 'संपर्क संख्या दर्ज करें',
    'enter_client_address' => 'ग्राहक पता दर्ज करें',
    'enter_country' => 'देश दर्ज करें',
    'confirm_status_change' => 'क्या आप निश्चित हैं कि आप स्थिति बदलना चाहते हैं?',
    'confirm_delete_client' => 'क्या आप निश्चित हैं कि आप ग्राहक विवरण को हटाना चाहते हैं?',

    /** Project management */
    'lists' => 'सूचियाँ',
    'create_project' => 'प्रोजेक्ट बनाएं',
    'project_filter' => 'प्रोजेक्ट फ़िल्टर',
    'search_by_project' => 'प्रोजेक्ट द्वारा खोजें',
    'search_by_status' => 'स्थिति द्वारा खोजें',
    'search_by_priority' => 'प्राथमिकता द्वारा खोजें',
    'client' => 'ग्राहक',
    'all_tasks' => 'सभी कार्य',
    'completed_tasks' => 'पूरे कार्य',
    'days_left' => 'बचे हुए दिन',
    'team_member' => 'टीम सदस्य',
    'start_date' => 'प्रारंभ तिथि',
    'due_date' => 'समय सीमा',
    'view' => 'देखें',
    'projects' => 'प्रोजेक्ट्स',
    'assign_employee' => 'कर्मचारी नियुक्त करें',
    'client_contact_number' => 'ग्राहक संपर्क संख्या',
    'upload_client_profile' => 'ग्राहक प्रोफ़ाइल अपलोड करें',
    'project_name' => 'प्रोजेक्ट का नाम',
    'project_start_date' => 'प्रोजेक्ट प्रारंभ दिनांक',
    'project_deadline' => 'प्रोजेक्ट समय सीमा',
    'project_status' => 'प्रोजेक्ट स्थिति',
    'select_project_status' => 'प्रोजेक्ट स्थिति चुनें',
    'project_cost' => 'प्रोजेक्ट लागत',
    'select_priority' => 'प्राथमिकता चुनें',
    'estimated_hours' => 'अनुमानित घंटे',
    'select_client' => 'ग्राहक चुनें',
    'upload_project_logo' => 'प्रोजेक्ट लोगो अपलोड करें',
    'uploaded_files_images' => 'अपलोड किए गए फ़ाइल और छवियाँ',
    'no_project_file_uploaded' => 'कोई प्रोजेक्ट फ़ाइल अपलोड नहीं की गई',
    'update_project' => 'प्रोजेक्ट अपडेट करें',
    'project_leader' => 'प्रोजेक्ट नेता',
    'assign_member' => 'सदस्य नियुक्त करें',
    'edit_project' => 'प्रोजेक्ट संपादित करें',
    'project_document' => 'प्रोजेक्ट दस्तावेज़',
    'upload_documents' => 'दस्तावेज़ अपलोड करें',
    'upload_project_attachments' => 'प्रोजेक्ट अटैचमेंट अपलोड करें',
    'show_project_detail' => 'प्रोजेक्ट विवरण देखें',
    'upload_attachments' => 'अटैचमेंट अपलोड करें',
    'project_attachments' => 'प्रोजेक्ट अटैचमेंट्स',
    'uploaded_image_files' => 'अपलोड की गई चित्र फाइलें',
    'no_project_image_found' => 'कोई प्रोजेक्ट छवि नहीं मिली',
    'uploaded_files' => 'अपलोड की गई फाइलें',
    'no_project_files_found' => 'कोई प्रोजेक्ट फ़ाइल नहीं मिली',
    'project_tasks_lists' => 'प्रोजेक्ट कार्य सूचियाँ',
    'project_summary' => 'प्रोजेक्ट सारांश',
    'cost' => 'लागत:',
    'total_hours' => 'कुल घंटे:',
    'created' => 'बनाया गया:',
    'remaining_days' => 'शेष दिन:',
    'project_leaders' => 'प्रोजेक्ट नेताओं',
    'update_leader' => 'नेता अपडेट करें',
    'project_members' => 'प्रोजेक्ट सदस्यों',
    'update_member' => 'सदस्य अपडेट करें',
    'project_client_detail' => 'प्रोजेक्ट ग्राहक विवरण',
    'delete_project_detail' => 'क्या आप प्रोजेक्ट विवरण को हटाने के लिए निश्चित हैं?',
    'delete_project_document' => 'क्या आप प्रोजेक्ट दस्तावेज़ को हटाने के लिए निश्चित हैं?',
    'search_by_member' => 'सदस्य द्वारा खोजें',
    'add_employee_to_project' => 'प्रोजेक्ट में कर्मचारी जोड़ें',

    /** Task management */
    'tasks' => 'कार्य',
    'task_filter' => 'कार्य फ़िल्टर',
    'search_by_task_name' => 'कार्य के नाम से खोजें',
    'not_started' => 'शुरू नहीं हुआ',
    'create_tasks' => 'कार्य बनाएं',
    'end_date' => 'समाप्ति तिथि',
    'task_name' => 'कार्य का नाम',
    'enter_task_name' => 'कार्य का नाम दर्ज करें',
    'select_project' => 'परियोजना का चयन करें',
    'task_start_date' => 'कार्य प्रारंभ तिथि',
    'task_start_time' => 'कार्य प्रारंभ समय',
    'task_end_date' => 'कार्य समाप्ति तिथि',
    'task_end_time' => 'कार्य समाप्ति समय',
    'task_status' => 'कार्य स्थिति',
    'select_task_status' => 'कार्य स्थिति का चयन करें',
    'uploaded_files_and_images' => 'अपलोड किए गए फ़ाइलें और छवियाँ',
    'task_attachments' => 'कार्य संलग्नक',
    'update_task' => 'कार्य अपडेट करें',
    'create_task' => 'कार्य बनाएं',
    'mention' => 'उल्लेख',
    'comment' => 'टिप्पणी',
    'close' => 'बंद करें',
    'write_comment' => 'टिप्पणी लिखें',
    'reply' => 'उत्तर दें',
    'delete_confirm' => 'क्या आप ":title" को हटाना चाहते हैं?',
    'task_member_placeholder' => 'कार्य को सदस्य के लिए असाइन करें',
    'project_placeholder' => 'परियोजना का चयन करें',
    'project_filter_placeholder' => 'परियोजना द्वारा खोजें',
    'task_name_placeholder' => 'कार्य के नाम से खोजें',
    'change_task_status_confirm' => 'क्या आप कार्य की सक्रिय स्थिति बदलना चाहते हैं?',
    'change_status_confirm' => 'क्या आप स्थिति बदलना चाहते हैं?',
    'delete_task_detail_confirm' => 'क्या आप कार्य का विवरण हटाना चाहते हैं?',
    'create_checklist_text' => 'चेकलिस्ट बनाएं',
    'close_checklist_text' => 'बंद करें',
    'remove_checklist_text' => 'हटाएं',
    'remove_checklist_title' => 'चेकलिस्ट हटाएं',
    'view_all_comments' => 'सभी टिप्पणियाँ देखें',
    'comments' => 'टिप्पणियाँ',
    'edit_task' => 'कार्य संपादित करें',
    'edit_task_detail' => 'कार्य विवरण संपादित करें',
    'show_task_detail' => 'कार्य विवरण देखें',
    'task_edit' => 'कार्य संपादित करें',
    'create_checklist' => 'चेकलिस्ट बनाएं',
    'upload_attachment' => 'संलग्नक अपलोड करें',
    'total_checklist' => 'कुल चेकलिस्ट',
    'completed_checklist' => 'पूरी चेकलिस्ट',
    'task_checklist_lists' => 'कार्य चेकलिस्ट सूची',
    'assigned_to' => 'किसे असाइन किया गया है',
    'create_task_checklist' => 'कार्य चेकलिस्ट बनाएं',
    'enter_checklist_title' => 'चेकलिस्ट शीर्षक दर्ज करें',
    'select_member' => 'सदस्य का चयन करें',
    'add_more_checklist' => 'और चेकलिस्ट जोड़ें',
    'image' => 'छवि',
    'file' => 'फ़ाइल',
    'edit_checklist' => 'चेकलिस्ट संपादित करें',
    'delete_checklist' => 'चेकलिस्ट हटाएं',
    'checklist' => 'चेकलिस्ट',
    'edit_task_checklist' => 'कार्य चेकलिस्ट संपादित करें',
    'checklist_name' => 'चेकलिस्ट नाम',
    'assign_task_checklist' => 'कार्य चेकलिस्ट असाइन करें',
    'task_summary' => 'कार्य सारांश',
    'task_members' => 'कार्य सदस्य',
    'task_attachment_title' => 'कार्य संलग्नक',
    'upload_attachment_action' => 'संलग्नक अपलोड करें',
    'upload_task_attachments' => 'कार्य संलग्नक अपलोड करें',
    'upload_task_attachments_text' => 'कार्य संलग्नक अपलोड करें',
    'choose_file_text' => 'फ़ाइल चुनें',

    /** Holiday */
    'holiday_section' => 'छुट्टी का अनुभाग',
    'event' => 'घटना',
    'event_date' => 'घटना की तारीख',
    'is_public_holiday' => 'क्या यह सार्वजनिक छुट्टी है?',
    'confirm_delete_holiday' => 'क्या आप वाकई छुट्टी विवरण हटाना चाहते हैं?',
    'holiday_detail_title' => 'छुट्टी विवरण',
    'holiday' => 'छुट्टी',
    'csv_import' => 'CSV आयात',
    'import' => 'आयात',
    'holiday_detail_csv' => 'छुट्टी विवरण CSV',
    'holiday_csv_example' => 'छुट्टी CSV उदाहरण',
    'add_holiday' => 'छुट्टी जोड़ें',
    'import_holiday_csv' => 'छुट्टी CSV आयात करें',
    'holiday_filter' => 'छुट्टी फ़िल्टर',
    'event_name' => 'घटना का नाम',
    'leave_requested_year' => 'अवकाश अनुरोधित वर्ष',
    'holiday_detail' => 'छुट्टी विवरण',

    /** notice */
    'notices_section' => 'सूचना अनुभाग',
    'notice_title' => 'सूचना शीर्षक',
    'notice_description' => 'सूचना विवरण',
    'notice_receiver' => 'सूचना प्राप्तकर्ता',
    'send_notice' => 'सूचना भेजें',
    'all_employees' => 'सभी कर्मचारियों',
    'create_notice' => 'सूचना बनाएं',
    'edit_notice' => 'सूचना संपादित करें',
    'notices' => 'सूचनाएं',
    'receiver' => 'प्राप्तकर्ता',
    'published_from' => 'से प्रकाशित',
    'publish_to' => 'तक प्रकाशित करें',
    'publish_date' => 'प्रकाशन तिथि',
    'show_notice_content' => 'सूचना की सामग्री दिखाएं',
    'delete_notice_detail' => 'सूचना विवरण हटाएं',
    'notice_lists' => 'सूचना सूचियाँ',
    'confirm_change_notice_status' => 'क्या आप सुनें की स्थिति बदलना चाहते हैं?',
    'confirm_delete_notice' => 'क्या आप सुनें की सूचना हटाना चाहते हैं?',
    'confirm_send_notice' => 'क्या आप सुनें की सूचना भेजना चाहते हैं?',
    'notice_detail_modal_title' => 'सूचना :title विस्तार',


    /** payroll */
    'employee_payroll'=>'कर्मचारी वेतन',
    'payroll_generate'=>'वेतन उत्पन्न करें',
    'payroll_create'=>'वेतन बनाएं',
    'payroll_edit'=>'वेतन संपादित करें',
    'select_year' => 'वर्ष चुनें',
    'salary_cycle' => 'वेतन चक्र',
    'salary_month' => 'वेतन माह',
    'salary_week' => 'वेतन सप्ताह',
    'select_week' => 'सप्ताह चुनें',
    'include_tada' => 'TADA शामिल करें',
    'include_advance_salary' => 'अग्रिम वेतन शामिल करें',
    'use_attendance' => 'उपस्थिति का उपयोग करें',
    'generate' => 'उत्पन्न करें',
    'clear' => 'साफ करें',
    'report' => 'रिपोर्ट:',
    'duration' => 'अवधि',
    'payroll_summary' => 'वेतन सारांश',
    'total_basic_salary' => 'कुल मूल वेतन:',
    'total_net_salary' => 'कुल शुद्ध वेतन:',
    'total_allowance' => 'कुल भत्ता:',
    'total_deduction' => 'कुल कटौती:',
    'total_overtime' => 'कुल ओवरटाइम:',
    'total_undertime' => 'कुल अंडरटाइम:',
    'paid_by'=>'द्वारा भुगतान किया गया',
    'net_salary'=>'शुद्ध वेतन',
    'paid_on'=>'भुगतान किया गया दिनांक',
    'pay_button' => 'भुगतान करें',
    'select_payment_method.'=>'कृपया भुगतान विधि चुनें।',
    'confirm_delete_payroll'=>'क्या आप वाकई कर्मचारी वेतन को हटाना चाहते हैं?',
    'confirm_generate_payroll'=>'क्या आप वाकई वेतन उत्पन्न करना चाहते हैं?',
    'confirm_change_cycle'=>'क्या आप वाकई वेतन चक्र बदलना चाहते हैं?',
    'payment_title' => 'भुगतान करें',
    'payment_method_placeholder' => 'भुगतान विधि चुनें',
    'payment_date' => 'भुगतान की तिथि',
    'hourly_rate' => 'प्रति घंटा दर',
    'hourly' => 'प्रति घंटा',
    'working_hours_in_week' => 'सप्ताह में काम के घंटे',
    'annual_salary' => 'वार्षिक वेतन (CTC)',
    'annual' => 'वार्षिक',
    'basic_salary' => 'मूल वेतन',
    'fixed_allowance' => 'नियत भत्ता',
    'total' => 'कुल',
    'net_total' => 'शुद्ध कुल',
    'earnings' => 'कमाई',
    'deductions' => 'कटौती',
    'create_salary '=>'वेतन बनाएं',
    'edit_salary '=>'वेतन संपादित करें',
    'add_salary '=>'वेतन जोड़ें',
    'calculation_type'=>'गणना प्रकार',
    'monthly_amount'=>'मासिक राशि',
    'annual_amount'=>'वार्षिक राशि',
    'salary_slip' => 'वेतन पर्ची',
    'edit_salary_slip' => 'वेतन पर्ची संपादित करें',
    'payslip' => 'वेतन पर्ची',
    'for_the_month_of' => 'माह के लिए',
    'from'=>'से',
    'to'=>'तक',
    'employee_id'=>'कर्मचारी आईडी',
    'earning' => 'कमाई',
    'deduction' => 'कटौती',
    'actual_salary' => 'वास्तविक वेतन',
    'total_earning'=>'कुल कमाई',
    'actual_salary_formula' => '(कुल कमाई - कुल कटौती)',
    'bonus' => 'बोनस',
    'taxable_salary' => 'कर योग्य वेतन',
    'taxable_salary_formula' => '(वास्तविक वेतन + बोनस)',
    'tax' => 'कर',
    'salary_after_tax' => 'कर के बाद वेतन',
    'expenses_claim' => 'व्यय दावें (TADA)',
    'absent' => 'अनुपस्थित',
    'absent_deduction_formula' => '((सकल वेतन / कुल दिन) * अनुपस्थित दिन)',
    'net_salary_formula' => 'शुद्ध वेतन = (वास्तविक वेतन - अग्रिम वेतन + TADA)',
    'monthly' => 'मासिक',
    'weekly' => 'साप्ताहिक',
    'salary_increment' => 'वेतन वृद्धि',
    'increment' => 'वृद्धि',
    'current_salary' => 'वर्तमान वेतन',
    'annual_increment_percent' => 'वार्षिक वृद्धि %',
    'annual_increment_amount' => 'वार्षिक वृद्धि राशि',
    'revised_salary_label' => 'संशोधित वेतन',
    'fiscal_year_label' => 'वित्तीय वर्ष के लिए वृद्धि',
    'applicable_from_label' => 'लागू तिथि से (दिनांक)',
    'applicable_to_label' => 'लागू तिथि तक (दिनांक)',
    'remark' => 'टिप्पणी',
    'fiscal_year' => 'वित्तीय वर्ष',
    'select_fiscal_year' => 'वित्तीय वर्ष चुनें',
    'list'=>'सूची',
    'employee_salary_filter'=>'कर्मचारी वेतन फ़िल्टर',
    'salary_review_history'=>'वेतन समीक्षा इतिहास',
    'increase_salary'=>'वेतन बढ़ाएं',
    'all'=>'सभी',
    'employee_payslip'=>'कर्मचारी वेतन पर्ची',
    'salary_from'=>'वेतन से',
    'salary_to'=>'वेतन तक',
    'unpaid_leave'=>'अवैतनिक अवकाश',
    'paid_leave'=>'वेतन अवकाश',
    'employee_gross_salary'=>'कर्मचारी सकल वेतन',
    'salary_increment_log'=>'वेतन वृद्धि लॉग',
    'log'=>'लॉग',
    'salary_revised_on'=>'वेतन संशोधित किया गया',
    'increment_by'=>'द्वारा वृद्धि',
    'increment_value'=>'वृद्धि मूल्य',
    'old_salary'=>'पुराना वेतन',
    'new_salary'=>'नया वेतन',
    'date_to'=>'तिथि तक',
    'date_from'=>'तिथि से',
    'salary_increment_remark'=>'वेतन वृद्धि टिप्पणी',
    'advance_salary_requests'=>'अग्रिम वेतन अनुरोध',
    'advance_salary_request_filter'=>'अग्रिम वेतन अनुरोध फ़िल्टर',
    'delete_confirmation'=>'क्या आप वाकई हटाना चाहते हैं?',
    'payslip_for_the_month_of'=>'माह के लिए वेतन पर्ची',
    'absent_deduction'=>'अनुपस्थिति कटौती',


    /** Advance Salary */
    'is_paid' => 'क्या भुगतान किया गया?',
    'released_on' => 'जारी किया गया',
    'requested_on' => 'अनुरोध की तारीख',
    'released_amount' => 'जारी की गई राशि',
    'requested_amount' => 'अनुरोधित राशि',
    'search_by_month' => 'महीने के आधार पर खोजें',
    'search_by_employee_name' => 'कर्मचारी नाम के आधार पर खोजें',
    'advance_salary_detail' => 'अग्रिम वेतन विवरण',
    'is_settled' => 'सुलझा हुआ',
    'verified_by' => 'द्वारा सत्यापित',
    'amount_released_date' => 'राशि जारी करने की तिथि',
    'advance_requested_date' => 'अग्रिम अनुरोध की तिथि',
    'total_released_amount' => 'कुल जारी की गई राशि',
    'total_request_amount' => 'कुल अनुरोधित राशि',
    'employee' => 'कर्मचारी',
    'select_employee' => 'कर्मचारी चुनें',
    'advance_salary_request_detail' => 'अग्रिम वेतन अनुरोध विवरण',
    'proof_of_advance_salary_payment' => 'अग्रिम वेतन भुगतान का प्रमाण',
    'attachments' => 'अटैचमेंट्स',
    'processing' => 'प्रोसेसिंग',

    /** Tax report */
    'tax_report' => 'कर रिपोर्ट',
    'employee_tax_report' => 'कर्मचारी कर रिपोर्ट',
    'tax_report_edit' => 'कर रिपोर्ट संपादित करें',
    'tax_report_detail_of' => 'कर रिपोर्ट की जानकारी',
    'tax_report_detail' => 'कर रिपोर्ट विवरण',
    'salary_sheet' => 'वेतन पत्रक',
    'particular' => 'विशेष',
    'income' => 'आय',
    'tax_data_not_available' => 'वर्तमान वैवाहिक स्थिति के लिए कोई कर डेटा उपलब्ध नहीं है',
    'remain_tds_formula' => '(कुल देय TDS / शेष महीनों की संख्या)',
    'remaining_month' => 'शेष महीना',
    'tds_calculation_msg' => 'वर्तमान माह के लिए TDS गणना (गणना माह)',
    'total_due_tds' => 'कुल देय TDS',
    'total_paid_tds' => 'कुल भुगतान किए गए TDS',
    'total_payable_tds' => 'कुल भुगतान योग्य TDS',
    'other_discount' => 'अन्य छूट',
    'female_discount' => 'महिला छूट',
    'medical_claim' => 'चिकित्सा दावा',
    'less' => 'कम',
    'less_tax_deduction' => 'कम: कर कटौती',
    'tax_amount' => 'कर राशि',
    'percent' => 'प्रतिशत',
    'tax_calculation_on_taxable_income' => 'कर योग्य आय पर कर गणना',
    'taxable_income' => 'कर योग्य आय',
    'ssf_contribution' => 'SSF योगदान',
    'ssf_contribution_salary' => 'SSF योगदान वेतन',
    'total_retirement_contribution_allowed' => 'कुल रिटायरमेंट योगदान अनुमत',
    'total_income' => 'कुल आय',
    'amount' => 'राशि',
    'additional_information' => 'अधिक जानकारी',
    'total_payable' => 'कुल देय',
    'tds_paid' => 'भुगतान किए गए TDS',
    'ssf_deduction' => 'SSF कटौती',
    'tax_report_generate' => 'कर रिपोर्ट जनरेट करें',
    'print' => 'प्रिंट',
    'gross_earnings' => 'कुल आय',
    'tax_payable' => 'कर देय',

    /** Payroll Setting  */
    'advance_salary_limit' => 'एडवांस सैलरी लिमिट',
    'select_month' => 'माह चुनें',
    'applicable_month' => 'लागू माह',
    'value' => 'मान',
    'value_type' => 'मान प्रकार',
    'enter_bonus_type' => 'बोनस प्रकार दर्ज करें',
    'salary_components' => 'वेतन घटक',
    'add_bonus' => 'बोनस जोड़ें',
    'max_daily_ot' => 'अधिकतम दैनिक ओवरटाइम',
    'assign_overtime_to_employee' => 'कर्मचारी को ओवरटाइम सौंपें',
    'overtime_pay_rate' => 'ओवरटाइम भुगतान दर (प्रति घंटा)',
    'overtime_rate_percent' => 'ओवरटाइम दर प्रतिशत (प्रति घंटा)',
    'placeholder_overtime_pay_rate' => 'ओवरटाइम भुगतान दर दर्ज करें',
    'placeholder_overtime_rate_percent' => 'ओवरटाइम दर प्रतिशत दर्ज करें',
    'rate_type' => 'दर प्रकार',
    'select_rate_type' => 'दर प्रकार चुनें',
    'ot_valid_after_hour' => 'ओवरटाइम वैध के बाद? घंटा',
    'placeholder_ot_valid_after_hour' => 'घंटे दर्ज करें जिनके बाद ओवरटाइम वैध है',
    'monthly_ot' => 'अधिकतम मासिक ओवरटाइम घंटा',
    'placeholder_monthly_ot' => 'अधिकतम मासिक ओवरटाइम घंटा दर्ज करें',
    'weekly_ot' => 'अधिकतम साप्ताहिक ओवरटाइम घंटा',
    'placeholder_weekly_ot' => 'अधिकतम साप्ताहिक ओवरटाइम घंटा दर्ज करें',
    'daily_ot' => 'अधिकतम दैनिक ओवरटाइम घंटा',
    'placeholder_daily_ot' => 'अधिकतम दैनिक ओवरटाइम घंटा दर्ज करें',
    'pay_percent' => 'भुगतान प्रतिशत/दर',
    'employee_count' => 'कर्मचारी गणना',
    'hour' => 'घंटा',
    'currency_setting' => 'मुद्रा सेटिंग',
    'payroll_currency' => 'पेरोल मुद्रा',
    'choose_payroll_currency' => 'पेरोल मुद्रा चुनें',
    'add_payment_method' => 'भुगतान विधि जोड़ें',
    'payment_method_name' => 'भुगतान विधि का नाम',
    'update_payment_method' => 'भुगतान विधि अपडेट करें',
    'component_value' => 'घटक मूल्य',
    'component_type' => 'घटक प्रकार',
    'add_salary_component' => 'वेतन घटक जोड़ें',
    'apply_for_all' => 'सभी के लिए लागू करें',
    'component_value_annual' => 'घटक मूल्य (वार्षिक)',
    'select_value_type' => 'मान प्रकार चुनें',
    'select_component_type' => 'घटक प्रकार चुनें',
    'enter_salary_component_name' => 'वेतन घटक का नाम दर्ज करें',
    'add_salary_group' => 'वेतन समूह जोड़ें',
    'delete_confirm_salary_group' => 'क्या आप निश्चित हैं कि आप समूह विवरण हटाना चाहते हैं?',
    'assign_employee_to_group' => 'कर्मचारी को समूह सौंपें',
    'choose_salary_component' => 'वेतन घटक चुनें',
    'assign_salary_components' => 'वेतन घटक सौंपें',
    'enter_salary_group_name' => 'वेतन समूह का नाम दर्ज करें',
    'add_more_tds_detail' => 'अधिक TDS विवरण जोड़ें',
    'enter_tds_in_percent' => 'TDS प्रतिशत में दर्ज करें',
    'enter_annual_salary_to' => 'वार्षिक वेतन तक दर्ज करें',
    'enter_annual_salary_from' => 'वार्षिक वेतन से दर्ज करें',
    'select_marital_status' => 'वैवाहिक स्थिति चुनें',
    'create_salary_tds' => 'वेतन TDS बनाएं',
    'update_salary_tds' => 'वेतन TDS अपडेट करें',
    'salary_tds_detail_for_single' => 'अविवाहितों के लिए वेतन TDS विवरण',
    'add_salary_tds' => 'वेतन TDS जोड़ें',
    'annual_salary_to' => 'वार्षिक वेतन तक',
    'annual_salary_from' => 'वार्षिक वेतन से',
    'tds' => 'TDS (%)',
    'salary_tds_detail_for_married' => 'विवाहितों के लिए वेतन TDS विवरण',
    'ssf' => 'SSF',
    'employee_contribution' => 'कर्मचारी योगदान',
    'office_contribution' => 'कार्यालय योगदान',
    'assign_undertime_to_employee' => 'कर्मचारी को कम समय सौंपें',
    'enter_title' => 'शीर्षक दर्ज करें',
    'undertime_after_minute' => 'कम समय लागू होने के बाद मिनट',
    'placeholder_ut_after' => 'घंटे दर्ज करें जिनके बाद कम समय लागू होता है',
    'penalty_type' => 'दंड प्रकार',
    'select_penalty_type' => 'दंड प्रकार चुनें',
    'penalty_percent' => 'दंड प्रतिशत (प्रति घंटा)',
    'penalty_percent_placeholder' => 'कम समय के लिए दंड प्रतिशत दर्ज करें',
    'penalty_rate' => 'दंड दर (प्रति घंटा)',
    'penalty_rate_placeholder' => 'कम समय के लिए दंड दर दर्ज करें',

    /** Leave */
    'leave_type_section' => 'अवकाश प्रकार अनुभाग',
    'select_leave_type' => 'अवकाश प्रकार चुनें',
    'leave_type' => 'अवकाश प्रकार',
    'leave_allocated_days' => 'आवंटित अवकाश दिन',
    'allocated_days' => 'आवंटित दिन',
    'is_paid_leave' => 'क्या यह वेतनभोगी अवकाश है',
    'leave_type_name' => 'अवकाश प्रकार का नाम',
    'leave_type_placeholder' => 'अवकाश प्रकार दर्ज करें',
    'add_leave_type' => 'अवकाश प्रकार जोड़ें',
    'type' => 'प्रकार',
    'edit_leave_type_detail' => 'अवकाश प्रकार विवरण संपादित करें',
    'delete_leave_type' => 'अवकाश प्रकार हटाएं',
    'delete_leave_confirmation' => 'क्या आप सुनिश्चित हैं कि आप अवकाश प्रकार हटाना चाहते हैं?',
    'leave_request_section' => 'अवकाश अनुरोध अनुभाग',
    'approve' => 'स्वीकृत करें',
    'reject' => 'अस्वीकृत करें',
    'from_date' => 'तारीख से',
    'to_date' => 'तारीख तक',
    'start_time' => 'आरंभ समय',
    'end_time' => 'समाप्ति समय',
    'reason' => 'कारण',
    'requested_for' => 'के लिए अनुरोध किया गया',
    'requested_by' => 'द्वारा अनुरोध किया गया',
    'requested_days' => 'अनुरोध किए गए दिन',
    'requested_date' => 'अनुरोध की तारीख',
    'all_status' => 'सभी स्थिति',
    'all_leave_type' => 'सभी अवकाश प्रकार',
    'leave_request_filter' => 'अवकाश अनुरोध फ़िल्टर',
    'create_leave_request' => 'अवकाश अनुरोध बनाएँ',
    'leave_reason' => 'अवकाश का कारण',
    'referred_by' => 'द्वारा संदर्भित',
    'leave_date' => 'अवकाश की तारीख',
    'time_leave_request_filter' => 'समय आधारित अवकाश अनुरोध फ़िल्टर',
    'create_time_leave_request' => 'समय आधारित अवकाश अनुरोध बनाएँ',
    'time_leave_request_section' => 'समय आधारित अवकाश अनुरोध अनुभाग',
    'time_leave_status_update' => 'समय आधारित अवकाश स्थिति अद्यतन',

    /** Team Meeting */
    'team_meeting_section' => 'टीम मीटिंग अनुभाग',
    'update_and' => 'अपडेट और',
    'create_and' => 'बनाएँ और',
    'send' => 'भेजें',
    'meeting_participator' => 'मीटिंग प्रतिभागी',
    'image_hint' => 'चित्र को क्षैतिज रूप में होना अनुशंसित है',
    'meeting_description' => 'मीटिंग विवरण',
    'upload_image' => 'चित्र अपलोड करें',
    'meeting_start_time' => 'मीटिंग प्रारंभ समय',
    'meeting_date' => 'मीटिंग की तारीख',
    'meeting_venue' => 'मीटिंग स्थल',
    'enter_venue_name' => 'स्थल का नाम दर्ज करें',
    'enter_content_title' => 'सामग्री का शीर्षक दर्ज करें',
    'meeting_title' => 'मीटिंग का शीर्षक',
    'delete_team_meeting_confirmation' => 'क्या आप निश्चित हैं कि आप टीम मीटिंग को हटाना चाहते हैं?',
    'image_delete_confirmation' => 'क्या आप निश्चित हैं कि आप चित्र को हटाना चाहते हैं?',
    'create_team_meeting' => 'टीम मीटिंग बनाएँ',
    'delete_team_meeting' => 'टीम मीटिंग विवरण हटाएँ',
    'edit_meeting_detail' => 'मीटिंग विवरण संपादित करें',
    'show_team_meeting' => 'टीम मीटिंग सामग्री दिखाएँ',
    'participators' => 'प्रतिभागी',
    'participator' => 'प्रतिभागी',
    'team_meeting_filter' => 'टीम मीटिंग फ़िल्टर',
    'agenda' => 'एजेंडा',
    'creator' => 'निर्माता',

    /** Tada */
    'tada_attachment' => 'Tada अटैचमेंट',
    'upload_tada_attachment' => 'Tada अटैचमेंट अपलोड करें',
    'accepted' => 'स्वीकृत',
    'tada_status_change' => 'क्या आप सुनिश्चित हैं कि आप Tada निपटान की स्थिति बदलना चाहते हैं?',
    'delete_tada_confirm' => 'क्या आप सुनिश्चित हैं कि आप :title को हटाना चाहते हैं?',
    'uploaded_attachment' => 'अपलोड किया गया अटैचमेंट',
    'no_attachment_file' => 'कोई अटैचमेंट फ़ाइल नहीं',
    'total_expense' => 'कुल खर्च',
    'create_tada' => 'Tada बनाएं',
    'edit_tada' => 'Tada संपादित करें',
    'tada_listing' => 'Tada लिस्टिंग',
    'tada_filter' => 'Tada फ़िल्टर',
    'submitted_date' => 'प्रस्तुत तिथि',
    'expense' => 'खर्च',
    'tada_detail' => 'Tada विवरण',
    'verified_date' => 'सत्यापित तिथि',
    'tada_summary' => 'Tada सारांश',
    'update_status' => 'स्थिति अपडेट करें',
    'category' => 'श्रेणी',
    'select_category' => 'श्रेणी चुनें',
    'opening_time' => 'खुलने का समय',
    'closing_time' => 'बंद करने का समय',
    'checkin_checkout_rule' => 'चेक-इन/चेक-आउट नियम',
    'early_check_in' => 'अर्ली चेक-इन',
    'check_in_before' => 'चेक-इन करने से पहले (मिनट में) कर सकते हैं',
    'checkin_before' => 'चेक-इन पहले',
    'enter_check_in_before' => 'कितने मिनट पहले चेक-इन कर सकते हैं दर्ज करें',
    'early_check_out' => 'अर्ली चेक-आउट',
    'check_out_before' => 'चेक-आउट करने से पहले (मिनट में) कर सकते हैं',
    'checkout_before' => 'चेक-आउट पहले',
    'enter_check_out_before' => 'कितने मिनट पहले चेक-आउट कर सकते हैं दर्ज करें',
    'late_check_in' => 'लेट चेक-इन',
    'check_in_after' => 'चेक-इन करने के बाद (मिनट में) कर सकते हैं',
    'checkin_after' => 'चेक-इन बाद',
    'enter_check_in_after' => 'कितने मिनट बाद चेक-इन कर सकते हैं दर्ज करें',
    'late_check_out' => 'लेट चेक-आउट',
    'checkout_after' => 'चेक-आउट बाद',
    'check_out_after' => 'चेक-आउट करने के बाद (मिनट में) कर सकते हैं',
    'enter_check_out_after' => 'कितने मिनट बाद चेक-आउट कर सकते हैं दर्ज करें',
    'enter_shift_name' => 'शिफ्ट का नाम दर्ज करें',
    'select_shift' => 'शिफ्ट चुनें',
    'delete_office_time_confirm' => 'क्या आप सुनिश्चित हैं कि आप ऑफिस शेड्यूल हटाना चाहते हैं?',
    'office_time_detail' => 'ऑफिस समय विवरण',
    'office_schedule' => 'ऑफिस शेड्यूल',
    'add_office_time' => 'ऑफिस समय जोड़ें',

    /** Award Types */
    'award_distributed' => 'पुरस्कार वितरित किया गया',
    'add_award_types' => 'पुरस्कार प्रकार जोड़ें',
    'gift_item' => 'उपहार आइटम',
    'awarded_date' => 'पुरस्कार की तिथि',

    /** Award */
    'award' => 'पुरस्कार',
    'award_name' => 'पुरस्कार का नाम',
    'select_award_type' => 'पुरस्कार प्रकार चुनें',
    'enter_gift_item' => 'उपहार आइटम दर्ज करें',
    'award_base' => 'पुरस्कार आधार',
    'select_award_base' => 'पुरस्कार आधार चुनें',
    'awarded_by' => 'द्वारा प्रदान किया गया',
    'enter_awarded_by' => 'प्रदानकर्ता दर्ज करें',
    'award_description' => 'पुरस्कार विवरण',
    'gift_description' => 'उपहार विवरण',
    'reward_code' => 'इनाम कोड',
    'enter_reward_code' => 'इनाम कोड दर्ज करें',
    'add_award' => 'पुरस्कार जोड़ें',
    'attachment' => 'अटैचमेंट',
    'award_lists' => 'पुरस्कार सूची',

    /** Asset Types */
    'add_asset_types' => 'संपत्ति प्रकार जोड़ें',
    'asset_item_count' => 'संपत्ति आइटम की संख्या',
    'asset_type' => 'संपत्ति प्रकार',
    'asset_name' => 'संपत्ति का नाम',
    'purchased_date' => 'खरीद की तारीख',
    'is_working' => 'काम कर रहा है',
    'is_available' => 'उपलब्ध है',
    'asset' => 'संपत्ति',

    /** Assets */
    'select_asset_type' => 'संपत्ति प्रकार चुनें',
    'assigned_date' => 'असाइन की गई तारीख',
    'is_available_for_employee' => 'कर्मचारी के लिए उपलब्ध है',
    'select_availability' => 'उपलब्धता चुनें',
    'warranty_end_date' => 'वारंटी समाप्ति तिथि',
    'warranty_available' => 'वारंटी उपलब्ध है',
    'select_warranty_availability' => 'वारंटी उपलब्धता चुनें',
    'asset_serial_number' => 'संपत्ति का सीरियल नंबर',
    'enter_asset_serial_number' => 'संपत्ति का सीरियल नंबर दर्ज करें',
    'asset_code' => 'संपत्ति कोड',
    'enter_asset_code' => 'संपत्ति कोड दर्ज करें',
    'change_availability_status' => 'क्या आप सुनिश्चित हैं कि आप उपलब्धता स्थिति बदलना चाहते हैं?',
    'delete_asset_confirm' => 'क्या आप सुनिश्चित हैं कि आप :title को हटाना चाहते हैं?',
    'add_asset' => 'संपत्ति जोड़ें',
    'asset_image' => 'संपत्ति की छवि',
    'asset_assigned_employee' => 'संपत्ति को सौंपा गया कर्मचारी',
    'assets_filter' => 'संपत्ति फ़िल्टर',
    'working_status' => 'कार्यात्मक स्थिति',
    'availability_status' => 'उपलब्धता स्थिति',
    'yes_available' => 'हां, उपलब्ध है',
    'notavailable' => 'उपलब्ध नहीं',
    'purchased_from' => 'खरीद की गई जगह से',
    'purchased_to' => 'खरीदी गई जगह पर',

    /** Content Management */
    'content_section' => 'सामग्री अनुभाग',
    'content' => 'सामग्री',
    'content_type' => 'सामग्री प्रकार',
    'content_title' => 'सामग्री का शीर्षक',
    'select_content_type' => 'सामग्री प्रकार चुनें',
    'delete_content_confirm' => 'क्या आप सुनिश्चित हैं कि आप स्थिर पृष्ठ सामग्री को हटाना चाहते हैं?',
    'company_static_content' => 'कंपनी की स्थिर सामग्री',
    'add_content' => 'सामग्री जोड़ें',

    /** Support */
    'delete_support_confirm' => 'क्या आप सुनिश्चित हैं कि आप :title हटाना चाहते हैं?',
    'ticket_lists' => 'टिकट सूचियाँ',
    'query_by' => 'पूछताछ द्वारा',
    'concerned_department' => 'संबंधित विभाग',
    'unseen' => 'अदृश्य',
    'read_status' => 'पढ़ने की स्थिति',
    'seen' => 'देखा',
    'query_status' => 'पूछताछ की स्थिति',
    'support_filter' => 'सहायता फ़िल्टर',
    'query_lists' => 'पूछताछ की सूचियाँ',
    'department_support_requested_from' => 'विभाग से अनुरोधित समर्थन',
    'department_support_requested_to' => 'विभाग को अनुरोधित समर्थन',
    'change_query_status' => 'पूछताछ की स्थिति बदलें',

    /** Router */
    'router_section' => 'राउटर अनुभाग',
    'router_bssid' => 'राउटर BSSID',
    'router' => 'राउटर',
    'router_detail' => 'राउटर विवरण',
    'add_router' => 'राउटर जोड़ें',

    /** QR */
    'scan_me' => 'मुझे स्कैन करें',
    'attendance_qr' => 'हाजिरी QR',
    'qr_image' => 'QR छवि',
    'add_qr' => 'QR जोड़ें',
    'qr_section' => 'QR अनुभाग',

    /** NFC */
    'nfc_section' => 'NFC अनुभाग',
    'created_by' => 'द्वारा निर्मित',

    /** Role and permission */
    'role_section' => 'भूमिका अनुभाग',
    'autorize_backend_login' => 'बैकेंड लॉगिन को अधिकृत करें',
    'role_name' => 'भूमिका का नाम',
    'permissions' => 'अनुमतियाँ',
    'check_all' => 'सभी चुनें',
    'module' => 'मॉड्यूल',
    'add_role' => 'भूमिका जोड़ें',
    'assign_permissions' => 'अनुमतियाँ सौंपें',
    'confirm_role_deletion' => 'क्या आप सुनिश्चित हैं कि आप भूमिका को हटाना चाहते हैं?',
    'can_login' => 'लॉगिन कर सकता है',
    'permission_setting' => 'अनुमति सेटिंग',
    'assign' => 'सौंपें',

    /** General Setting */
    'general_setting_section' => 'सामान्य सेटिंग अनुभाग',
    'general_setting' => 'सामान्य सेटिंग',

    /** App Setting */
    'export_database_data' => 'डाटाबेस डेटा निर्यात करें',
    'check_router_bssid' =>'राउटर BSSID जांचें',

    /** Fiscal Years */
    'fiscal_years' => 'वित्तीय वर्ष',
    'year' => 'वर्ष',
    'add_fiscal_year' => 'वित्तीय वर्ष जोड़ें',

    /** Notifications */
    'notification_section' => 'सूचना अनुभाग',
    'confirm_notification_send' => 'क्या आप सुनिश्चित हैं कि आप सूचना भेजना चाहते हैं?',
    'notification' => 'सूचना',
    'published_date' => 'प्रकाशन की तिथि',
    'all_types' => 'सभी प्रकार',
    'notification_lists' => 'सूचना सूचियाँ',
    'notified_member' => 'सूचित सदस्य',
    'notification_title' => 'सूचना का शीर्षक',
    'notification_description' => 'सूचना का विवरण',
    'send_notification' => 'सूचना भेजें',
    'enter_notification_title' => 'सूचना का शीर्षक दर्ज करें',

    /** feature control */
    'app_setting' => 'ऐप सेटिंग',
    'sn' => 'क्रमांक',
    'group' => 'समूह',
    'export_table_data' => 'तालिका डेटा निर्यात करें',
    'leave_requests' => 'छुट्टी के अनुरोध',
    'employee_lists' => 'कर्मचारी सूचियाँ',
    'attendances' => 'उपस्थितियाँ',
    'confirm_change_status' => 'क्या आप वाकई स्थिति बदलना चाहते हैं?',
    'yes' => 'हाँ',
    'no' => 'नहीं',

    /** Api response */
    /** Auth Controller */
    'invalid_login_credentials'=>'अमान्य लॉगिन क्रेडेंशियल्स!',
    'authenticated'=>'प्रमाणित',
    'user_detail_not_found'=>'उपयोगकर्ता विवरण नहीं मिला',
    'partial_logout_successful'=>'आंशिक लॉगआउट सफल',
    /** Dashboard Controller */
    'data_found'=>'डेटा मिला',
    /** AdvanceSalary Controller */
    'advance_salary_pending_error'=>'जब तक पिछली अग्रिम अनुरोध का निपटारा नहीं हो जाता, तब तक एक और अग्रिम वेतन अनुरोध नहीं किया जा सकता है।',
    'data_updated_successfully'=>'डेटा सफलतापूर्वक अपडेट किया गया',
    'user_updated_advance_salary_request' => ':name ने अग्रिम वेतन अनुरोध का विवरण अपडेट किया',
    'data_created_successfully'=>'डेटा सफलतापूर्वक बनाया गया',
    'advance_salary_request_alert'=>'अग्रिम वेतन अनुरोध अलर्ट',
    'user_submitted_advance_salary_request' => ':name ने :amount राशि का अग्रिम वेतन अनुरोध प्रस्तुत किया है',
    /** Attendance Api */
    'check_out_successful'=>'चेकआउट सफल',
    'check_out_notification'=>'चेकआउट सूचना',
    'check_in_successful'=>'चेकइन सफल',
    'check_in_notification'=>'चेकइन सूचना',
    'not_checked_in_yet'=>'अभी तक चेकइन नहीं किया गया',
    'alert_multi_checkin_shift'=>'क्षमा करें! कर्मचारी एक शिफ्ट में दो बार चेक इन नहीं कर सकता।',
    'checkout_alert_for_shift'=>'कर्मचारी पहले ही शिफ्ट के लिए चेकआउट कर चुका है',
    'alert_checkin'=>'क्षमा करें! कर्मचारी एक दिन में दो बार चेकइन नहीं कर सकता।',
    'checkout_alert'=>'कर्मचारी ने पहले ही आज चेकआउट कर लिया है',
    'attendance_alert_status'=>':status पहले ही किया जा चुका है',
    'employee_checked_in' => ':name ने :time पर चेकइन किया है',
    'employee_checked_out' => ':name ने :time पर चेकआउट किया है',
    'has_worked_for' => 'और :time के लिए काम किया है',
    'multi_checkout_warning'=>'आपने आज के लिए अनुमत चेकइन और चेकआउट की अधिकतम संख्या को पूरा कर लिया है।',
    'employee_checked_out_and_worked' => ':name ने :check_out_time पर चेकआउट किया है और :worked_time के लिए काम किया है',
    'invalid_attendance_type'=>'अमान्य उपस्थिति प्रकार।',
    'invalid_qr'=>'अमान्य QR या QR उपलब्ध नहीं है',
    'invalid_nfc'=>'अमान्य NFC टोकन या NFC उपलब्ध नहीं है',
    'validation_failed'=>'मान्यता विफल हुई',

    /** Leave Api Controller */
    'leave_request_cancelled' => 'अवकाश अनुरोध सफलतापूर्वक रद्द कर दिया गया',
    'leave_request_cannot_be_cancelled' => 'एक बार स्थिर स्थिति से अपडेट होने के बाद अवकाश अनुरोध रद्द नहीं किया जा सकता।',
    'leave_request_notification' => 'अवकाश अनुरोध सूचना',
    'leave_request_submitted' => ':name ने :issue_date को :start_time से :end_time तक अवकाश अनुरोध किया है। कारण: :reasons',
    'leave_request_submitted_successfully' => 'अवकाश अनुरोध सफलतापूर्वक प्रस्तुत किया गया',
    'leave_request_cancelled_successfully' => 'अवकाश अनुरोध सफलतापूर्वक रद्द कर दिया गया',
    'leave_request_submit' => ':name ने :leave_requested_date को :leave_from से :no_of_days दिन(s) का अवकाश अनुरोध किया है। कारण: :reasons',

    /** NFC api Controller */
    'nfc_token_already_exist' => 'NFC टोकन पहले से मौजूद है।',
    'nfc_added_successfully' => 'NFC सफलतापूर्वक जोड़ा गया',

    /** Notification Api Controller */
    'updated_successfully' => 'सफलतापूर्वक अपडेट किया गया',
    'successfully_sent_notification' => 'सूचना सफलतापूर्वक भेजी गई',
    'data_not_found' => 'डेटा नहीं मिला',
    'content_not_found' => 'सामग्री नहीं मिली',

    /** Support Api Controller */
    'support_notification' => 'समर्थन सूचना',
    'support_request_submitted' => ':name ने समर्थन के लिए अनुरोध किया है।',
    'query_submitted_successfully' => 'प्रश्न सफलतापूर्वक प्रस्तुत किया गया',

    /** Tada Api Controller  */
    'attachment_detail_not_found' => 'अटैचमेंट विवरण नहीं मिला',
    'cannot_delete_attachment_detail' => 'एक बार सत्यापित हो जाने के बाद अटैचमेंट विवरण को मेटा नहीं जा सकता',
    'upload_another_attachment_before_delete' => 'मेटाने से पहले कृपया एक और अटैचमेंट अपलोड करें।',
    'attachment_deleted_successfully' => 'अटैचमेंट सफलतापूर्वक मेटा गया',
    'tada_update_alert' => 'आप सत्यापित होने के बाद विवरण अपडेट नहीं कर सकते, कृपया व्यवस्थापक से संपर्क करें',
    'tada_notification' => ':name ने :title के लिए नया TADA प्रस्तुत किया',
    'tada_detail_notification' => ':name ने :title प्रस्तुत TADA विवरण को अपडेट किया',
    'tada_alert' => 'TADA अलर्ट',

    /** TaskDetailApi Controller */
    'status_changed_successfully' => 'स्थिति सफलतापूर्वक बदल गई',
    'task_detail_not_found' => 'कार्य विवरण नहीं मिला',

    /** TaskCheckListApi Controller */
    'status_updated_successfully' => 'स्थिति सफलतापूर्वक अपडेट की गई',

    /** TaskCommentApi Controller */
    'comment_notification' => 'टिप्पणी सूचना',
    'task_mention' => 'आप कार्य :task :type में उल्लिखित हैं',
    'comment_reply' => 'टिप्पणी का उत्तर',
    'comment_reply_deleted_successfully' => 'टिप्पणी का उत्तर सफलतापूर्वक मेटा गया',
    'comment_deleted_successfully' => 'टिप्पणी सफलतापूर्वक मेटा गई',
    'comment_added_successfully' => 'टिप्पणी सफलतापूर्वक जोड़ी गई',

    /** userProfile Api */
    'invalid_base64_image' => 'Base64 मान एक वैध चित्र नहीं है',
    'demo_version' => 'यह एक डेमो संस्करण है। कृपया पूरी विशेषता का उपयोग करने के लिए आवेदन खरीदें',
    'user_not_found' => 'उपयोगकर्ता विवरण नहीं मिला',
    'profile_updated' => 'प्रोफ़ाइल सफलतापूर्वक अपडेट की गई',
    'incorrect_current_password' => 'वर्तमान पासवर्ड गलत है',
    'new_password_same_as_old' => 'नया पासवर्ड पुराने पासवर्ड के समान नहीं हो सकता',
    'password_changed' => 'पासवर्ड सफलतापूर्वक बदल दिया गया',


];
