<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Authentication Language Lines
    |--------------------------------------------------------------------------
    |
    | The following language lines are used during authentication for various
    | messages that we need to display to the user. You are free to modify
    | these language lines according to your application's requirements.
    |
    */

  /** dashboard */
    'welcome' => 'Welcome to Attendance Dashboard',
    'total_employees' => 'Total Employees',
    'total_departments' => 'Total Departments',
    'total_holidays' => 'Total Holidays',
    'paid_leaves' => 'Paid Leaves',
    'on_leave_today' => 'On Leave Today',
    'pending_leave_requests' => 'Pending Leave Requests',
    'total_check_in_today' => 'Total Check In Today',
    'total_check_out_today' => 'Total Check Out Today',
    'projects_detail' => 'Projects Detail',
    'total_projects' => 'Total Projects',
    'pending_projects' => 'Pending Projects',
    'on_hold_projects' => 'On Hold Projects',
    'in_progress_projects' => 'In Progress Projects',
    'finished_projects' => 'Finished Projects',
    'cancelled_projects' => 'Cancelled Projects',
    'top_clients' => 'Top Clients',
    'task_details' => 'Task Details',
    'recent_projects' => 'Recent Projects',
    'title' => 'Title',
    'date_start' => 'Date Start',
    'deadline' => 'Deadline',
    'leader' => 'Leader',
    'completion' => 'Completion',
    'priority' => 'Priority',
    'check_in_at' => 'Check In At',
    'check_out_at' => 'Check Out At',
    'punch_in' => 'Punch In',
    'punch_out' => 'Punch Out',
    'no_records_found' => 'No records found!',
    'project_management' => 'Project Management',
    'view_all_clients' => 'View All Clients',
    'view_all_projects' => 'View All Projects',
    'error_message' => 'Error: Unable to process request.',
    'success_message' => 'Success: Action completed successfully.',
    'name' => 'Name',
    'email' => 'Email',
    'contact' => 'Contact',
    'project' => 'Project',
    'pending' => 'Pending',
    'on_hold' => 'On Hold',
    'in_progress' => 'In progress',
    'completed' => 'Completed',
    'cancelled' => 'Cancelled',
    'search_menu'=>'Search Menu',

    /** nav */
    'latest_notifications' => 'Latest Notifications',
    'view_all' => 'View all',
    'profile' => 'Profile',
    'edit_profile' => 'Edit Profile',
    'request_leave' => 'Request Leave',
    'log_out' => 'Log out',
    'light_mode' => 'Light mode',
    'dark_mode' => 'Dark mode',

    /** menu */
    'dashboard' => 'Dashboard',
    'company_management' => 'Company Management',
    'company' => 'Company',
    'branch' => 'Branch',
    'department' => 'Department',
    'post' => 'Post',
    'employee_management' => 'Employee Management',
    'employees' => 'Employees',
    'logout_requests' => 'Logout Requests',
    'attendance_section' => 'Attendance Section',
    'clients' => 'Clients',
    'task_management' => 'Task Management',
    'holidays' => 'Holidays',
    'notice' => 'Notice',
    'payroll_management' => 'Payroll Management',
    'payroll' => 'Payroll',
    'payroll_setting' => 'Payroll Setting',
    'advance_salary' => 'Advance Salary',
    'employee_salary' => 'Employee Salary',
    'leave' => 'Leave',
    'team_meeting' => 'Team Meeting',
    'tada' => 'Tada',
    'shift_management' => 'Shift Management',
    'office_time' => 'Office Time',
    'award_management' => 'Award Management',
    'award_types' => 'Award Types',
    'awards' => 'Awards',
    'asset_management' => 'Asset Management',
    'asset_types' => 'Asset Types',
    'assets' => 'Assets',
    'content_management' => 'Content Management',
    'support' => 'Support',
    'attendance_methods' => 'Attendance Methods',
    'routers' => 'Routers',
    'qr' => 'QR',
    'nfc' => 'NFC',
    'settings' => 'Settings',
    'roles_permissions' => 'Roles & Permissions',
    'general_settings' => 'General Settings',
    'app_settings' => 'App Settings',
    'notifications' => 'Notifications',
    'payment_currency' => 'Payment Currency',
    'feature_control' => 'Feature Control',
    'salary_component' => 'Salary Component',
    'salary_group' => 'Salary Group',
    'salary_tds' => 'Salary TDS',
    'overtime' => 'OverTime',
    'overtime_income' => 'OverTime Income',
    'undertime' => 'UnderTime',
    'undertime_deduction' => 'UnderTime Deduction',
    'payment_method' => 'Payment Method',
    'leave_types' => 'Leave Types',
    'leave_request' => 'Leave Request',
    'time_leave_request' => 'Time Leave Request',

    /** company */
    'company_profile' => 'Company Profile',
    'update_company' => 'Update Company',
    'create_company' => 'Create Company',
    'company_name' => 'Company Name',
    'company_owner' => 'Company Owner',
    'address' => 'Address',
    'email_address' => 'Email Address',
    'phone_no' => 'Phone No',
    'website_url' => 'Website Url',
    'check_office_off_days' => 'Check Office Off Days',
    'upload_logo' => 'Upload Logo',
    'update' => 'Update',
    'save' => 'Save',

    /** Branch */
    'title_branch' => 'Branch',
    'branch_section' => 'Branch section',
    'branches' => 'Branches',
    'add_branch' => 'Add Branch',
    'branch_lists' => 'Branch Lists',
    'search_by_branch_name' => 'Search by Branch name',
    'filter' => 'Filter',
    'reset' => 'Reset',
    'phone' => 'Phone',
    'total_employee' => 'Total Employee',
    'action' => 'Action',
    'are_you_sure_change_status' => 'Are you sure you want to change status?',
    'are_you_sure_delete_branch' => 'Are you sure you want to Delete Branch?',
    'branch_create' => 'Branch Create',
    'branch_update' => 'Branch Update',
    'branch_name' => 'Branch Name',
    'required_field' => 'Required field',
    'branch_head' => 'Branch Head',
    'select_branch_head' => 'Select Branch Head',
    'phone_number' => 'Phone No',
    'branch_location_latitude' => 'Branch Location Latitude',
    'enter_branch_location_latitude' => 'Enter Branch Location Latitude',
    'branch_location_longitude' => 'Branch Location Longitude',
    'enter_branch_location_longitude' => 'Enter Branch Location Longitude',
    'status' => 'Status',
    'select_status' => 'Select status',
    'active' => 'Active',
    'inactive' => 'In-Active',
    'create' => 'Create',

    /** Department */
    'department_section' => 'Department section',
    'departments' => 'Departments',
    'add_department' => 'Add Department',
    'department_lists' => 'Department Lists',
    'search_by_department_name' => 'Search by Department name',
    'select_branch' => 'Select Branch',
    'edit' => 'Edit',
    'delete' => 'Delete',
    'are_you_sure_delete_department' => 'Are you sure you want to Delete Department ?',
    'edit_department' => 'Edit Department',
    'button_back' => 'Back',
    'breadcrumb' => 'Breadcrumb',
    'update_department' => 'Update Department',
    'create_department' => 'Create Department',
    'department_name' => 'Department Name',
    'department_head' => 'Department Head',
    'select_department_head' => 'Select Department Head',
    'create_update_department' => 'Create/Update Department',

    /** Post */
    'post_section' => 'Post section',
    'posts' => 'Posts',
    'add_post' => 'Add Post',
    'search_by_department' => 'Search by department',
    'search_by_post_name' => 'Search by Post name',
    'post_name' => 'Post Name',
    'post_empty' => 'Post Empty',
    'edit_post_title' => 'Edit Post',
    'create_post_title' => 'Create Post',
    'department_label' => 'Department',
    'post_name_label' => 'Post Name',
    'status_label' => 'Status',
    'select_department' => 'Select Department',
    'active_option' => 'Active',
    'inactive_option' => 'Inactive',
    'update_update_button' => 'Update Post',
    'change_status_confirmation' => 'Are you sure you want to change status?',
    'delete_post_confirmation' => 'Are you sure you want to delete post?',
    'employee_list_title' => 'Employee List',

    /** Employee List */
    'employees_title' => 'Employees',
    'employees_action' => 'Lists',
    'add_employee' => 'Add Employee',
    'employee_section' => 'Employee section',
    'employee_create' => 'Employee create',
    'employee_name' => 'Employee name',
    'employee_email' => 'Employee email',
    'employee_phone' => 'Employee phone number',
    'full_name' => 'Full Name',
    'designation' => 'Designation',
    'role' => 'Role',
    'shift' => 'Shift',
    'workplace' => 'Workplace',
    'is_active' => 'Is Active',
    'edit_detail' => 'Edit Detail',
    'delete_user' => 'Delete User',
    'change_password' => 'Change Password',
    'force_logout' => 'Force Log Out',
    'all_fields_required' => 'All (<span style="color: red">*</span>) fields are required',
    'personal_detail' => 'Personal Detail',
    'employee_code' => 'Employee Code',
    'enter_name'=>'Enter name',
    'enter_employee_address'=>'Enter Employee Address',
    'enter_email'=>'Enter email',
    'dob' => 'Date Of Birth',
    'gender' => 'Gender',
    'select_gender' => 'Select Gender',
    'marital_status' => 'Marital Status',
    'choose_marital_status' => 'Choose Marital Status',
    'upload_avatar' => 'Upload Avatar',
    'description' => 'Description',
    'username' => 'Username',
    'enter_username' => 'Enter username',
    'password' => 'Password',
    'enter_password' => 'Enter Password',
    'select_role' => 'Select Role',
    'company_detail' => 'Company Detail',
    'supervisor' => 'Supervisor',
    'employment_type' => 'Employment Type',
    'select_employment_type' => 'Select Employment Type',
    'joining_date' => 'Joining Date',
    'enter_joining_date' => 'Enter Joining Date',
    'workspace' => 'WorkSpace',
    'select_workspace' => 'Select Work Place',
    'field' => 'Field',
    'office' => 'Office',
    'leave_detail' => 'Leave Detail',
    'leave_allocated' => 'Leave Allocated',
    'assigned_leaves' => 'Assigned Leaves',
    'no_of_days' => 'No. of Days',
    'total_leave_days'=>'Total Leave Days',
    'bank_detail' => 'Bank Detail',
    'bank_name' => 'Bank Name',
    'bank_account_number' => 'Bank Account Number',
    'account_holder_name' => 'Account Holder Name',
    'bank_account_type' => 'Bank Account Type',
    'select_account_type' => 'Select Account Type',
    'create_user' => 'Create User',
    'update_user' => 'Update User',
    'new_password' => 'New Password',
    'enter_new_password' => 'Enter new password',
    'confirm_password' => 'Confirm Password',
    'confirm_password_placeholder' => 'Confirm password',
    'submit' => 'Submit',
    'user_change_password' => 'User Change Password',
    'confirm_delete_employee' => 'Are you sure you want to delete the employee?',
    'confirm_force_logout' => 'Are you sure you want to force logout the user?',
    'confirm_change_workplace' => 'Are you sure you want to change the workplace?',
    'select_supervisor' => 'Select Supervisor',
    'select_office_time' => 'Select Office Time',
    'select_option' => 'Select an Option',
    'enter_address' => 'Please enter the address.',
    'enter_valid_email' => 'Please enter a valid email address.',
    'enter_phone_number' => 'Please enter the phone number.',
    'create_employee' => 'Create Employee',
    'add' => 'Add',
    'edit_user_detail' => 'Edit User Detail',
    'show_user_details' => 'Show User Details',
    'detail' => 'Detail',
    'back' => 'Back',
    'user_detail' => 'User Detail',
    'date_of_birth' => 'DOB',
    'not_applicable' => 'N/A',
    'office_detail' => 'Office Detail',
    'home' => 'Home',
    'account_detail' => 'Account Detail',
    'account_number' => 'Account Number',
    'account_type' => 'Account Type',
    'account_holder' => 'Account Holder',
    'not_available' => 'N/A',

    /** logout requests */
    'logout_request_status' => 'Logout Request Status',
    'take_action' => 'Take action',
    'confirm_accept_logout_request' => 'Are you sure you want to Accept Logout Request ?',

    /** attendance */
    'attendance' => 'Attendance',
    'employee_attendance_lists' => 'Employee Attendance Lists',
    'attendance_of_the_day' => 'Attendance Of The Day',
    'date_placeholder_bs' => 'yy/mm/dd',
    'csv_export' => 'CSV Export',
    'attendance_status' => 'Attendance Status',
    'attendance_by' => 'Attendance By',
    'show_detail' => 'Show Detail',
    'show_checkin_location' => 'Show Checkin Location',
    'show_checkout_location' => 'Show Checkout Location',
    'checkin' => 'checkin',
    'checkout' => 'checkout',
    'approved' => 'Approved',
    'rejected' => 'Rejected',
    'self' => 'Self',
    'admin' => 'Admin',
    'edit_attendance_time' => 'Edit attendance time',
    'employee_attendance_detail' => 'Employee Attendance Detail',
    'attendance_of' => 'Attendance Of',
    'total_days_in_month' => 'Total Days In Month',
    'present_days' => 'Present Days',
    'present' => 'Present',
    'absent_days' => 'Absent Days',
    'weekend' => 'Weekend',
    'weekend_days' => 'Weekend Days',
    'holiday_days' => 'Holiday Days',
    'leave_days' => 'Leave Days',
    'working_hours' => 'Working Hours',
    'worked_hours' => 'Worked Hours',
    'attendance_details_of' => 'Attendance Details of',
    'all_month' => 'All Month',
    'worked_hour' => 'Worked Hour',
    'add_attendance_time' => 'Add attendance time',
    'confirm_change_attendance_status' => 'Are you sure you want to change Attendance Status?',
    'check_in' => 'Check In',
    'check_out' => 'Check Out',
    'attendance_title' => 'Attendance',
    'attendance_action' => 'Employee Attendance Detail',
    'filter_placeholder' => 'Attendance year e.g : :min_year',
    'csv_export_button' => 'CSV Export',

    'total_days' => 'Total Days In Month',
    'total_day' => 'Total Days',
    'attendance_details' => 'Attendance Details of :monthName',
    'date' => 'Date',
    'change_attendance_status' => 'Change Attendance Status',
    'create_attendance' => 'Create Attendance',
    'admin_remark' => 'Admin Remark',
    'edit_attendance' => 'Edit Attendance',
    'admin_edit_remark' => 'Admin Edit Remark',
    'confirm_check_in' => 'Are you sure you want to Check In Employee?',
    'confirm_check_out' => 'Are you sure you want to Check Out Employee?',
    'edit_attendance_title' => 'Edit Attendance(:name) Time of :date',
    'create_attendance_title' => 'Create Attendance(:name) Time of :date',
    'total_worked_hours' => 'Total Worked Hours',
    'attendance_report' => 'Attendance Report',

    /** Clients */
    'client_listing' => 'Client Listing',
    'add_client' => 'Add Client',
    'client_name' => 'Client Name',
    'client_email' => 'Client Email',
    'edit_client_detail' => 'Edit Client Detail',
    'show_client_detail' => 'Show Client Detail',
    'delete_client_detail' => 'Delete Client Detail',
    'client_invoices' => 'Client Invoices',
    'client_detail' => 'Client Detail:',
    'client_project_lists' => 'Client Project Lists:',
    'country' => 'Country',
    'edit_client' => 'Edit Client',
    'create_client' => 'Create Client',
    'client_section' => 'Client section',
    'client_contact' => 'Client Contact Number',
    'client_address' => 'Address',
    'client_country' => 'Country',
    'upload_profile' => 'Upload Client Profile',
    'enter_client_name' => 'Enter Client Name',
    'enter_client_email' => 'Enter Client Email',
    'enter_contact_number' => 'Enter Contact Number',
    'enter_client_address' => 'Enter Client Address',
    'enter_country' => 'Enter Country',
    'confirm_status_change' => 'Are you sure you want to change status?',
    'confirm_delete_client' => 'Are you sure you want to delete Client Detail?',

    /** Project management */
    'lists' => 'Lists',
    'create_project' => 'Create Project',
    'project_filter' => 'Project Filter',
    'search_by_project' => 'Search by Project',
    'search_by_status' => 'Search by Status',
    'search_by_priority' => 'Search By Priority',
    'client' => 'Client',
    'all_tasks' => 'All Tasks',
    'completed_tasks' => 'Completed Tasks',
    'days_left' => 'days left',
    'team_member' => 'Team Member',
    'start_date' => 'Start Date',
    'due_date' => 'Due Date',
    'view' => 'View',
    'projects' => 'Projects',
    'assign_employee' => 'Assign Employee',
    'client_contact_number' => 'Client Contact Number',
    'upload_client_profile' => 'Upload Client Profile',
    'project_name' => 'Project Name',
    'project_start_date' => 'Project Start Date',
    'project_deadline' => 'Project Deadline',
    'project_status' => 'Project Status',
    'select_project_status' => 'Select Project Status',
    'project_cost' => 'Project Cost',
    'select_priority' => 'Select Priority',
    'estimated_hours' => 'Estimated Hours',
    'select_client' => 'Select Client',
    'upload_project_logo' => 'Upload Project Logo',
    'uploaded_files_images' => 'Uploaded Files And Images',
    'no_project_file_uploaded' => 'No project file uploaded',
    'update_project' => 'Update Project',
    'project_leader' => 'Project Leader',
    'assign_member' => 'Assign Member',
    'edit_project' => 'Edit Project',
    'project_document' => 'Project Document',
    'upload_documents' => 'Upload Documents',
    'upload_project_attachments' => 'Upload Project Attachments',
    'show_project_detail' => 'Show Project Detail',
    'upload_attachments' => 'Upload Attachments',
    'project_attachments' => 'Project Attachments',
    'uploaded_image_files' => 'Uploaded image files',
    'no_project_image_found' => 'No Project Image found',
    'uploaded_files' => 'Uploaded files',
    'no_project_files_found' => 'No Project Files found',
    'project_tasks_lists' => 'Project Tasks Lists',
    'project_summary' => 'Project Summary',
    'cost' => 'Cost:',
    'total_hours' => 'Total Hours:',
    'created' => 'Created:',
    'remaining_days' => 'Remaining Days:',
    'project_leaders' => 'Project Leaders',
    'update_leader' => 'Update Leader',
    'project_members' => 'Project Members',
    'update_member' => 'Update Member',
    'project_client_detail' => 'Project Client Detail',
    'delete_project_detail' => 'Are you sure you want to Delete Project Detail?',
    'delete_project_document' => 'Are you sure you want to Delete Project Document?',
    'search_by_member' => 'Search by member',
    'add_employee_to_project' => 'Add employee to project',

    /** Task Management */
    'tasks' => 'Tasks',
    'task_filter' => 'Task Filter',
    'search_by_task_name' => 'Search by Task Name',
    'not_started' => 'Not Started',
    'create_tasks' => 'Create Tasks',
    'end_date' => 'End Date',
    'task_name' => 'Task Name',
    'enter_task_name' => 'Enter Task Name',
    'select_project' => 'Select Project',
    'task_start_date' => 'Task Start Date',
    'task_start_time' => 'Task Start Time',
    'task_end_date' => 'Task End Date',
    'task_end_time' => 'Task End Time',
    'task_status' => 'Task Status',
    'select_task_status' => 'Select Task Status',
    'uploaded_files_and_images' => 'Uploaded Files and Images',
    'task_attachments' => 'Task Attachments',
    'update_task' => 'Update Task',
    'create_task' => 'Create Task',
    'mention' => 'mention',
    'comment' => 'Comment',
    'close' => 'Close',
    'write_comment' => 'write a comment',
    'reply' => 'Reply',
    'delete_confirm' => 'Are you sure you want to Delete:title ?',
    'task_member_placeholder' => 'Assign member to task',
    'project_placeholder' => 'Select Project',
    'project_filter_placeholder' => 'Search by project',
    'task_name_placeholder' => 'Search by Task Name',
    'change_task_status_confirm' => 'Are you sure you want to change task active status ?',
    'change_status_confirm' => 'Are you sure you want to change status ?',
    'delete_task_detail_confirm' => 'Are you sure you want to Delete Task Detail ?',
    'create_checklist_text' => 'Create Checklist',
    'close_checklist_text' => 'Close',
    'remove_checklist_text' => 'Remove',
    'remove_checklist_title' => 'remove checklist',
    'view_all_comments' => 'View All Comments',
    'comments' => 'Comments',
    'edit_task' => 'Edit Task',
    'edit_task_detail' => 'Edit Task Detail',
    'show_task_detail' => 'Show Task Detail',
    'task_edit' => 'Task Edit',
    'create_checklist' => 'Create Checklist',
    'upload_attachment' => 'Upload Attachment',
    'total_checklist' => 'Total Checklist',
    'completed_checklist' => 'Completed Checklist',
    'task_checklist_lists' => 'Task Checklist Lists',
    'assigned_to' => 'Assigned To',
    'create_task_checklist' => 'Create Task Checklist',
    'enter_checklist_title' => 'Enter Checklist Title',
    'select_member' => 'Select Member',
    'add_more_checklist' => 'Add More Checklist',
    'image' => 'Image',
    'file' => 'File',
    'edit_checklist' => 'Edit Checklist',
    'delete_checklist' => 'Delete Checklist',
    'checklist' => 'Checklist',
    'edit_task_checklist' => 'Edit Task Checklist',
    'checklist_name' => 'Checklist Name',
    'assign_task_checklist' => 'Assign Task Checklist',
    'task_summary' => 'Task Summary',
    'task_members' => 'Task Members',
    'task_attachment_title' => 'Task Attachment',
    'upload_attachment_action' => 'Upload Attachment',
    'upload_task_attachments' => 'Upload Task Attachments',
    'upload_task_attachments_text' => 'Upload Task Attachments',
    'choose_file_text' => 'Choose file',

    /** Holiday */
    'holiday_section' => 'Holiday section',
    'event' => 'Event',
    'event_date' => 'Event Date',
    'is_public_holiday' => 'Is Public Holiday?',
    'confirm_delete_holiday' => 'Are you sure you want to Delete Holiday Detail?',
    'holiday_detail_title' => 'Holiday Detail',
    'holiday' => 'Holiday',
    'csv_import' => 'CSV Import',
    'import' => 'Import',
    'holiday_detail_csv' => 'Holiday Detail CSV',
    'holiday_csv_example' => 'Holiday CSV Example',
    'add_holiday' => 'Add Holiday',
    'import_holiday_csv' => 'Import Holiday CSV',
    'holiday_filter' => 'Holiday Filter',
    'event_name' => 'Event name',
    'leave_requested_year' => 'Leave Requested year',
    'holiday_detail' => 'Holiday Detail',

    /** notice */
    'notices_section' => 'Notice Section',
    'notice_title' => 'Notice Title',
    'notice_description' => 'Notice Description',
    'notice_receiver' => 'Notice Receiver',
    'send_notice' => 'Send Notice',
    'all_employees' => 'All Employees',
    'create_notice' => 'Create Notice',
    'edit_notice' => 'Edit Notice',
    'notices' => 'Notices',
    'receiver' => 'Receiver',
    'published_from' => 'Published From',
    'publish_to' => 'Publish To',
    'publish_date' => 'Publish Date',
    'show_notice_content' => 'Show Notice Content',
    'delete_notice_detail' => 'Delete Notice Detail',
    'notice_lists' => 'Notice Lists',
    'confirm_change_notice_status' => 'Are you sure you want to change status for Notice?',
    'confirm_delete_notice' => 'Are you sure you want to Delete Notice?',
    'confirm_send_notice' => 'Are you sure you want to Send Notice?',
    'notice_detail_modal_title' => 'Notice :title Detail',

    /** payroll */
    'employee_payroll'=>'Employee Payroll',
    'payroll_generate'=>'Payroll Generate',
    'payroll_create'=>'Payroll Create',
    'payroll_edit'=>'Payroll Edit',
    'select_year' => 'Select Year',
    'salary_cycle' => 'Salary Cycle',
    'salary_month' => 'Salary Month',
    'salary_week' => 'Salary Week',
    'select_week' => 'Select Week',
    'include_tada' => 'Include TADA',
    'include_advance_salary' => 'Include Advance Salary',
    'use_attendance' => 'Use Attendance',
    'generate' => 'Generate',
    'clear' => 'Clear',
    'report' => 'Report:',
    'duration' => 'Duration',
    'payroll_summary' => 'Payroll Summary',
    'total_basic_salary' => 'Total Basic Salary:',
    'total_net_salary' => 'Total Net Salary:',
    'total_allowance' => 'Total Allowance:',
    'total_deduction' => 'Total Deduction:',
    'total_overtime' => 'Total Overtime:',
    'total_undertime' => 'Total Undertime:',
    'paid_by'=>'Paid By',
    'net_salary'=>'Net Salary',
    'paid_on'=>'Paid On',
    'pay_button' => 'Pay',
    'select_payment_method.'=>'Please select a payment method.',
    'confirm_delete_payroll'=>'Are you sure you want to Delete Employee Payroll ?',
    'confirm_generate_payroll'=>'Are you sure you want to generate payroll?',
    'confirm_change_cycle'=>'Are you sure you want to change salary cycle ?',
    'payment_title' => 'Make Payment',
    'payment_method_placeholder' => 'Select Payment Method',
    'payment_date' => 'Payment Date',
    'hourly_rate' => 'Hourly Rate',
    'hourly' => 'Hourly',
    'working_hours_in_week' => 'Working Hours in Week',
    'annual_salary' => 'Annual Salary (CTC)',
    'annual' => 'Annual',
    'basic_salary' => 'Basic Salary',
    'fixed_allowance' => 'Fixed Allowance',
    'total' => 'Total',
    'net_total' => 'Net Total',
    'earnings' => 'Earnings',
    'deductions' => 'Deductions',
    'create_salary '=>'Create Salary ',
    'edit_salary '=>'Edit Salary ',
    'add_salary '=>'Add Salary ',
    'calculation_type'=>'Calculation Type',
    'monthly_amount'=>'Monthly Amount',
    'annual_amount'=>'Annual Amount',
    'salary_slip' => 'Salary Slip',
    'edit_salary_slip' => 'Edit Salary Slip',
    'payslip' => 'Payslip',
    'for_the_month_of' => 'for the month of',
    'from'=>'from',
    'to'=>'to',
    'employee_id'=>'Employee ID',
    'earning' => 'Earning',
    'deduction' => 'Deduction',
    'actual_salary' => 'Actual Salary',
    'total_earning'=>'Total Earning',
    'actual_salary_formula' => '(Total Earning - Total Deductions)',
    'bonus' => 'Bonus',
    'taxable_salary' => 'Taxable Salary',
    'taxable_salary_formula' => '(Actual Salary + Bonus)',
    'tax' => 'Tax',
    'salary_after_tax' => 'Salary After Tax',
    'expenses_claim' => 'Expenses Claims (TADA)',
    'absent' => 'Absent',
    'absent_deduction_formula' => '((grossSalary/ total days) * absent days)',
    'net_salary_formula' => 'Net Salary = (Actual Salary - Advance Salary + TADA)',
    'monthly' => 'monthly',
    'weekly' => 'weekly',
    'salary_increment' => 'Salary Increment',
    'increment' => 'Increment',
    'current_salary' => 'Current Salary',
    'annual_increment_percent' => 'Annual Increment %',
    'annual_increment_amount' => 'Annual Increment Amount',
    'revised_salary_label' => 'Revised Salary',
    'fiscal_year_label' => 'Increment for Fiscal Year',
    'applicable_from_label' => 'Applicable From (Date)',
    'applicable_to_label' => 'Applicable To (Date)',
    'remark' => 'Remark',
    'fiscal_year' => 'Fiscal Year',
    'select_fiscal_year' => 'Select Fiscal Year',
    'list'=>'List',
    'employee_salary_filter'=>'Employee Salary Filter',
    'salary_review_history'=>'Salary Review History',
    'increase_salary'=>'Increase Salary',
    'all'=>'All',
    'employee_payslip'=>'Employee Payslip',
    'salary_from'=>'Salary From',
    'salary_to'=>'Salary To',
    'unpaid_leave'=>'Unpaid Leave',
    'paid_leave'=>'Paid Leave',
    'employee_gross_salary'=>'Employee Gross Salary',
    'salary_increment_log'=>'Salary Increment Log',
    'log'=>'Log',
    'salary_revised_on'=>'Salary Revised On',
    'increment_by'=>'Increment By',
    'increment_value'=>'Increment Value',
    'old_salary'=>'Old Salary',
    'new_salary'=>'New Salary',
    'date_to'=>'Date To',
    'date_from'=>'Date From',
    'salary_increment_remark'=>'Salary Increment Remark',
    'advance_salary_requests'=>'Advance Salary Requests',
    'advance_salary_request_filter'=>'Advance Salary Requests Filter',
    'delete_confirmation'=>'Are you sure you want to Delete ?',
    'payslip_for_the_month_of'=>'Payslip for the Month of',
    'absent_deduction'=>'Absent Deduction',

    /** Advance Salary */
    'is_paid'=>'Is Paid ?',
    'released_on'=>'Released On',
    'requested_on'=>'Requested On',
    'released_amount'=>'Released Amount',
    'requested_amount'=>'Requested Amount',
    'search_by_month'=>'Search by Month',
    'search_by_employee_name'=>'search by employee name',
    'advance_salary_detail'=>'Advance Salary Detail',
    'is_settled'=>'Is Settled',
    'verified_by'=>'Verified By',
    'amount_released_date'=>'Amount Released Date',
    'advance_requested_date'=>'Advance Requested Date',
    'total_released_amount'=>'Total Released Amount',
    'total_request_amount'=>'Total Request Amount',
    'employee'=>'Employee',
    'select_employee'=>'Select Employee',
    'advance_salary_request_detail'=>'Advance Salary Request Detail',
    'proof_of_advance_salary_payment'=>'Proof Of Advance Salary Payment',
    'attachments'=>'Attachments',
    'processing'=>'Processing',

    /** Tax report */
    'tax_report'=>'Tax report',
    'employee_tax_report'=>'Employee Tax report',
    'tax_report_edit'=>'Tax Report Edit',
    'tax_report_detail_of'=>'Tax Report Detail of',
    'tax_report_detail'=>'Tax Report Detail',
    'salary_sheet'=>'Salary Sheet',
    'particular'=>'Particular',
    'income'=>'Income',
    'tax_data_not_available'=>'No tax data available for the current marital status',
    'remain_tds_formula'=>'(Total Due Tds / No of remaining months)',
    'remaining_month'=>'Remaining Month',
    'tds_calculation_msg'=>'TDS Calculation for Current(Calculating Month)',
    'total_due_tds'=>'Total Due TDS',
    'total_paid_tds'=>'Total Paid TDS',
    'total_payable_tds'=>'Total Payable TDS',
    'other_discount'=>'Other Discount',
    'female_discount'=>'Female Discount',
    'medical_claim'=>'Medical Claim',
    'less'=>'less',
    'less_tax_deduction'=>'less: Tax Deduction',
    'tax_amount'=>'Tax Amount',
    'percent'=>'Percent',
    'tax_calculation_on_taxable_income'=>'Tax Calculation on Taxable Income',
    'taxable_income'=>'Taxable Income',
    'ssf_contribution'=>'SSF Contribution',
    'ssf_contribution_salary'=>'SSF Contribution Salary',
    'total_retirement_contribution_allowed'=>'Total Retirement Contribution Allowed',
    'total_income'=>'Total Income',
    'amount'=>'Amount',
    'additional_information'=>'Additional Information',
    'total_payable'=>'Total Payable',
    'tds_paid'=>'TDS Paid',
    'ssf_deduction'=>'SSF Deduction',
    'tax_report_generate'=>'Tax Report Generate',
    'print'=>'Print',
    'gross_earnings'=>'Gross Earnings',
    'tax_payable'=>'Tax Payable',

    /** Payroll Setting  */
    'advance_salary_limit'=>'Advance Salary Limit',
    'select_month'=>'Select Month',
    'applicable_month'=>'Applicable Month',
    'value'=>'Value',
    'value_type'=>'Value Type',
    'enter_bonus_type'=>'Enter Bonus Type',
    'salary_components'=>'Salary Components',
    'add_bonus'=>'Add Bonus',
    'max_daily_ot'=>'Max. Daily OT',
    'assign_overtime_to_employee'=>'Assign OverTime to Employee',
    'overtime_pay_rate'=>'OverTime Pay Rate (per hour)',
    'overtime_rate_percent'=>'OverTime Rate Percent (per hour)',
    'placeholder_overtime_pay_rate'=>'Enter OverTime Pay Rate',
    'placeholder_overtime_rate_percent'=>'Enter OverTime Rate percent',
    'rate_type'=>'Rate Type',
    'select_rate_type'=>'Select Rate Type',
    'ot_valid_after_hour'=>'OverTime Valid After ? Hour',
    'placeholder_ot_valid_after_hour'=>'Enter Hours After which OT is valid',
    'monthly_ot'=>'Max Monthly OverTime Hour',
    'placeholder_monthly_ot'=>'Enter Max Monthly OverTime Hour',
    'weekly_ot'=>'Max Weekly OverTime Hour',
    'placeholder_weekly_ot'=>'Enter Max Weekly OverTime Hour',
    'daily_ot'=>'Max Daily OverTime Hour',
    'placeholder_daily_ot'=>'Enter Max Daily OverTime Hour',
    'pay_percent'=>'Pay Percent/Rate',
    'employee_count'=>'Employee Count',
    'hour'=>'Hour',
    'currency_setting'=>'Currency Setting',
    'payroll_currency'=>'Payroll Currency',
    'choose_payroll_currency'=>'Choose Payroll Currency',
    'add_payment_method'=>'Add Payment Method',
    'payment_method_name'=>'Payment Method Name',
    'update_payment_method'=>'Update Payment Method',
    'component_value'=>'Component Value',
    'component_type'=>'Component Type',
    'add_salary_component'=>'Add Salary Component',
    'apply_for_all'=>'Apply For All',
    'component_value_annual'=>'Component Value (Annual)',
    'select_value_type'=>'Select Value Type',
    'select_component_type'=>'Select Component Type',
    'enter_salary_component_name'=>'Enter Salary Component Name',
    'add_salary_group'=>'Add Salary Group',
    'delete_confirm_salary_group'=>'Are you sure you want to Delete Group Detail ?',
    'assign_employee_to_group'=>'Assign Employee To Group',
    'choose_salary_component'=>'Choose Salary Component',
    'assign_salary_components'=>'Assign Salary Components',
    'enter_salary_group_name'=>'Enter Salary Group Name',
    'add_more_tds_detail'=>'Add More TDS Detail',
    'enter_tds_in_percent'=>'Enter TDS In Percent',
    'enter_annual_salary_to'=>'Enter Annual Salary To',
    'enter_annual_salary_from'=>'Enter Annual Salary From',
    'select_marital_status'=>'Select Marital Status',
    'create_salary_tds'=>'Salary TDS Create',
    'update_salary_tds'=>'Salary TDS Update',
    'salary_tds_detail_for_single'=>'Salary TDS Detail For Single',
    'add_salary_tds'=>'Add Salary TDS',
    'annual_salary_to'=>'Annual Salary To',
    'annual_salary_from'=>'Annual Salary From',
    'tds'=>'TDS(%)',
    'salary_tds_detail_for_married'=>'Salary TDS Detail For Married',
    'ssf'=>'SSF',
    'employee_contribution'=>'Employee Contribution',
    'office_contribution'=>'Office Contribution',
    'assign_undertime_to_employee'=>'Assign UnderTime to Employee',
    'enter_title'=>'Enter Title',
    'undertime_after_minute'=>'Minutes After which Under Time is Applied',
    'placeholder_ut_after'=>'Enter Hours after which UT is applied',
    'penalty_type'=>'Penalty Type',
    'select_penalty_type'=>'Select Penalty Type',
    'penalty_percent'=>'Penalty Percent (per hour)',
    'penalty_percent_placeholder'=>'Enter Under Time Penalty Percent',
    'penalty_rate'=>'Penalty Rate (per hour) ',
    'penalty_rate_placeholder'=>'Enter Under Time Penalty Rate',


    /** Leave */
    'leave_type_section'=>'Leave Type section',
    'select_leave_type'=>'Select Leave Type',
    'leave_type'=>'Leave Type',
    'leave_allocated_days'=>'Leave Allocated Days',
    'allocated_days'=>'Allocated Days',
    'is_paid_leave'=>'Is Paid Leave',
    'leave_type_name'=>'Leave Type Name',
    'leave_type_placeholder'=>'Enter Leave Type',
    'add_leave_type'=>'Add Leave Type',
    'type'=>'Type',
    'edit_leave_type_detail'=>'Edit Leave Type Detail',
    'delete_leave_type'=>'Delete Leave Type',
    'delete_leave_confirmation'=>'Are you sure you want to Delete Leave Type ?',
    'leave_request_section'=>'Leave Request section',
    'approve' => 'Approve',
    'reject'=>'Reject',
    'from_date'=>'From Date',
    'to_date'=>'To Date',
    'start_time' => 'Start Time',
    'end_time' => 'End Time',
    'reason'=>'Reason',
    'requested_for'=>'Requested For',
    'requested_by'=>'Requested By',
    'requested_days'=>'Requested Days',
    'requested_date'=>'Requested Date',
    'all_status'=>'All Status',
    'all_leave_type'=>'All Leave Type',
    'leave_request_filter'=>'Leave Request Filter',
    'create_leave_request'=>'Create Leave Request',
    'leave_reason'=>'leave reason',
    'referred_by'=>'Referred By',
    'leave_date'=>'Leave Date',
    'time_leave_request_filter'=>'Time Leave Request Filter',
    'create_time_leave_request'=>'Create Time Leave Request',
    'time_leave_request_section'=>'Time Leave Request section',
    'time_leave_status_update'=>'Time Leave Status Update',

    /** Team Meeting */
    'team_meeting_section'=>'Team Meeting section',
    'update_and'=>'update And',
    'create_and'=>'Create And',
    'send'=>'Send',
    'meeting_participator'=>'Meeting participator',
    'image_hint'=>'Image is recommended to be in landscape form',
    'meeting_description'=>'Meeting Description',
    'upload_image'=>'Upload Image',
    'meeting_start_time'=>'Meeting Start Time',
    'meeting_date'=>'Meeting Date',
    'meeting_venue'=>'Meeting Venue',
    'enter_venue_name'=>'Enter venue Name',
    'enter_content_title'=>'Enter Content Title',
    'meeting_title'=>'Meeting title',
    'delete_team_meeting_confirmation'=>'Are you sure you want to Delete Team Meeting ?',
    'image_delete_confirmation'=>'Are you sure you want to Remove Image ?',
    'create_team_meeting'=>'Create Team Meeting',
    'delete_team_meeting'=>'Delete team meeting detail',
    'edit_meeting_detail'=>'Edit meeting detail',
    'show_team_meeting'=>'show team meeting content',
    'participators'=>'Participators',
    'participator'=>'Participator',
    'team_meeting_filter'=>'Team Meeting Filter',
    'agenda'=>'Agenda',
    'creator'=>'Creator',

    /** Tada */
    'tada_attachment'=>'Tada Attachment',
    'upload_tada_attachment'=>'Upload Tada Attachment',
    'accepted'=>'Accepted',
    'tada_status_change'=>'Are you sure you want to change tada settlement status ?',
    'delete_tada_confirm'=>'Are you sure you want to Delete :title?',
    'uploaded_attachment'=>'Uploaded Attachment',
    'no_attachment_file'=>'No Attachment file',
    'total_expense'=>'Total Expense',
    'create_tada'=>'Create Tada',
    'edit_tada'=>'Edit Tada',
    'tada_listing'=>'Tada Listing',
    'tada_filter'=>'Tada Filter',
    'submitted_date'=>'Submitted Date',
    'expense'=>'Expense(',
    'tada_detail'=>'Tada Detail',
    'verified_date'=>'Verified Date',
    'tada_summary'=>'Tada Summary',
    'update_status'=>'Update Status',
    'category'=>'Category',
    'select_category'=>'Select Category',
    'opening_time' => 'Opening Time',
    'closing_time' => 'Closing Time',
    'checkin_checkout_rule' => 'CheckIn/Out Rule',
    'early_check_in' => 'Early Check In',
    'check_in_before' => 'Can check in before (in minute)',
    'checkin_before' => 'Check in Before',
    'enter_check_in_before' => 'Enter Can check in before (in minute)',
    'early_check_out' => 'Early Check out',
    'check_out_before' => 'Can check out before (in minute)',
    'checkout_before' => 'Check out Before',
    'enter_check_out_before' => 'Enter Can check out before (in minute)',
    'late_check_in' => 'Late Check In',
    'check_in_after' => 'Can check in after (in minute)',
    'checkin_after' => 'Check in After',
    'enter_check_in_after' => 'Enter Can check in after (in minute)',
    'late_check_out' => 'Late Check out',
    'checkout_after' => 'Check out After',
    'check_out_after' => 'Can check out after (in minute)',
    'enter_check_out_after' => 'Enter Can check out after (in minute)',
    'enter_shift_name' => 'Enter Shift Name',
    'select_shift' => 'Select Shift',
    'delete_office_time_confirm'=>'Are you sure you want to Delete Office Schedule ?',
    'office_time_detail'=>'Office Time Detail',
    'office_schedule'=>'Office Schedule',
    'add_office_time'=>'Add Office Time',


    /** Award Types */
    'award_distributed'=>'Award Distributed',
    'add_award_types'=>'Add Award Types',
    'gift_item'=>'Gift item',
    'awarded_date'=>'Awarded Date',

    /** Award */
    'award'=>'Award',
    'award_name'=>'Award Name',
    'select_award_type'=>'Select Award Type',
    'enter_gift_item'=>'Enter gift item',
    'award_base'=>'Award Base',
    'select_award_base'=>'Select Award Base',
    'awarded_by'=>'Awarded By',
    'enter_awarded_by'=>'Enter Awarded By',
    'award_description'=>'Award Description',
    'gift_description'=>'Gift Description',
    'reward_code'=>'Reward Code',
    'enter_reward_code'=>'Enter Reward Code',
    'add_award'=>'Add Award',
    'attachment'=>'Attachment',
    'award_lists'=>'Award Lists',

    /** Asset Types */
    'add_asset_types'=>'Add Asset Types',
    'asset_item_count'=>'Asset Item Count',
    'asset_type' => 'Asset Type',
    'asset_name'=>'Asset Name',
    'purchased_date'=>'Purchased Date',
    'is_working'=>'Is Working',
    'is_available'=>'Is Available',
    'asset'=>'Asset',

    /** Assets */
    'select_asset_type'=>'Select Asset Type',
    'assigned_date'=>'Assigned Date',
    'is_available_for_employee'=>'Is Available For Employee',
    'select_availability'=>'Select Availability',
    'warranty_end_date'=>'Warranty End Date',
    'warranty_available'=>'Warranty Available',
    'select_warranty_availability'=>'Select  Warranty Availability',
    'asset_serial_number'=>'Asset Serial Number',
    'enter_asset_serial_number'=>'Enter Asset Serial Number',
    'asset_code'=>'Asset Code',
    'enter_asset_code'=>'Enter Asset Code',
    'change_availability_status'=>'Are you sure you want to change Availability status ?',
    'delete_asset_confirm'=>'Are you sure you want to Delete :title?',
    'add_asset'=>'Add Asset',
    'asset_image'=>'Asset Image',
    'asset_assigned_employee'=>'Asset Assigned Employee',
    'assets_filter'=>'Assets Filter',
    'working_status'=>'Working Status',
    'availability_status'=>'Availability Status',
    'yes_available'=>'Yes Available',
    'notavailable'=>'Not Available',
    'purchased_from'=>'Purchased From',
    'purchased_to'=>'Purchased To',

    /** Content Management */
    'content_section'=>'Content section',
    'content'=>'Content',
    'content_type'=>'Content Type ',
    'content_title'=>'Content Title',
    'select_content_type'=>'Select Content Type',
    'delete_content_confirm'=>'Are you sure you want to Delete Static Page Content ?',
    'company_static_content'=>'Company Static Content',
    'add_content'=>'Add Content',


    /** support */
    'delete_support_confirm'=>'Are you sure you want to Delete :title?',
    'ticket_lists'=>'Ticket Lists',
    'query_by'=>'Query By',
    'concerned_department'=>'Concerned Department',
    'unseen'=>'Unseen',
    'read_status'=>'Read Status',
    'seen'=>'Seen',
    'query_status'=>'Query Status',
    'support_filter'=>'Support Filter',
    'query_lists'=>'Query Lists',
    'department_support_requested_from'=>'Department Support Requested From',
    'department_support_requested_to'=>'Department Support Requested To',
    'change_query_status'=>'Change Query Status',


    /** Router */
    'router_section'=>'Router Section',
    'router_bssid'=>'Router BSSID',
    'router'=>'Router',
    'router_detail'=>'Router Detail',
    'add_router'=>'Add Router',

    /** QR */
    'scan_me'=>'Scan Me',
    'attendance_qr'=>'Attendance QR',
    'qr_image'=>'QR Image',
    'add_qr'=>'Add QR',
    'qr_section'=>'QR section',

    /** NFC */
    'nfc_section'=>'NFC section',
    'created_by'=>'Created By',

    /** Role and permission */
    'role_section'=>'Role section',
    'authorize_backend_login'=>'Authorize Backend Login',
    'role_name'=>'Role Name',
    'permissions' => 'Permissions',
    'check_all'=>'Check All',
    'module'=>'Module',
    'add_role'=>'Add Role',
    'assign_permissions'=>'Assign Permissions',
    'confirm_role_deletion'=>'Are you sure you want to Delete Role ?',
    'can_login'=>'Can Login',
    'permission_setting'=>'Permission Setting',
    'assign'=>'Assign',

    /** General Setting */
    'general_setting_section'=>'General Setting section',
    'general_setting'=>'General Setting',

    /** App Setting */
    'export_database_data'=>'Export Database Data',
    'check_router_bssid' =>'Check Router BSSID',

    /** Fiscal Years */
    'fiscal_years'=>'Fiscal Years',
    'year'=>'Year',
    'add_fiscal_year'=>'Add Fiscal Year',


    /** Notifications */
    'notification_section'=>'Notification section',
    'confirm_notification_send'=>'Are you sure you want to Send Notification ?',
    'notification' => 'Notification',
    'published_date' => 'Published Date',
    'all_types'=>'All Types',
    'notification_lists'=>'Notification Lists',
    'notified_member'=>'Notified Member',
    'notification_title'=>'Notification Title',
    'notification_description'=>'Notification Description',
    'send_notification'=>'Send Notification',
    'enter_notification_title'=>'Enter Notification Title',

    /** feature control */
    'app_setting' => 'App Setting',
    'sn' => 'SN',
    'group' => 'Group',
    'export_table_data' => 'Export Table Data',
    'leave_requests' => 'Leave Requests',
    'employee_lists' => 'Employee Lists',
    'attendances' => 'Attendances',
    'confirm_change_status' => 'Are you sure you want to change status?',
    'yes' => 'Yes',
    'no' => 'No',

    /** Api response */
    /** Auth Controller */
    'invalid_login_credentials'=>'Invalid Login Credentials !',
    'authenticated'=>'Authenticated',
    'user_detail_not_found'=>'User Detail Not Found',
    'partial_logout_successful'=>'Partial Logout Successful',
    /** Dashboard Controller */
    'data_found'=>'Data Found',
    /** AdvanceSalary Controller */
    'advance_salary_pending_error'=>'Another advance salary cannot be requested until the previous advance request is settled.',
    'data_updated_successfully'=>'Data updated successfully',
    'user_updated_advance_salary_request' => ':name has updated an advance salary request detail',
    'data_created_successfully'=>'Data created successfully',
    'advance_salary_request_alert'=>'Advance Salary Request Alert',
    'user_submitted_advance_salary_request' => ':name has submitted an advance salary request of amount :amount',
    /** Attendance Api */
    'check_out_successful'=>'Check out successful',
    'check_out_notification'=>'Check Out Notification',
    'check_in_successful'=>'Check in successful',
    'check_in_notification'=>'Check In Notification',
    'not_checked_in_yet'=>'Not checked in yet',
    'alert_multi_checkin_shift'=>'Sorry! Employee cannot check in twice in a shift.',
    'checkout_alert_for_shift'=>'Employee already checked out for the shift',
    'alert_checkin'=>'Sorry ! employee cannot check in twice a day.',
    'checkout_alert'=>'Employee already checked out for today',
    'attendance_alert_status'=>':status already done',
    'employee_checked_in' => ':name checked in at :time',
    'employee_checked_out' => ':name has checked out at :time',
    'has_worked_for' => 'and has worked for :time',
    'multi_checkout_warning'=>'You have reached the maximum number of check-ins and check-outs allowed for today.',
    'employee_checked_out_and_worked' => ':name has checked out at :check_out_time and has worked for :worked_time',
    'invalid_attendance_type'=>'Invalid attendance attendance_type.',
    'invalid_qr'=>'Invalid QR or QR is not available',
    'invalid_nfc'=>'Invalid NFC token or NFC is not available',
    'validation_failed'=>'Validation failed',

    /** Leave Api Controller */
    'leave_request_cancelled'=>'Leave request cancelled successfully',
    'leave_request_cannot_be_cancelled' => 'Leave request cannot be cancelled once it is updated from pending state.',
    'leave_request_notification' => 'Leave Request Notification',
    'leave_request_submitted' => ':name has requested leave from :start_time to :end_time on :issue_date. Reason: :reasons',
    'leave_request_submitted_successfully' => 'Leave request submitted successfully',
    'leave_request_cancelled_successfully' => 'Leave request cancelled successfully',
    'leave_request_submit' => ':name has requested :no_of_days day(s) leave from :leave_from on :leave_requested_date. Reason: :reasons',

    /** NFC api Controller */
    'nfc_token_already_exist' => 'NFC token already exist.',
    'nfc_added_successfully' => 'NFC added successfully',

    /** Notification Api Controller */
    'updated_successfully'=>'Updated Successfully',
    'successfully_sent_notification'=>'successfully sent notification',
    'data_not_found'=>'Data not Found',
    'content_not_found'=>'Content Not found',

    /** Support Api Controller */
    'support_notification' => 'Support Notification',
    'support_request_submitted' => ':name has requested for support.',
    'query_submitted_successfully' => 'Query Submitted Successfully',

    /** Tada Api Controller  */
    'attachment_detail_not_found' => 'Attachment Detail Not Found',
    'cannot_delete_attachment_detail' => 'Cannot Delete Attachment Detail Once Verified',
    'upload_another_attachment_before_delete' => 'Please upload another attachment before deleting.',
    'attachment_deleted_successfully' => 'Attachment Deleted successfully',
    'tada_update_alert'=>'You cannot update the detail once verified,Please contact administrator',
    'tada_notification' => ':name has submitted a new TADA for :title',
    'tada_detail_notification' => ':name has updated :title submitted TADA detail',
    'tada_alert'=>'Tada Alert',

    /** TaskDetailApi Controller */
    'status_changed_successfully'=>'Status changed successfully',
    'task_detail_not_found'=>'Task detail not found',

    /** TaskCheckListApi Controller */
    'status_updated_successfully'=>'Status updated successfully',

    /** TaskCommentApi Controller */
    'comment_notification'=>'Comment Notification',
    'task_mention' => 'You are mentioned in task :task  :type',
    'comment_reply'=>'comment reply',
    'comment_reply_deleted_successfully'=>'Comment Reply Deleted Successfully',
    'comment_deleted_successfully'=>'Comment Deleted Successfully',
    'comment_added_successfully'=>'Comment Added Successfully',

    /** userProfile Api */
    'invalid_base64_image' => 'Base64 value is not a valid image',
    'demo_version' => 'This is a demo version. Please buy the application to use the full feature',
    'user_not_found' => 'User Detail Not Found',
    'profile_updated' => 'Profile Updated Successfully',
    'incorrect_current_password' => 'Incorrect current password',
    'new_password_same_as_old' => 'New password cannot be old password',
    'password_changed' => 'Password Changed Successfully',


];
