<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Authentication Language Lines
    |--------------------------------------------------------------------------
    |
    | The following language lines are used during authentication for various
    | messages that we need to display to the user. You are free to modify
    | these language lines according to your application's requirements.
    |
    */

    /** dashboard */
    'welcome' => 'Bienvenue sur le tableau de bord des présences',
    'total_employees' => 'Total des employés',
    'total_departments' => 'Total des départements',
    'total_holidays' => 'Total des jours fériés',
    'paid_leaves' => 'Congés payés',
    'on_leave_today' => 'En congé aujourd\'hui',
    'pending_leave_requests' => 'Demandes de congé en attente',
    'total_check_in_today' => 'Total des entrées aujourd\'hui',
    'total_check_out_today' => 'Total des sorties aujourd\'hui',
    'projects_detail' => 'Détail des projets',
    'total_projects' => 'Total des projets',
    'pending_projects' => 'Projets en attente',
    'on_hold_projects' => 'Projets en attente',
    'in_progress_projects' => 'Projets en cours',
    'finished_projects' => 'Projets terminés',
    'cancelled_projects' => 'Projets annulés',
    'top_clients' => 'Meilleurs clients',
    'task_details' => 'Détails des tâches',
    'recent_projects' => 'Projets récents',
    'title' => 'Titre',
    'date_start' => 'Date de début',
    'deadline' => 'Date limite',
    'leader' => 'Chef de projet',
    'completion' => 'Achèvement',
    'priority' => 'Priorité',
    'check_in_at' => 'Enregistrement à',
    'check_out_at' => 'Sortie à',
    'punch_in' => 'Poinçonner',
    'punch_out' => 'Poinçonner la sortie',
    'no_records_found' => 'Aucun enregistrement trouvé!',
    'project_management' => 'Gestion de projet',
    'view_all_clients' => 'Voir tous les clients',
    'view_all_projects' => 'Voir tous les projets',
    'error_message' => 'Erreur : Impossible de traiter la demande.',
    'success_message' => 'Succès : Action complétée avec succès.',
    'name' => 'Nom',
    'email' => 'E-mail',
    'contact' => 'Contact',
    'project' => 'Projet',
    'pending' => 'En attente',
    'on_hold' => 'En attente',
    'in_progress' => 'En cours',
    'completed' => 'Terminé',
    'cancelled' => 'Annulé',
    'search_menu' => 'Menu de recherche',

    /** nav */
    'latest_notifications' => 'Dernières Notifications',
    'view_all' => 'Voir tout',
    'profile' => 'Profil',
    'edit_profile' => 'Modifier le Profil',
    'request_leave' => 'Demander un Congé',
    'log_out' => 'Déconnexion',
    'light_mode' => 'Mode clair',
    'dark_mode' => 'Mode sombre',

    /** menu */
    'dashboard' => 'Tableau de bord',
    'company_management' => 'Gestion de l\'entreprise',
    'company' => 'Entreprise',
    'branch' => 'Succursale',
    'department' => 'Département',
    'post' => 'Poste',
    'employee_management' => 'Gestion des employés',
    'employees' => 'Employés',
    'logout_requests' => 'Demandes de déconnexion',
    'attendance_section' => 'Section d\'assistance',
    'clients' => 'Clients',
    'task_management' => 'Gestion des tâches',
    'holidays' => 'Vacances',
    'notice' => 'Remarque',
    'payroll_management' => 'Gestion de la paie',
    'payroll' => 'Paie',
    'payroll_setting' => 'Réglage de la paie',
    'advance_salary' => 'Salaire avancé',
    'employee_salary' => 'Salaire des employés',
    'leave' => 'Quitter',
    'team_meeting' => 'Réunion d\'équipe',
    'tada' => 'Tada',
    'shift_management' => 'Gestion des quarts',
    'office_time' => 'Temps de bureau',
    'award_management' => 'Gestion des récompenses',
    'award_types' => 'Types de récompenses',
    'awards' => 'Récompenses',
    'asset_management' => 'Gestion des actifs',
    'asset_types' => 'Types d\'actifs',
    'assets' => 'Actifs',
    'content_management' => 'Gestion du contenu',
    'support' => 'Soutien',
    'attendance_methods' => 'Méthodes de présence',
    'routers' => 'Routage',
    'qr' => 'QR',
    'nfc' => 'NFC',
    'settings' => 'Paramètres',
    'roles_permissions' => 'Rôles et autorisations',
    'general_settings' => 'Paramètres généraux',
    'app_settings' => 'Paramètres de l\'application',
    'notifications' => 'Notifications',
    'payment_currency' => 'Devise de paiement',
    'feature_control' => 'Contrôle des fonctionnalités',
    'salary_component' => 'Composant de salaire',
    'salary_group' => 'Groupe de salaire',
    'salary_tds' => 'Impôt sur le salaire',
    'overtime' => 'Heures supplémentaires',
    'undertime' => 'Sous-temps',
    'payment_method' => 'Méthode de paiement',
    'leave_types' => 'Types de congé',
    'leave_request' => 'Demande de congé',
    'time_leave_request' => 'Demande de congé à temps',


    /** company */
    'company_profile' => 'Profil de l\'Entreprise',
    'update_company' => 'Mettre à Jour l\'Entreprise',
    'create_company' => 'Créer une Entreprise',
    'company_name' => 'Nom de l\'Entreprise',
    'company_owner' => 'Propriétaire de l\'Entreprise',
    'address' => 'Adresse',
    'email_address' => 'Adresse E-mail',
    'phone_no' => 'Numéro de Téléphone',
    'website_url' => 'URL du Site Web',
    'check_office_off_days' => 'Vérifier les Jours de Congé du Bureau',
    'upload_logo' => 'Télécharger le Logo',
    'update' => 'Mettre à Jour',
    'save' => 'Enregistrer',

    /** Branch */
    'title_branch' => 'Agence',
    'branch_section' => 'Section des Agences',
    'branches' => 'Agences',
    'add_branch' => 'Ajouter une Agence',
    'branch_lists' => 'Listes des Agences',
    'search_by_branch_name' => 'Rechercher par Nom d\'Agence',
    'filter' => 'Filtrer',
    'reset' => 'Réinitialiser',
    'phone' => 'Téléphone',
    'total_employee' => 'Nombre Total d\'Employés',
    'action' => 'Action',
    'are_you_sure_change_status' => 'Êtes-vous sûr de vouloir changer le statut ?',
    'are_you_sure_delete_branch' => 'Êtes-vous sûr de vouloir supprimer l\'agence ?',
    'branch_create' => 'Créer une Agence',
    'branch_update' => 'Mettre à Jour l\'Agence',
    'branch_name' => 'Nom de l\'Agence',
    'required_field' => 'Champ Obligatoire',
    'branch_head' => 'Responsable d\'Agence',
    'select_branch_head' => 'Sélectionner le Responsable d\'Agence',
    'phone_number' => 'Numéro de Téléphone',
    'branch_location_latitude' => 'Latitude de l\'Emplacement de l\'Agence',
    'enter_branch_location_latitude' => 'Entrer la Latitude de l\'Emplacement de l\'Agence',
    'branch_location_longitude' => 'Longitude de l\'Emplacement de l\'Agence',
    'enter_branch_location_longitude' => 'Entrer la Longitude de l\'Emplacement de l\'Agence',
    'status' => 'Statut',
    'select_status' => 'Sélectionner le Statut',
    'active' => 'Actif',
    'inactive' => 'Inactif',
    'create' => 'Créer',

    /** Department */
    'department_section' => 'Section des Départements',
    'departments' => 'Départements',
    'add_department' => 'Ajouter un Département',
    'department_lists' => 'Listes des Départements',
    'search_by_department_name' => 'Rechercher par Nom de Département',
    'select_branch' => 'Sélectionner l\'Agence',
    'edit' => 'Modifier',
    'delete' => 'Supprimer',
    'are_you_sure_delete_department' => 'Êtes-vous sûr de vouloir supprimer le département ?',
    'edit_department' => 'Modifier le Département',
    'button_back' => 'Retour',
    'breadcrumb' => 'Fil d\'Ariane',
    'update_department' => 'Mettre à Jour le Département',
    'create_department' => 'Créer un Département',
    'department_name' => 'Nom du Département',
    'department_head' => 'Responsable du Département',
    'select_department_head' => 'Sélectionner le Responsable du Département',
    'create_update_department' => 'Créer/Mettre à Jour le Département',

    /** Post */
    'post_section' => 'Section des Postes',
    'posts' => 'Postes',
    'add_post' => 'Ajouter un Poste',
    'search_by_department' => 'Rechercher par Département',
    'search_by_post_name' => 'Rechercher par Nom de Poste',
    'post_name' => 'Nom du Poste',
    'post_empty' => 'Poste Vide',
    'edit_post_title' => 'Modifier le Poste',
    'create_post_title' => 'Créer un Poste',
    'department_label' => 'Département',
    'post_name_label' => 'Nom du Poste',
    'status_label' => 'Statut',
    'select_department' => 'Sélectionner le Département',
    'active_option' => 'Actif',
    'inactive_option' => 'Inactif',
    'update_update_button' => 'Mettre à Jour le Poste',
    'change_status_confirmation' => 'Êtes-vous sûr de vouloir changer le statut ?',
    'delete_post_confirmation' => 'Êtes-vous sûr de vouloir supprimer le poste ?',
    'employee_list_title' => 'Liste des Employés',

    /** Employee List */
    'employees_title' => 'Employés',
    'employees_action' => 'Listes',
    'add_employee' => 'Ajouter un Employé',
    'employee_section' => 'Section des Employés',
    'employee_create' => 'Créer un Employé',
    'employee_name' => 'Nom de l\'Employé',
    'employee_email' => 'E-mail de l\'Employé',
    'employee_phone' => 'Numéro de Téléphone de l\'Employé',
    'full_name' => 'Nom Complet',
    'designation' => 'Désignation',
    'role' => 'Rôle',
    'shift' => 'Shift',
    'workplace' => 'Lieu de Travail',
    'is_active' => 'Est Actif',
    'edit_detail' => 'Modifier le Détail',
    'delete_user' => 'Supprimer l\'Utilisateur',
    'change_password' => 'Changer le Mot de Passe',
    'force_logout' => 'Forcer la Déconnexion',
    'all_fields_required' => 'Tous les champs (<span style="color: red">*</span>) sont obligatoires',
    'personal_detail' => 'Détail personnel',
    'employee_code' => 'Code Employé',
    'enter_name' => 'Entrez le nom',
    'enter_employee_address' => 'Entrez l\'adresse de l\'employé',
    'enter_email' => 'Entrez l\'email',
    'dob' => 'Date de naissance',
    'gender' => 'Sexe',
    'select_gender' => 'Sélectionnez le sexe',
    'marital_status' => 'État civil',
    'choose_marital_status' => 'Choisissez l\'état civil',
    'upload_avatar' => 'Télécharger l\'avatar',
    'description' => 'Description',
    'username' => 'Nom d\'utilisateur',
    'enter_username' => 'Entrez le nom d\'utilisateur',
    'password' => 'Mot de passe',
    'enter_password' => 'Entrez le mot de passe',
    'select_role' => 'Sélectionnez le rôle',
    'company_detail' => 'Détail de l\'entreprise',
    'supervisor' => 'Superviseur',
    'employment_type' => 'Type d\'emploi',
    'select_employment_type' => 'Sélectionnez le type d\'emploi',
    'joining_date' => 'Date d\'adhésion',
    'enter_joining_date' => 'Entrez la date d\'adhésion',
    'workspace' => 'Espace de travail',
    'select_workspace' => 'Sélectionnez le lieu de travail',
    'field' => 'Terrain',
    'office' => 'Bureau',
    'leave_detail' => 'Détail des congés',
    'leave_allocated' => 'Congé attribué',
    'assigned_leaves' => 'Congés assignés',
    'no_of_days' => 'Nombre de jours',
    'total_leave_days' => 'Total des jours de congé',
    'bank_detail' => 'Détail bancaire',
    'bank_name' => 'Nom de la banque',
    'bank_account_number' => 'Numéro de compte bancaire',
    'account_holder_name' => 'Nom du titulaire du compte',
    'bank_account_type' => 'Type de compte bancaire',
    'select_account_type' => 'Sélectionnez le type de compte',
    'create_user' => 'Créer un utilisateur',
    'update_user' => 'Mettre à jour l\'utilisateur',
    'new_password' => 'Nouveau mot de passe',
    'enter_new_password' => 'Entrez le nouveau mot de passe',
    'confirm_password' => 'Confirmez le mot de passe',
    'confirm_password_placeholder' => 'Confirmez le mot de passe',
    'submit' => 'Soumettre',
    'user_change_password' => 'L\'utilisateur change le mot de passe',
    'confirm_delete_employee' => 'Êtes-vous sûr de vouloir supprimer l\'employé ?',
    'confirm_force_logout' => 'Êtes-vous sûr de vouloir forcer la déconnexion de l\'utilisateur ?',
    'confirm_change_workplace' => 'Êtes-vous sûr de vouloir changer le lieu de travail ?',
    'select_supervisor' => 'Sélectionnez le superviseur',
    'select_office_time' => 'Sélectionnez l\'horaire du bureau',
    'select_option' => 'Sélectionnez une option',
    'enter_address' => 'Veuillez entrer l\'adresse.',
    'enter_valid_email' => 'Veuillez entrer une adresse email valide.',
    'enter_phone_number' => 'Veuillez entrer le numéro de téléphone.',
    'create_employee' => 'Créer un employé',
    'add' => 'Ajouter',
    'edit_user_detail' => 'Modifier les détails de l\'utilisateur',
    'show_user_details' => 'Afficher les détails de l\'utilisateur',
    'detail' => 'Détail',
    'back' => 'Retour',
    'user_detail' => 'Détail de l\'utilisateur',
    'date_of_birth' => 'Date de naissance',
    'not_applicable' => 'N/A',
    'office_detail' => 'Détail du bureau',
    'home' => 'Accueil',
    'account_detail' => 'Détail du compte',
    'account_number' => 'Numéro de compte',
    'account_type' => 'Type de compte',
    'account_holder' => 'Titulaire du compte',
    'not_available' => 'N/A',


    /** logout requests */
    'logout_request_status' => 'Statut de la demande de déconnexion',
    'take_action' => 'Prendre une action',
    'confirm_accept_logout_request' => 'Êtes-vous sûr de vouloir accepter la demande de déconnexion ?',

    /** attendance */
    'attendance' => 'Présence',
    'employee_attendance_lists' => 'Listes de présence des employés',
    'attendance_of_the_day' => 'Présence du jour',
    'date_placeholder_bs' => 'aa/mm/jj',
    'csv_export' => 'Export CSV',
    'attendance_status' => 'Statut de présence',
    'attendance_by' => 'Présence par',
    'show_detail' => 'Afficher les détails',
    'show_checkin_location' => 'Afficher le lieu de l\'enregistrement',
    'show_checkout_location' => 'Afficher le lieu de la sortie',
    'checkin' => 'enregistrement',
    'checkout' => 'sortie',
    'approved' => 'Approuvé',
    'rejected' => 'Rejeté',
    'self' => 'Soi',
    'admin' => 'Admin',
    'edit_attendance_time' => 'Modifier le temps de présence',
    'employee_attendance_detail' => 'Détail de la présence de l\'employé',
    'attendance_of' => 'Présence de',
    'total_days_in_month' => 'Nombre total de jours dans le mois',
    'present_days' => 'Jours présents',
    'absent_days' => 'Jours absents',
    'weekend_days' => 'Jours de week-end',
    'holiday_days' => 'Jours fériés',
    'leave_days' => 'Jours de congé',
    'working_hours' => 'Heures de travail',
    'worked_hours' => 'Heures travaillées',
    'attendance_details_of' => 'Détails de la présence de',
    'all_month' => 'Tout le mois',
    'worked_hour' => 'Heure travaillée',
    'add_attendance_time' => 'Ajouter le temps de présence',
    'confirm_change_attendance_status' => 'Êtes-vous sûr de vouloir changer le statut de présence ?',
    'check_in' => 'Enregistrer l\'entrée',
    'check_out' => 'Enregistrer la sortie',
    'attendance_title' => 'Présence',
    'attendance_action' => 'Détail de la présence de l\'employé',
    'filter_placeholder' => 'Année de présence par ex : :min_year',
    'filter_button' => 'Filtrer',
    'csv_export_button' => 'Export CSV',
    'reset_button' => 'Réinitialiser',
    'total_days' => 'Nombre total de jours dans le mois',
    'attendance_details' => 'Détails de présence de :monthName',
    'date' => 'Date',
    'change_attendance_status' => 'Changer le statut de présence',
    'create_attendance' => 'Créer une présence',
    'admin_remark' => 'Remarque de l\'administrateur',
    'edit_attendance' => 'Modifier la présence',
    'admin_edit_remark' => 'Remarque de modification de l\'administrateur',
    'confirm_check_in' => 'Êtes-vous sûr de vouloir enregistrer l\'entrée de l\'employé ?',
    'confirm_check_out' => 'Êtes-vous sûr de vouloir enregistrer la sortie de l\'employé ?',
    'edit_attendance_title' => 'Modifier la présence (:name) du :date',
    'create_attendance_title' => 'Créer la présence (:name) du :date',
    'total_worked_hours' => 'Nombre total d\'heures travaillées',
    'attendance_report' => 'Rapport de présence',

    /** clients */
    'client_listing' => 'Liste des clients',
    'add_client' => 'Ajouter un client',
    'client_name' => 'Nom du client',
    'client_email' => 'Email du client',
    'edit_client_detail' => 'Modifier les détails du client',
    'show_client_detail' => 'Afficher les détails du client',
    'delete_client_detail' => 'Supprimer les détails du client',
    'client_invoices' => 'Factures du client',
    'client_detail' => 'Détail du client :',
    'client_project_lists' => 'Listes des projets du client :',
    'country' => 'Pays',
    'edit_client' => 'Modifier le client',
    'create_client' => 'Créer un client',
    'client_section' => 'Section client',
    'client_contact' => 'Numéro de contact du client',
    'client_address' => 'Adresse',
    'client_country' => 'Pays',
    'upload_profile' => 'Télécharger le profil du client',
    'enter_client_name' => 'Entrez le nom du client',
    'enter_client_email' => 'Entrez l\'email du client',
    'enter_contact_number' => 'Entrez le numéro de contact',
    'enter_client_address' => 'Entrez l\'adresse du client',
    'enter_country' => 'Entrez le pays',
    'confirm_status_change' => 'Êtes-vous sûr de vouloir changer le statut ?',
    'confirm_delete_client' => 'Êtes-vous sûr de vouloir supprimer les détails du client ?',

    /** Project management */
    'lists' => 'Listes',
    'create_project' => 'Créer un projet',
    'project_filter' => 'Filtre de projet',
    'search_by_project' => 'Rechercher par projet',
    'search_by_status' => 'Rechercher par statut',
    'search_by_priority' => 'Rechercher par priorité',
    'client' => 'Client',
    'all_tasks' => 'Toutes les tâches',
    'completed_tasks' => 'Tâches terminées',
    'days_left' => 'jours restants',
    'team_member' => 'Membre de l\'équipe',
    'start_date' => 'Date de début',
    'due_date' => 'Date limite',
    'view' => 'Vue',
    'projects' => 'Projets',
    'assign_employee' => 'Assigner un employé',
    'client_contact_number' => 'Numéro de contact du client',
    'upload_client_profile' => 'Télécharger le profil du client',
    'project_name' => 'Nom du projet',
    'project_start_date' => 'Date de début du projet',
    'project_deadline' => 'Date limite du projet',
    'project_status' => 'État du projet',
    'select_project_status' => 'Sélectionner l\'état du projet',
    'project_cost' => 'Coût du projet',
    'select_priority' => 'Sélectionner la priorité',
    'estimated_hours' => 'Heures estimées',
    'select_client' => 'Sélectionner le client',
    'upload_project_logo' => 'Télécharger le logo du projet',
    'uploaded_files_images' => 'Fichiers et images téléchargés',
    'no_project_file_uploaded' => 'Aucun fichier de projet téléchargé',
    'update_project' => 'Mettre à jour le projet',
    'project_leader' => 'Chef de projet',
    'assign_member' => 'Assigner un membre',
    'edit_project' => 'Modifier le projet',
    'project_document' => 'Document du projet',
    'upload_documents' => 'Télécharger des documents',
    'upload_project_attachments' => 'Télécharger des pièces jointes de projet',
    'show_project_detail' => 'Afficher les détails du projet',
    'upload_attachments' => 'Télécharger des pièces jointes',
    'project_attachments' => 'Pièces jointes du projet',
    'uploaded_image_files' => 'Fichiers image téléchargés',
    'no_project_image_found' => 'Aucune image de projet trouvée',
    'uploaded_files' => 'Fichiers téléchargés',
    'no_project_files_found' => 'Aucun fichier de projet trouvé',
    'project_tasks_lists' => 'Listes des tâches du projet',
    'project_summary' => 'Résumé du projet',
    'cost' => 'Coût :',
    'total_hours' => 'Total des heures :',
    'created' => 'Créé :',
    'remaining_days' => 'Jours restants :',
    'project_leaders' => 'Chefs de projet',
    'update_leader' => 'Mettre à jour le chef',
    'project_members' => 'Membres du projet',
    'update_member' => 'Mettre à jour le membre',
    'project_client_detail' => 'Détail du client du projet',
    'delete_project_detail' => 'Êtes-vous sûr de vouloir supprimer les détails du projet ?',
    'delete_project_document' => 'Êtes-vous sûr de vouloir supprimer le document du projet ?',
    'search_by_member' => 'Rechercher par membre',
    'add_employee_to_project' => 'Ajouter un employé au projet',

    /** Task management */
    'tasks' => 'Tâches',
    'task_filter' => 'Filtre de tâches',
    'search_by_task_name' => 'Rechercher par nom de tâche',
    'not_started' => 'Pas commencé',
    'create_tasks' => 'Créer des tâches',
    'end_date' => 'Date de fin',
    'task_name' => 'Nom de la tâche',
    'enter_task_name' => 'Entrer le nom de la tâche',
    'select_project' => 'Sélectionner le projet',
    'task_start_date' => 'Date de début de la tâche',
    'task_start_time' => 'Heure de début de la tâche',
    'task_end_date' => 'Date de fin de la tâche',
    'task_end_time' => 'Heure de fin de la tâche',
    'task_status' => 'Statut de la tâche',
    'select_task_status' => 'Sélectionner le statut de la tâche',
    'uploaded_files_and_images' => 'Fichiers et images téléchargés',
    'task_attachments' => 'Pièces jointes de la tâche',
    'update_task' => 'Mettre à jour la tâche',
    'create_task' => 'Créer une tâche',
    'mention' => 'mention',
    'comment' => 'Commentaire',
    'close' => 'Fermer',
    'write_comment' => 'Écrire un commentaire',
    'reply' => 'Répondre',
    'delete_confirm' => 'Êtes-vous sûr de vouloir supprimer ":title" ?',
    'task_member_placeholder' => 'Attribuer un membre à la tâche',
    'project_placeholder' => 'Sélectionner un projet',
    'project_filter_placeholder' => 'Rechercher par projet',
    'task_name_placeholder' => 'Rechercher par nom de tâche',
    'change_task_status_confirm' => 'Êtes-vous sûr de vouloir changer le statut actif de la tâche ?',
    'change_status_confirm' => 'Êtes-vous sûr de vouloir changer le statut ?',
    'delete_task_detail_confirm' => 'Êtes-vous sûr de vouloir supprimer les détails de la tâche ?',
    'create_checklist_text' => 'Créer une liste de contrôle',
    'close_checklist_text' => 'Fermer',
    'remove_checklist_text' => 'Supprimer',
    'remove_checklist_title' => 'Supprimer la liste de contrôle',
    'view_all_comments' => 'Voir tous les commentaires',
    'comments' => 'Commentaires',
    'edit_task' => 'Modifier la tâche',
    'edit_task_detail' => 'Modifier les détails de la tâche',
    'show_task_detail' => 'Afficher les détails de la tâche',
    'task_edit' => 'Modifier la tâche',
    'create_checklist' => 'Créer une liste de contrôle',
    'upload_attachment' => 'Télécharger une pièce jointe',
    'total_checklist' => 'Total des listes de contrôle',
    'completed_checklist' => 'Listes de contrôle complétées',
    'task_checklist_lists' => 'Listes de contrôle des tâches',
    'assigned_to' => 'Assigné à',
    'create_task_checklist' => 'Créer une liste de contrôle de tâche',
    'enter_checklist_title' => 'Entrer le titre de la liste de contrôle',
    'select_member' => 'Sélectionner un membre',
    'add_more_checklist' => 'Ajouter plus de listes de contrôle',
    'image' => 'Image',
    'file' => 'Fichier',
    'edit_checklist' => 'Modifier la liste de contrôle',
    'delete_checklist' => 'Supprimer la liste de contrôle',
    'checklist' => 'Liste de contrôle',
    'edit_task_checklist' => 'Modifier la liste de contrôle de la tâche',
    'checklist_name' => 'Nom de la liste de contrôle',
    'assign_task_checklist' => 'Attribuer une liste de contrôle de tâche',
    'task_summary' => 'Résumé de la tâche',
    'task_members' => 'Membres de la tâche',
    'task_attachment_title' => 'Pièces jointes de la tâche',
    'upload_attachment_action' => 'Télécharger une pièce jointe',
    'upload_task_attachments' => 'Télécharger des pièces jointes de la tâche',
    'upload_task_attachments_text' => 'Télécharger des pièces jointes de la tâche',
    'choose_file_text' => 'Choisir un fichier',

    /** Holiday */
    'holiday_section' => 'Section Vacances',
    'event' => 'Événement',
    'event_date' => 'Date de l\'événement',
    'is_public_holiday' => 'Est-ce un jour férié ?',
    'confirm_delete_holiday' => 'Êtes-vous sûr de vouloir supprimer les détails de cette vacance ?',
    'holiday_detail_title' => 'Détail des Vacances',
    'holiday' => 'Vacances',
    'csv_import' => 'Importation CSV',
    'import' => 'Importer',
    'holiday_detail_csv' => 'Détail des Vacances en CSV',
    'holiday_csv_example' => 'Exemple de CSV pour les Vacances',
    'add_holiday' => 'Ajouter des Vacances',
    'import_holiday_csv' => 'Importer un fichier CSV de Vacances',
    'holiday_filter' => 'Filtre des Vacances',
    'event_name' => 'Nom de l\'événement',
    'leave_requested_year' => 'Année de la demande de congé',
    'holiday_detail' => 'Détail des Vacances',

    /** Notice */
    'notices_section' => 'Section des avis',
    'notice_title' => 'Titre de l\'avis',
    'notice_description' => 'Description de l\'avis',
    'notice_receiver' => 'Destinataire de l\'avis',
    'send_notice' => 'Envoyer un avis',
    'all_employees' => 'Tous les employés',
    'create_notice' => 'Créer un avis',
    'edit_notice' => 'Modifier l\'avis',
    'notices' => 'Avis',
    'receiver' => 'Destinataire',
    'published_from' => 'Publié à partir de',
    'publish_to' => 'Publié jusqu\'à',
    'publish_date' => 'Date de publication',
    'show_notice_content' => 'Afficher le contenu de l\'avis',
    'delete_notice_detail' => 'Supprimer les détails de l\'avis',
    'notice_lists' => 'Listes des avis',
    'confirm_change_notice_status' => 'Êtes-vous sûr de vouloir changer le statut de l\'avis ?',
    'confirm_delete_notice' => 'Êtes-vous sûr de vouloir supprimer l\'avis ?',
    'confirm_send_notice' => 'Êtes-vous sûr de vouloir envoyer l\'avis ?',
    'notice_detail_modal_title' => 'Détail de l\'avis :title',


    /** payroll */
    'employee_payroll'=>'Paie des employés',
    'payroll_generate'=>'Générer la paie',
    'payroll_create'=>'Créer la paie',
    'payroll_edit'=>'Modifier la paie',
    'select_year' => 'Sélectionnez l\'année',
    'salary_cycle' => 'Cycle de salaire',
    'salary_month' => 'Mois de salaire',
    'salary_week' => 'Semaine de salaire',
    'select_week' => 'Sélectionnez la semaine',
    'include_tada' => 'Inclure TADA',
    'include_advance_salary' => 'Inclure le salaire anticipé',
    'use_attendance' => 'Utiliser la présence',
    'generate' => 'Générer',
    'clear' => 'Effacer',
    'report' => 'Rapport:',
    'duration' => 'Durée',
    'payroll_summary' => 'Résumé de la paie',
    'total_basic_salary' => 'Salaire de base total:',
    'total_net_salary' => 'Salaire net total:',
    'total_allowance' => 'Indemnité totale:',
    'total_deduction' => 'Déduction totale:',
    'total_overtime' => 'Total des heures supplémentaires:',
    'total_undertime' => 'Total des heures non effectuées:',
    'paid_by'=>'Payé par',
    'net_salary'=>'Salaire net',
    'paid_on'=>'Payé le',
    'pay_button' => 'Payer',
    'select_payment_method.'=>'Veuillez sélectionner un mode de paiement.',
    'confirm_delete_payroll'=>'Êtes-vous sûr de vouloir supprimer la paie de l\'employé?',
    'confirm_generate_payroll'=>'Êtes-vous sûr de vouloir générer la paie?',
    'confirm_change_cycle'=>'Êtes-vous sûr de vouloir changer le cycle salarial?',
    'payment_title' => 'Effectuer le paiement',
    'payment_method_placeholder' => 'Sélectionnez un mode de paiement',
    'payment_date' => 'Date de paiement',
    'hourly_rate' => 'Taux horaire',
    'hourly' => 'Horaire',
    'working_hours_in_week' => 'Heures de travail dans la semaine',
    'annual_salary' => 'Salaire annuel (CTC)',
    'annual' => 'Annuel',
    'basic_salary' => 'Salaire de base',
    'fixed_allowance' => 'Indemnité fixe',
    'total' => 'Total',
    'net_total' => 'Total net',
    'earnings' => 'Gains',
    'deductions' => 'Déductions',
    'create_salary '=>'Créer un salaire',
    'edit_salary '=>'Modifier le salaire',
    'add_salary '=>'Ajouter un salaire',
    'calculation_type'=>'Type de calcul',
    'monthly_amount'=>'Montant mensuel',
    'annual_amount'=>'Montant annuel',
    'salary_slip' => 'Bulletin de salaire',
    'edit_salary_slip' => 'Modifier le bulletin de salaire',
    'payslip' => 'Fiche de paie',
    'for_the_month_of' => 'pour le mois de',
    'from'=>'de',
    'to'=>'à',
    'employee_id'=>'ID de l\'employé',
    'earning' => 'Revenu',
    'deduction' => 'Déduction',
    'actual_salary' => 'Salaire réel',
    'total_earning'=>'Revenu total',
    'actual_salary_formula' => '(Revenu total - Déductions totales)',
    'bonus' => 'Bonus',
    'taxable_salary' => 'Salaire imposable',
    'taxable_salary_formula' => '(Salaire réel + Bonus)',
    'tax' => 'Taxe',
    'salary_after_tax' => 'Salaire après impôt',
    'expenses_claim' => 'Réclamations de frais (TADA)',
    'absent' => 'Absent',
    'absent_deduction_formula' => '((Salaire brut / nombre total de jours) * jours d\'absence)',
    'net_salary_formula' => 'Salaire net = (Salaire réel - Salaire anticipé + TADA)',
    'monthly' => 'Mensuel',
    'weekly' => 'Hebdomadaire',
    'salary_increment' => 'Augmentation de salaire',
    'increment' => 'Augmentation',
    'current_salary' => 'Salaire actuel',
    'annual_increment_percent' => 'Pourcentage d\'augmentation annuelle',
    'annual_increment_amount' => 'Montant de l\'augmentation annuelle',
    'revised_salary_label' => 'Salaire révisé',
    'fiscal_year_label' => 'Augmentation pour l\'année fiscale',
    'applicable_from_label' => 'Applicable à partir de (Date)',
    'applicable_to_label' => 'Applicable jusqu\'à (Date)',
    'remark' => 'Remarque',
    'fiscal_year' => 'Année fiscale',
    'select_fiscal_year' => 'Sélectionnez l\'année fiscale',
    'list'=>'Liste',
    'employee_salary_filter'=>'Filtre de salaire des employés',
    'salary_review_history'=>'Historique des révisions salariales',
    'increase_salary'=>'Augmenter le salaire',
    'all'=>'Tous',
    'employee_payslip'=>'Fiche de paie de l\'employé',
    'salary_from'=>'Salaire de',
    'salary_to'=>'Salaire à',
    'unpaid_leave'=>'Congé non payé',
    'paid_leave'=>'Congé payé',
    'employee_gross_salary'=>'Salaire brut de l\'employé',
    'salary_increment_log'=>'Journal des augmentations de salaire',
    'log'=>'Journal',
    'salary_revised_on'=>'Salaire révisé le',
    'increment_by'=>'Augmentation de',
    'increment_value'=>'Valeur de l\'augmentation',
    'old_salary'=>'Ancien salaire',
    'new_salary'=>'Nouveau salaire',
    'date_to'=>'Date à',
    'date_from'=>'Date de',
    'salary_increment_remark'=>'Remarque sur l\'augmentation de salaire',
    'advance_salary_requests'=>'Demandes de salaire anticipé',
    'advance_salary_request_filter'=>'Filtre de demandes de salaire anticipé',
    'delete_confirmation'=>'Êtes-vous sûr de vouloir supprimer?',
    'payslip_for_the_month_of'=>'Fiche de paie pour le mois de',
    'absent_deduction'=>'Déduction pour absence',



    /** Advance Salary */
    'is_paid' => 'Est Payé?',
    'released_on' => 'Publié Le',
    'requested_on' => 'Demandé Le',
    'released_amount' => 'Montant Publié',
    'requested_amount' => 'Montant Demandé',
    'search_by_month' => 'Rechercher par Mois',
    'search_by_employee_name' => 'Rechercher par Nom de l\'Employé',
    'advance_salary_detail' => 'Détail du Salaire Avancé',
    'is_settled' => 'Est Réglementé',
    'verified_by' => 'Vérifié Par',
    'amount_released_date' => 'Date de Publication du Montant',
    'advance_requested_date' => 'Date de Demande d\'Avance',
    'total_released_amount' => 'Montant Total Publié',
    'total_request_amount' => 'Montant Total Demandé',
    'employee' => 'Employé',
    'select_employee' => 'Sélectionner l\'Employé',
    'advance_salary_request_detail' => 'Détail de la Demande de Salaire Avancé',
    'proof_of_advance_salary_payment' => 'Preuve du Paiement du Salaire Avancé',
    'attachments' => 'Pièces Jointes',
    'processing' => 'Traitement en Cours',

    /** Tax report */
    'tax_report' => 'Rapport Fiscal',
    'employee_tax_report' => 'Rapport Fiscal des Employés',
    'tax_report_edit' => 'Modifier le Rapport Fiscal',
    'tax_report_detail_of' => 'Détail du Rapport Fiscal de',
    'tax_report_detail' => 'Détail du Rapport Fiscal',
    'salary_sheet' => 'Feuille de Paie',
    'particular' => 'Particulier',
    'income' => 'Revenu',
    'tax_data_not_available' => 'Données fiscales non disponibles pour l’état civil actuel',
    'remain_tds_formula' => '(TDS Total Dû / Nombre de mois restants)',
    'remaining_month' => 'Mois Restant',
    'tds_calculation_msg' => 'Calcul de TDS pour le Mois Actuel (Mois de Calcul)',
    'total_due_tds' => 'Total TDS Dû',
    'total_paid_tds' => 'Total TDS Payé',
    'total_payable_tds' => 'Total TDS à Payer',
    'other_discount' => 'Autre Remise',
    'female_discount' => 'Remise pour Femmes',
    'medical_claim' => 'Réclamation Médicale',
    'less' => 'moins',
    'less_tax_deduction' => 'moins: Déduction Fiscale',
    'tax_amount' => 'Montant Fiscal',
    'percent' => 'Pourcentage',
    'tax_calculation_on_taxable_income' => 'Calcul Fiscal sur le Revenu Imposable',
    'taxable_income' => 'Revenu Imposable',
    'ssf_contribution' => 'Contribution SSF',
    'ssf_contribution_salary' => 'Contribution SSF au Salaire',
    'total_retirement_contribution_allowed' => 'Contribution Totale à la Retraite Autorisée',
    'total_income' => 'Revenu Total',
    'amount' => 'Montant',
    'additional_information' => 'Informations Supplémentaires',
    'total_payable' => 'Total à Payer',
    'tds_paid' => 'TDS Payé',
    'ssf_deduction' => 'Déduction SSF',
    'tax_report_generate' => 'Générer le Rapport Fiscal',
    'print' => 'Imprimer',
    'gross_earnings' => 'Revenus Bruts',
    'tax_payable' => 'Impôt à Payer',

    /** Payroll Setting  */
    'advance_salary_limit' => 'Limite de Salaire Avancé',
    'select_month' => 'Sélectionner Mois',
    'applicable_month' => 'Mois Applicable',
    'value' => 'Valeur',
    'value_type' => 'Type de Valeur',
    'enter_bonus_type' => 'Entrer le Type de Prime',
    'salary_components' => 'Composants du Salaire',
    'add_bonus' => 'Ajouter Prime',
    'max_daily_ot' => 'Max. Heures Supplémentaires Quotidiennes',
    'assign_overtime_to_employee' => 'Attribuer Heures Supplémentaires au Employé',
    'overtime_pay_rate' => 'Taux de Paiement des Heures Supplémentaires (par heure)',
    'overtime_rate_percent' => 'Pourcentage du Taux des Heures Supplémentaires (par heure)',
    'placeholder_overtime_pay_rate' => 'Entrer Taux de Paiement des Heures Supplémentaires',
    'placeholder_overtime_rate_percent' => 'Entrer Pourcentage du Taux des Heures Supplémentaires',
    'rate_type' => 'Type de Taux',
    'select_rate_type' => 'Sélectionner Type de Taux',
    'ot_valid_after_hour' => 'Heures Supplémentaires Valides Après ? Heure',
    'placeholder_ot_valid_after_hour' => 'Entrer Heures Après lesquelles les Heures Supplémentaires Sont Valides',
    'monthly_ot' => 'Max. Heures Supplémentaires Mensuelles',
    'placeholder_monthly_ot' => 'Entrer Max. Heures Supplémentaires Mensuelles',
    'weekly_ot' => 'Max. Heures Supplémentaires Hebdomadaires',
    'placeholder_weekly_ot' => 'Entrer Max. Heures Supplémentaires Hebdomadaires',
    'daily_ot' => 'Max. Heures Supplémentaires Quotidiennes',
    'placeholder_daily_ot' => 'Entrer Max. Heures Supplémentaires Quotidiennes',
    'pay_percent' => 'Pourcentage/Taux de Paiement',
    'employee_count' => 'Nombre d\'Employés',
    'hour' => 'Heure',
    'currency_setting' => 'Paramètres de Devise',
    'payroll_currency' => 'Devise de Paie',
    'choose_payroll_currency' => 'Choisir Devise de Paie',
    'add_payment_method' => 'Ajouter Méthode de Paiement',
    'payment_method_name' => 'Nom de Méthode de Paiement',
    'update_payment_method' => 'Mettre à Jour Méthode de Paiement',
    'component_value' => 'Valeur du Composant',
    'component_type' => 'Type de Composant',
    'add_salary_component' => 'Ajouter Composant de Salaire',
    'apply_for_all' => 'Appliquer à Tous',
    'component_value_annual' => 'Valeur du Composant (Annuel)',
    'select_value_type' => 'Sélectionner Type de Valeur',
    'select_component_type' => 'Sélectionner Type de Composant',
    'enter_salary_component_name' => 'Entrer Nom du Composant de Salaire',
    'add_salary_group' => 'Ajouter Groupe de Salaire',
    'delete_confirm_salary_group' => 'Êtes-vous sûr de vouloir supprimer les détails du groupe ?',
    'assign_employee_to_group' => 'Attribuer Employé au Groupe',
    'choose_salary_component' => 'Choisir Composant de Salaire',
    'assign_salary_components' => 'Attribuer Composants de Salaire',
    'enter_salary_group_name' => 'Entrer Nom du Groupe de Salaire',
    'add_more_tds_detail' => 'Ajouter Plus de Détails de TDS',
    'enter_tds_in_percent' => 'Entrer TDS en Pourcentage',
    'enter_annual_salary_to' => 'Entrer Salaire Annuel Jusqu\'à',
    'enter_annual_salary_from' => 'Entrer Salaire Annuel Depuis',
    'select_marital_status' => 'Sélectionner État Civil',
    'create_salary_tds' => 'Créer TDS de Salaire',
    'update_salary_tds' => 'Mettre à Jour TDS de Salaire',
    'salary_tds_detail_for_single' => 'Détails de TDS de Salaire pour Célibataires',
    'add_salary_tds' => 'Ajouter TDS de Salaire',
    'annual_salary_to' => 'Salaire Annuel Jusqu\'à',
    'annual_salary_from' => 'Salaire Annuel Depuis',
    'tds' => 'TDS (%)',
    'salary_tds_detail_for_married' => 'Détails de TDS de Salaire pour Mariés',
    'ssf' => 'SSF',
    'employee_contribution' => 'Contribution de l\'Employé',
    'office_contribution' => 'Contribution du Bureau',
    'assign_undertime_to_employee' => 'Attribuer Temps Manquant au Employé',
    'enter_title' => 'Entrer Titre',
    'undertime_after_minute' => 'Minutes Après lesquelles le Temps Manquant est Appliqué',
    'placeholder_ut_after' => 'Entrer Heures Après lesquelles le Temps Manquant est Appliqué',
    'penalty_type' => 'Type de Pénalité',
    'select_penalty_type' => 'Sélectionner Type de Pénalité',
    'penalty_percent' => 'Pourcentage de Pénalité (par heure)',
    'penalty_percent_placeholder' => 'Entrer Pourcentage de Pénalité pour Temps Manquant',
    'penalty_rate' => 'Taux de Pénalité (par heure)',
    'penalty_rate_placeholder' => 'Entrer Taux de Pénalité pour Temps Manquant',

    /** Leave */
    'leave_type_section' => 'Section Type de Congé',
    'select_leave_type' => 'Sélectionner le Type de Congé',
    'leave_type' => 'Type de Congé',
    'leave_allocated_days' => 'Jours de Congé Alloués',
    'allocated_days' => 'Jours Alloués',
    'is_paid_leave' => 'Congé Payé',
    'leave_type_name' => 'Nom du Type de Congé',
    'leave_type_placeholder' => 'Saisir le Type de Congé',
    'add_leave_type' => 'Ajouter un Type de Congé',
    'type' => 'Type',
    'edit_leave_type_detail' => 'Modifier les Détails du Type de Congé',
    'delete_leave_type' => 'Supprimer le Type de Congé',
    'delete_leave_confirmation' => 'Êtes-vous sûr de vouloir supprimer le Type de Congé ?',
    'leave_request_section' => 'Section Demande de Congé',
    'approve' => 'Approuver',
    'reject' => 'Rejeter',
    'from_date' => 'À partir de la Date',
    'to_date' => 'À la Date',
    'start_time' => 'Heure de Début',
    'end_time' => 'Heure de Fin',
    'reason' => 'Raison',
    'requested_for' => 'Demandé Pour',
    'requested_by' => 'Demandé Par',
    'requested_days' => 'Jours Demandés',
    'requested_date' => 'Date de Demande',
    'all_status' => 'Tous les Statuts',
    'all_leave_type' => 'Tous les Types de Congé',
    'leave_request_filter' => 'Filtre de Demande de Congé',
    'create_leave_request' => 'Créer une Demande de Congé',
    'leave_reason' => 'Raison du Congé',
    'referred_by' => 'Référé Par',
    'leave_date' => 'Date du Congé',
    'time_leave_request_filter' => 'Filtre de Demande de Congé par Temps',
    'create_time_leave_request' => 'Créer une Demande de Congé par Temps',
    'time_leave_request_section' => 'Section Demande de Congé par Temps',
    'time_leave_status_update' => 'Mise à Jour du Statut de Congé par Temps',

    /** Team Meeting */
    'team_meeting_section' => 'Section Réunion d\'Équipe',
    'update_and' => 'mettre à jour et',
    'create_and' => 'Créer et',
    'send' => 'Envoyer',
    'meeting_participator' => 'Participant à la réunion',
    'image_hint' => 'L\'image est recommandée en format paysage',
    'meeting_description' => 'Description de la réunion',
    'upload_image' => 'Télécharger l\'image',
    'meeting_start_time' => 'Heure de Début de la Réunion',
    'meeting_date' => 'Date de la Réunion',
    'meeting_venue' => 'Lieu de la Réunion',
    'enter_venue_name' => 'Saisir le nom du lieu',
    'enter_content_title' => 'Saisir le titre du contenu',
    'meeting_title' => 'Titre de la Réunion',
    'delete_team_meeting_confirmation' => 'Êtes-vous sûr de vouloir supprimer la réunion d\'équipe?',
    'image_delete_confirmation' => 'Êtes-vous sûr de vouloir supprimer l\'image?',
    'create_team_meeting' => 'Créer une Réunion d\'Équipe',
    'delete_team_meeting' => 'Supprimer les détails de la réunion d\'équipe',
    'edit_meeting_detail' => 'Modifier les détails de la réunion',
    'show_team_meeting' => 'Afficher le contenu de la réunion d\'équipe',
    'participators' => 'Participants',
    'participator' => 'Participant',
    'team_meeting_filter' => 'Filtre Réunion d\'Équipe',
    'agenda' => 'Agenda',
    'creator' => 'Créateur',

    /** Tada */
    'tada_attachment' => 'Pièce jointe Tada',
    'upload_tada_attachment' => 'Télécharger la pièce jointe Tada',
    'accepted' => 'Accepté',
    'tada_status_change' => 'Êtes-vous sûr de vouloir changer le statut de règlement de Tada?',
    'delete_tada_confirm' => 'Êtes-vous sûr de vouloir supprimer :title?',
    'uploaded_attachment' => 'Pièce jointe téléchargée',
    'no_attachment_file' => 'Aucun fichier joint',
    'total_expense' => 'Dépense Totale',
    'create_tada' => 'Créer Tada',
    'edit_tada' => 'Modifier Tada',
    'tada_listing' => 'Liste Tada',
    'tada_filter' => 'Filtre Tada',
    'submitted_date' => 'Date de Soumission',
    'expense' => 'Dépense',
    'tada_detail' => 'Détail Tada',
    'verified_date' => 'Date de Vérification',
    'tada_summary' => 'Résumé Tada',
    'update_status' => 'Mettre à jour le statut',
    'category' => 'Catégorie',
    'select_category' => 'Sélectionner la Catégorie',
    'opening_time' => 'Heure d\'Ouverture',
    'closing_time' => 'Heure de Fermeture',
    'checkin_checkout_rule' => 'Règle d\'Enregistrement/Sortie',
    'early_check_in' => 'Enregistrement Précoce',
    'check_in_before' => 'Peut s\'enregistrer avant (en minutes)',
    'checkin_before' => 'Enregistrement Avant',
    'enter_check_in_before' => 'Entrez combien de minutes avant l\'enregistrement est possible',
    'early_check_out' => 'Sortie Précoce',
    'check_out_before' => 'Peut sortir avant (en minutes)',
    'checkout_before' => 'Sortie Avant',
    'enter_check_out_before' => 'Entrez combien de minutes avant la sortie est possible',
    'late_check_in' => 'Enregistrement Tardif',
    'check_in_after' => 'Peut s\'enregistrer après (en minutes)',
    'checkin_after' => 'Enregistrement Après',
    'enter_check_in_after' => 'Entrez combien de minutes après l\'enregistrement est possible',
    'late_check_out' => 'Sortie Tardive',
    'checkout_after' => 'Sortie Après',
    'check_out_after' => 'Peut sortir après (en minutes)',
    'enter_check_out_after' => 'Entrez combien de minutes après la sortie est possible',
    'enter_shift_name' => 'Entrez le Nom du Quart',
    'select_shift' => 'Sélectionner le Quart',
    'delete_office_time_confirm' => 'Êtes-vous sûr de vouloir supprimer l\'horaire du bureau?',
    'office_time_detail' => 'Détail de l\'Horaire du Bureau',
    'office_schedule' => 'Horaire du Bureau',
    'add_office_time' => 'Ajouter l\'Horaire du Bureau',

    /** Award Types */
    'award_distributed' => 'Prix Distribué',
    'add_award_types' => 'Ajouter des Types de Prix',
    'gift_item' => 'Article de Cadeau',
    'awarded_date' => 'Date de Décernement',

    /** Award */
    'award' => 'Prix',
    'award_name' => 'Nom du Prix',
    'select_award_type' => 'Sélectionner le Type de Prix',
    'enter_gift_item' => 'Entrer l\'Article de Cadeau',
    'award_base' => 'Base du Prix',
    'select_award_base' => 'Sélectionner la Base du Prix',
    'awarded_by' => 'Décerné Par',
    'enter_awarded_by' => 'Entrer Décerné Par',
    'award_description' => 'Description du Prix',
    'gift_description' => 'Description du Cadeau',
    'reward_code' => 'Code de Récompense',
    'enter_reward_code' => 'Entrer le Code de Récompense',
    'add_award' => 'Ajouter un Prix',
    'attachment' => 'Pièce Jointe',
    'award_lists' => 'Listes des Prix',

    /** Asset Types */
    'add_asset_types' => 'Ajouter des Types d\'Actifs',
    'asset_item_count' => 'Nombre d\'Articles d\'Actifs',
    'asset_type' => 'Type d\'Actif',
    'asset_name' => 'Nom de l\'Actif',
    'purchased_date' => 'Date d\'Achat',
    'is_working' => 'En Fonctionnement',
    'is_available' => 'Disponible',
    'asset' => 'Actif',

    /** Assets */
    'select_asset_type' => 'Sélectionner le Type d\'Actif',
    'assigned_date' => 'Date d\'Attribution',
    'is_available_for_employee' => 'Disponible pour l\'Employé',
    'select_availability' => 'Sélectionner la Disponibilité',
    'warranty_end_date' => 'Date de Fin de Garantie',
    'warranty_available' => 'Garantie Disponible',
    'select_warranty_availability' => 'Sélectionner la Disponibilité de la Garantie',
    'asset_serial_number' => 'Numéro de Série de l\'Actif',
    'enter_asset_serial_number' => 'Entrer le Numéro de Série de l\'Actif',
    'asset_code' => 'Code de l\'Actif',
    'enter_asset_code' => 'Entrer le Code de l\'Actif',
    'change_availability_status' => 'Êtes-vous sûr de vouloir changer le statut de disponibilité ?',
    'delete_asset_confirm' => 'Êtes-vous sûr de vouloir supprimer :title ?',
    'add_asset' => 'Ajouter un Actif',
    'asset_image' => 'Image de l\'Actif',
    'asset_assigned_employee' => 'Employé Assigné à l\'Actif',
    'assets_filter' => 'Filtre des Actifs',
    'working_status' => 'Statut de Fonctionnement',
    'availability_status' => 'Statut de Disponibilité',
    'yes_available' => 'Oui, Disponible',
    'notavailable' => 'Non Disponible',
    'purchased_from' => 'Acheté De',
    'purchased_to' => 'Acheté À',

    /** Content Management */
    'content_section' => 'Section de Contenu',
    'content' => 'Contenu',
    'content_type' => 'Type de Contenu',
    'content_title' => 'Titre du Contenu',
    'select_content_type' => 'Sélectionner le Type de Contenu',
    'delete_content_confirm' => 'Êtes-vous sûr de vouloir supprimer le contenu de la page statique ?',
    'company_static_content' => 'Contenu Statique de l\'Entreprise',
    'add_content' => 'Ajouter du Contenu',

    /** Support */
    'delete_support_confirm' => 'Êtes-vous sûr de vouloir supprimer :title ?',
    'ticket_lists' => 'Listes de Tickets',
    'query_by' => 'Requête par',
    'concerned_department' => 'Département Concerné',
    'unseen' => 'Non vu',
    'read_status' => 'Statut de Lecture',
    'seen' => 'Vu',
    'query_status' => 'Statut de la Requête',
    'support_filter' => 'Filtre de Support',
    'query_lists' => 'Listes des Requêtes',
    'department_support_requested_from' => 'Support demandé du Département',
    'department_support_requested_to' => 'Support demandé au Département',
    'change_query_status' => 'Changer le Statut de la Requête',

    /** Router */
    'router_section' => 'Section du Routeur',
    'router_bssid' => 'BSSID du Routeur',
    'router' => 'Routeur',
    'router_detail' => 'Détails du Routeur',
    'add_router' => 'Ajouter un Routeur',

    /** QR */
    'scan_me' => 'Scannez-moi',
    'attendance_qr' => 'QR de Présence',
    'qr_image' => 'Image QR',
    'add_qr' => 'Ajouter QR',
    'qr_section' => 'Section QR',

    /** NFC */
    'nfc_section' => 'Section NFC',
    'created_by' => 'Créé par',

    /** Role and permission */
    'role_section' => 'Section des Rôles',
    'autorize_backend_login' => 'Autoriser la Connexion Backend',
    'role_name' => 'Nom du Rôle',
    'permissions' => 'Permissions',
    'check_all' => 'Tout Sélectionner',
    'module' => 'Module',
    'add_role' => 'Ajouter un Rôle',
    'assign_permissions' => 'Attribuer les Permissions',
    'confirm_role_deletion' => 'Êtes-vous sûr de vouloir supprimer le rôle ?',
    'can_login' => 'Peut se Connecter',
    'permission_setting' => 'Paramètres des Permissions',
    'assign' => 'Attribuer',

    /** General Setting */
    'general_setting_section' => 'Section des paramètres généraux',
    'general_setting' => 'Paramètres généraux',

    /** App Setting */
    'export_database_data' => 'Exporter les données de la base de données',
    'check_router_bssid' =>'Vérifier le BSSID du routeur',

    /** Fiscal Years */
    'fiscal_years' => 'Années Fiscales',
    'year' => 'Année',
    'add_fiscal_year' => 'Ajouter une Année Fiscale',

    /** Notifications */
    'notification_section' => 'Section des notifications',
    'confirm_notification_send' => 'Êtes-vous sûr de vouloir envoyer la notification ?',
    'notification' => 'Notification',
    'published_date' => 'Date de publication',
    'all_types' => 'Tous les types',
    'notification_lists' => 'Listes des notifications',
    'notified_member' => 'Membre notifié',
    'notification_title' => 'Titre de la notification',
    'notification_description' => 'Description de la notification',
    'send_notification' => 'Envoyer la notification',
    'enter_notification_title' => 'Entrez le titre de la notification',

    /** feature control */
    'app_setting' => 'App Setting',
    'sn' => 'SN',
    'group' => 'Group',
    'export_table_data' => 'Export Table Data',
    'leave_requests' => 'Leave Requests',
    'employee_lists' => 'Employee Lists',
    'attendances' => 'Attendances',
    'confirm_change_status' => 'Are you sure you want to change status?',
    'yes' => 'Yes',
    'no' => 'No',

    /** Api response */
    /** Auth Controller */
    'invalid_login_credentials'=>'Identifiants de connexion invalides!',
    'authenticated'=>'Authentifié',
    'user_detail_not_found'=>'Détails de l\'utilisateur introuvables',
    'partial_logout_successful'=>'Déconnexion partielle réussie',
    /** Dashboard Controller */
    'data_found'=>'Données trouvées',
    /** AdvanceSalary Controller */
    'advance_salary_pending_error'=>'Un autre salaire avancé ne peut être demandé tant que la demande précédente n\'est pas réglée.',
    'data_updated_successfully'=>'Données mises à jour avec succès',
    'user_updated_advance_salary_request' => ':name a mis à jour les détails de la demande de salaire avancé',
    'data_created_successfully'=>'Données créées avec succès',
    'advance_salary_request_alert'=>'Alerte de demande de salaire avancé',
    'user_submitted_advance_salary_request' => ':name a soumis une demande de salaire avancé d\'un montant de :amount',
    /** Attendance Api */
    'check_out_successful'=>'Départ réussi',
    'check_out_notification'=>'Notification de départ',
    'check_in_successful'=>'Arrivée réussie',
    'check_in_notification'=>'Notification d\'arrivée',
    'not_checked_in_yet'=>'Pas encore enregistré',
    'alert_multi_checkin_shift'=>'Désolé! L\'employé ne peut pas s\'enregistrer deux fois sur un même quart de travail.',
    'checkout_alert_for_shift'=>'L\'employé a déjà quitté le quart de travail',
    'alert_checkin'=>'Désolé! l\'employé ne peut pas s\'enregistrer deux fois dans une journée.',
    'checkout_alert'=>'L\'employé a déjà quitté aujourd\'hui',
    'attendance_alert_status'=>':status déjà effectué',
    'employee_checked_in' => ':name est arrivé à :time',
    'employee_checked_out' => ':name est parti à :time',
    'has_worked_for' => 'et a travaillé pendant :time',
    'multi_checkout_warning'=>'Vous avez atteint le nombre maximum d\'arrivées et de départs autorisés pour aujourd\'hui.',
    'employee_checked_out_and_worked' => ':name est parti à :check_out_time et a travaillé pendant :worked_time',
    'invalid_attendance_type'=>'Type de présence invalide.',
    'invalid_qr'=>'QR invalide ou non disponible',
    'invalid_nfc'=>'Jeton NFC invalide ou NFC non disponible',
    'validation_failed'=>'Échec de la validation',

    /** Leave Api Controller */
    'leave_request_cancelled' => 'Demande de congé annulée avec succès',
    'leave_request_cannot_be_cancelled' => 'La demande de congé ne peut pas être annulée une fois mise à jour depuis l’état en attente.',
    'leave_request_notification' => 'Notification de demande de congé',
    'leave_request_submitted' => ':name a demandé un congé du :start_time au :end_time le :issue_date. Raison : :reasons',
    'leave_request_submitted_successfully' => 'Demande de congé envoyée avec succès',
    'leave_request_cancelled_successfully' => 'Demande de congé annulée avec succès',
    'leave_request_submit' => ':name a demandé :no_of_days jour(s) de congé à partir de :leave_from le :leave_requested_date. Raison : :reasons',

    /** NFC api Controller */
    'nfc_token_already_exist' => 'Le jeton NFC existe déjà.',
    'nfc_added_successfully' => 'NFC ajouté avec succès',

    /** Notification Api Controller */
    'updated_successfully' => 'Mis à jour avec succès',
    'successfully_sent_notification' => 'Notification envoyée avec succès',
    'data_not_found' => 'Données non trouvées',
    'content_not_found' => 'Contenu non trouvé',

    /** Support Api Controller */
    'support_notification' => 'Notification de support',
    'support_request_submitted' => ':name a demandé du support.',
    'query_submitted_successfully' => 'Demande envoyée avec succès',

    /** Tada Api Controller  */
    'attachment_detail_not_found' => 'Détails de la pièce jointe non trouvés',
    'cannot_delete_attachment_detail' => 'Impossible de supprimer les détails de la pièce jointe une fois vérifiés',
    'upload_another_attachment_before_delete' => 'Veuillez télécharger une autre pièce jointe avant de supprimer.',
    'attachment_deleted_successfully' => 'Pièce jointe supprimée avec succès',
    'tada_update_alert' => 'Vous ne pouvez pas mettre à jour les détails une fois vérifiés, veuillez contacter l’administrateur',
    'tada_notification' => ':name a soumis un nouveau TADA pour :title',
    'tada_detail_notification' => ':name a mis à jour les détails du TADA soumis pour :title',
    'tada_alert' => 'Alerte TADA',

    /** TaskDetailApi Controller */
    'status_changed_successfully' => 'Statut changé avec succès',
    'task_detail_not_found' => 'Détails de la tâche non trouvés',

    /** TaskCheckListApi Controller */
    'status_updated_successfully' => 'Statut mis à jour avec succès',

    /** TaskCommentApi Controller */
    'comment_notification' => 'Notification de commentaire',
    'task_mention' => 'Vous êtes mentionné dans la tâche :task :type',
    'comment_reply' => 'Réponse au commentaire',
    'comment_reply_deleted_successfully' => 'Réponse au commentaire supprimée avec succès',
    'comment_deleted_successfully' => 'Commentaire supprimé avec succès',
    'comment_added_successfully' => 'Commentaire ajouté avec succès',

    /** userProfile Api */
    'invalid_base64_image' => 'La valeur Base64 n’est pas une image valide',
    'demo_version' => 'Ceci est une version de démonstration. Veuillez acheter l’application pour utiliser toutes les fonctionnalités',
    'user_not_found' => 'Détails de l’utilisateur non trouvés',
    'profile_updated' => 'Profil mis à jour avec succès',
    'incorrect_current_password' => 'Mot de passe actuel incorrect',
    'new_password_same_as_old' => 'Le nouveau mot de passe ne peut pas être le même que l’ancien mot de passe',
    'password_changed' => 'Mot de passe changé avec succès',

];
