<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Authentication Language Lines
    |--------------------------------------------------------------------------
    |
    | The following language lines are used during authentication for various
    | messages that we need to display to the user. You are free to modify
    | these language lines according to your application's requirements.
    |
    */

    /** dashboard */
    'welcome' => 'उपस्थिति ड्यासबोर्डमा स्वागत छ',
    'total_employees' => 'कुल कर्मचारी',
    'total_departments' => 'कुल विभाग',
    'total_holidays' => 'कुल बिदाहरू',
    'paid_leaves' => 'भुक्तान गरिएको बिदाहरू',
    'on_leave_today' => 'आज बिदामा',
    'pending_leave_requests' => 'पेन्डिङ बिदा अनुरोधहरू',
    'total_check_in_today' => 'आजको कुल चेक इन',
    'total_check_out_today' => 'आजको कुल चेक आउट',
    'projects_detail' => 'प्रोजेक्टहरू विवरण',
    'total_projects' => 'कुल प्रोजेक्टहरू',
    'pending_projects' => 'पेन्डिङ प्रोजेक्टहरू',
    'on_hold_projects' => 'होल्डमा रहेका प्रोजेक्टहरू',
    'in_progress_projects' => 'प्रगतिमा रहेका प्रोजेक्टहरू',
    'finished_projects' => 'समाप्त भएका प्रोजेक्टहरू',
    'cancelled_projects' => 'रद्द गरिएका प्रोजेक्टहरू',
    'top_clients' => 'शीर्ष ग्राहकहरू',
    'task_details' => 'कार्य विवरण',
    'recent_projects' => 'हालका प्रोजेक्टहरू',
    'title' => 'शीर्षक',
    'date_start' => 'सुरु मिति',
    'deadline' => 'अन्तिम मिति',
    'leader' => 'नेता',
    'completion' => 'समाप्ति',
    'priority' => 'प्राथमिकता',
    'check_in_at' => 'चेक इन समय',
    'check_out_at' => 'चेक आउट समय',
    'punch_in' => 'पंच इन गर्नुहोस्',
    'punch_out' => 'पंच आउट गर्नुहोस्',
    'no_records_found' => 'कुनै रेकर्ड फेला परेन!',
    'view_all_clients' => 'सबै ग्राहकहरू हेर्नुहोस्',
    'view_all_projects' => 'सबै प्रोजेक्टहरू हेर्नुहोस्',
    'error_message' => 'त्रुटि: अनुरोध प्रक्रियामा राख्न सकिएन।',
    'success_message' => 'सफलता: कार्य सफलतापूर्वक पूरा भयो।',
    'name' => 'नाम',
    'email' => 'इमेल',
    'contact' => 'सम्पर्क',
    'project' => 'परियोजना',
    'pending' => 'विचाराधीन',
    'on_hold' => 'पर्खाइमा',
    'in_progress' => 'प्रगतिमा',
    'completed' => 'पूरा भयो',
    'cancelled' => 'रद्द भयो',
    'search_menu' => 'मेनु खोज गर्नुहोस्',

    /** nav */
    'latest_notifications' => 'नवीनतम सूचनाहरू',
    'view_all' => 'सबै हेर्नुहोस्',
    'profile' => 'प्रोफाइल',
    'edit_profile' => 'प्रोफाइल सम्पादन गर्नुहोस्',
    'request_leave' => 'बिदा अनुरोध गर्नुहोस्',
    'log_out' => 'लॉग आउट',
    'light_mode' => 'लाइट मोड',
    'dark_mode' => 'डार्क मोड',

    /** menu */
    'dashboard' => 'ड्यासबोर्ड',
    'company_management' => 'कम्पनी प्रबन्ध',
    'company' => 'कम्पनी',
    'branch' => 'शाखा',
    'department' => 'विभाग',
    'post' => 'पोष्ट',
    'employee_management' => 'कर्मचारी प्रबन्ध',
    'employees' => 'कर्मचारीहरू',
    'logout_requests' => 'लगआउट अनुरोध',
    'attendance_section' => 'उपस्थिति खण्ड',
    'clients' => 'ग्राहकहरू',
    'project_management' => 'परियोजना प्रबन्धन',
    'task_management' => 'काम प्रबन्धन',
    'holidays' => 'बिदा',
    'notice' => 'सूचना',
    'payroll_management' => 'पेरोल प्रबन्धन',
    'payroll' => 'पेरोल',
    'payroll_setting' => 'पेरोल सेटिङ',
    'advance_salary' => 'अग्रिम तलब',
    'employee_salary' => 'कर्मचारी तलब',
    'leave' => 'छुट्टी',
    'team_meeting' => 'संचार समिति',
    'tada' => 'ताडा',
    'shift_management' => 'पारिश्रमिक प्रबन्धन',
    'office_time' => 'कार्यालय समय',
    'award_management' => 'पुरस्कार प्रबन्धन',
    'award_types' => 'पुरस्कार प्रकारहरू',
    'awards' => 'पुरस्कारहरू',
    'asset_management' => 'सम्पत्ति प्रबन्धन',
    'asset_types' => 'सम्पत्ति प्रकारहरू',
    'assets' => 'सम्पत्तिहरू',
    'content_management' => 'सामग्री प्रबन्धन',
    'support' => 'समर्थन',
    'attendance_methods' => 'उपस्थिति विधिहरू',
    'routers' => 'राउटरहरू',
    'qr' => 'क्यूआर कोड',
    'nfc' => 'एनएफसी',
    'settings' => 'सेटिङहरू',
    'roles_permissions' => 'भूमिका र अनुमतिहरू',
    'general_settings' => 'सामान्य सेटिङहरू',
    'app_settings' => 'एप सेटिङहरू',
    'notifications' => 'सूचनाहरू',
    'payment_currency' => 'भुक्तान मुद्रा',
    'feature_control' => 'विशेषता नियन्त्रण',
    'salary_component' => 'तलब कम्पोनेन्ट',
    'salary_group' => 'तलब समूह',
    'salary_tds' => 'तलब कर',
    'overtime' => 'अधिक समय',
    'undertime' => 'कम समय',
    'payment_method' => 'भुक्तानी विधि',
    'leave_types' => 'बिदा प्रकार',
    'leave_request' => 'बिदा अनुरोध',
    'time_leave_request' => 'समय बिदा अनुरोध',

    /** company */
    'company_profile' => 'कम्पनी प्रोफाइल',
    'update_company' => 'कम्पनी अपडेट',
    'create_company' => 'कम्पनी बनाउनुहोस्',
    'company_name' => 'कम्पनीको नाम',
    'company_owner' => 'कम्पनीको मालिक',
    'address' => 'ठेगाना',
    'email_address' => 'ईमेल ठेगाना',
    'phone_no' => 'फोन नम्बर',
    'website_url' => 'वेबसाइट URL',
    'check_office_off_days' => 'कार्यालय बिरामी दिनहरू जाँच गर्नुहोस्',
    'upload_logo' => 'लोगो अपलोड गर्नुहोस्',
    'update' => 'अपडेट',
    'save' => 'सुरक्षित गर्नुहोस्',

    /** Branch */
    'title_branch' => 'शाखा',
    'branch_section' => 'शाखा अनुभाग',
    'branches' => 'शाखाहरू',
    'add_branch' => 'शाखा थप्नुहोस्',
    'branch_lists' => 'शाखा सूचीहरू',
    'search_by_branch_name' => 'शाखा नामद्वारा खोजी गर्नुहोस्',
    'filter' => 'फिल्टर',
    'reset' => 'पुन: सेट गर्नुहोस्',
    'phone' => 'फोन',
    'total_employee' => 'कुल कर्मचारी',
    'action' => 'कार्य',
    'are_you_sure_change_status' => 'के तपाईं निश्चय गर्न चाहानुहुन्छ कि तपाईं स्थिति परिवर्तन गर्न चाहनुहुन्छ?',
    'are_you_sure_delete_branch' => 'के तपाईं शाखा हटाउन चाहानुहुन्छ?',
    'branch_create' => 'शाखा बनाउनुहोस्',
    'branch_update' => 'शाखा अपडेट',
    'branch_name' => 'शाखा नाम',
    'required_field' => 'आवश्यक क्षेत्र',
    'branch_head' => 'शाखा प्रमुख',
    'select_branch_head' => 'शाखा प्रमुख छनौट गर्नुहोस्',
    'phone_number' => 'फोन नम्बर',
    'branch_location_latitude' => 'शाखा स्थान अक्षांश',
    'enter_branch_location_latitude' => 'शाखा स्थान अक्षांश राख्नुहोस्',
    'branch_location_longitude' => 'शाखा स्थान देशान्तर',
    'enter_branch_location_longitude' => 'शाखा स्थान देशान्तर राख्नुहोस्',
    'status' => 'स्थिति',
    'select_status' => 'स्थिति छनौट गर्नुहोस्',
    'active' => 'सक्रिय',
    'inactive' => 'निष्क्रिय',
    'create' => 'बनाउनुहोस्',

    /** Department */
    'department_section' => 'विभाग अनुभाग',
    'departments' => 'विभागहरू',
    'add_department' => 'विभाग थप्नुहोस्',
    'department_lists' => 'विभाग सूचीहरू',
    'search_by_department_name' => 'विभाग नामद्वारा खोजी गर्नुहोस्',
    'select_branch' => 'शाखा छनौट गर्नुहोस्',
    'edit' => 'सम्पादन गर्नुहोस्',
    'delete' => 'हटाउनुहोस्',
    'are_you_sure_delete_department' => 'के तपाईं विभाग हटाउन चाहानुहुन्छ?',
    'edit_department' => 'विभाग सम्पादन गर्नुहोस्',
    'button_back' => 'फर्किनुहोस्',
    'breadcrumb' => 'ब्रेडक्रम्ब',
    'update_department' => 'विभाग अपडेट',
    'create_department' => 'विभाग बनाउनुहोस्',
    'department_name' => 'विभाग नाम',
    'department_head' => 'विभाग प्रमुख',
    'select_department_head' => 'विभाग प्रमुख छनौट गर्नुहोस्',
    'create_update_department' => 'विभाग बनाउनुहोस्/अपडेट गर्नुहोस्',

    /** Post */
    'post_section' => 'पोस्ट अनुभाग',
    'posts' => 'पोस्टहरू',
    'add_post' => 'पोस्ट थप्नुहोस्',
    'search_by_department' => 'विभाग द्वारा खोजी गर्नुहोस्',
    'search_by_post_name' => 'पोस्ट नामद्वारा खोजी गर्नुहोस्',
    'post_name' => 'पोस्ट नाम',
    'post_empty' => 'पोस्ट खाली',
    'edit_post_title' => 'पोस्ट सम्पादन गर्नुहोस्',
    'create_post_title' => 'पोस्ट बनाउनुहोस्',
    'department_label' => 'विभाग',
    'post_name_label' => 'पोस्ट नाम',
    'status_label' => 'स्थिति',
    'select_department' => 'विभाग छनौट गर्नुहोस्',
    'active_option' => 'सक्रिय',
    'inactive_option' => 'निष्क्रिय',
    'update_update_button' => 'पोस्ट अपडेट',
    'change_status_confirmation' => 'के तपाईं निश्चय गर्न चाहानुहुन्छ कि तपाईं स्थिति परिवर्तन गर्न चाहनुहुन्छ?',
    'delete_post_confirmation' => 'के तपाईं पोस्ट हटाउन चाहानुहुन्छ?',
    'employee_list_title' => 'कर्मचारी सूची',

    /** Employee List */
    'employees_title' => 'कर्मचारीहरू',
    'employees_action' => 'सूचीहरू',
    'add_employee' => 'कर्मचारी थप्नुहोस्',
    'employee_section' => 'कर्मचारी अनुभाग',
    'employee_create' => 'कर्मचारी बनाउनुहोस्',
    'employee_name' => 'कर्मचारी नाम',
    'employee_email' => 'कर्मचारी ईमेल',
    'employee_phone' => 'कर्मचारी फोन नम्बर',
    'full_name' => 'पूरा नाम',
    'designation' => 'नियुक्ति',
    'role' => 'भूमिका',
    'shift' => 'पाली',
    'workplace' => 'कार्यस्थल',
    'is_active' => 'सक्रिय छ?',
    'edit_detail' => 'विवरण सम्पादन गर्नुहोस्',
    'delete_user' => 'प्रयोगकर्ता हटाउनुहोस्',
    'change_password' => 'पासवर्ड परिवर्तन गर्नुहोस्',
    'force_logout' => 'बलियो लगआउट',
    'all_fields_required' => 'सबै (<span style="color: red">*</span>) क्षेत्र आवश्यक छन्',
    'personal_detail' => 'व्यक्तिगत विवरण',
    'employee_code' => 'कर्मचारी कोड',
    'enter_name' => 'नाम प्रविष्ट गर्नुहोस्',
    'enter_employee_address' => 'कर्मचारीको ठेगाना प्रविष्ट गर्नुहोस्',
    'enter_email' => 'ईमेल प्रविष्ट गर्नुहोस्',
    'dob' => 'जन्म मिति',
    'gender' => 'लिंग',
    'select_gender' => 'लिंग चयन गर्नुहोस्',
    'marital_status' => 'वैवाहिक स्थिति',
    'choose_marital_status' => 'वैवाहिक स्थिति चयन गर्नुहोस्',
    'upload_avatar' => 'अवतार अपलोड गर्नुहोस्',
    'description' => 'विवरण',
    'username' => 'प्रयोगकर्ता नाम',
    'enter_username' => 'प्रयोगकर्ता नाम प्रविष्ट गर्नुहोस्',
    'password' => 'पासवर्ड',
    'enter_password' => 'पासवर्ड प्रविष्ट गर्नुहोस्',
    'select_role' => 'भूमिका चयन गर्नुहोस्',
    'company_detail' => 'कम्पनी विवरण',
    'supervisor' => 'पर्यवेक्षक',
    'employment_type' => 'रोजगार प्रकार',
    'select_employment_type' => 'रोजगार प्रकार चयन गर्नुहोस्',
    'joining_date' => 'सामेल हुने मिति',
    'enter_joining_date' => 'सामेल हुने मिति प्रविष्ट गर्नुहोस्',
    'workspace' => 'कार्यस्थल',
    'select_workspace' => 'कार्यस्थल चयन गर्नुहोस्',
    'field' => 'क्षेत्र',
    'office' => 'अफिस',
    'leave_detail' => 'छुट्टी विवरण',
    'leave_allocated' => 'छुट्टी आवंटित',
    'assigned_leaves' => 'आवंटित छुट्टिहरू',
    'no_of_days' => 'दिनहरूको संख्या',
    'total_leave_days' => 'कुल छुट्टीका दिन',
    'bank_detail' => 'बैंक विवरण',
    'bank_name' => 'बैंकको नाम',
    'bank_account_number' => 'बैंक खाता संख्या',
    'account_holder_name' => 'खाता धारकको नाम',
    'bank_account_type' => 'बैंक खाता प्रकार',
    'select_account_type' => 'खाता प्रकार चयन गर्नुहोस्',
    'create_user' => 'प्रयोगकर्ता बनाउनुहोस्',
    'update_user' => 'प्रयोगकर्ता अद्यावधिक गर्नुहोस्',
    'new_password' => 'नयाँ पासवर्ड',
    'enter_new_password' => 'नयाँ पासवर्ड प्रविष्ट गर्नुहोस्',
    'confirm_password' => 'पासवर्ड पुष्टि गर्नुहोस्',
    'confirm_password_placeholder' => 'पासवर्ड पुष्टि गर्नुहोस्',
    'submit' => 'प्रस्तुत गर्नुहोस्',
    'user_change_password' => 'प्रयोगकर्ता पासवर्ड परिवर्तन गर्नुहोस्',
    'confirm_delete_employee' => 'के तपाईँ पक्का हुनुहुन्छ कर्मचारी मेटाउन चाहनुहुन्छ?',
    'confirm_force_logout' => 'के तपाईँ पक्का हुनुहुन्छ प्रयोगकर्ता जबरजस्ती लगआउट गर्न चाहनुहुन्छ?',
    'confirm_change_workplace' => 'के तपाईँ पक्का हुनुहुन्छ कार्यस्थल परिवर्तन गर्न चाहनुहुन्छ?',
    'select_supervisor' => 'पर्यवेक्षक चयन गर्नुहोस्',
    'select_office_time' => 'अफिस समय चयन गर्नुहोस्',
    'select_option' => 'विकल्प चयन गर्नुहोस्',
    'not_available' => 'उपलब्ध छैन',

    /** logout requests */
    'logout_request_status' => 'लगआउट अनुरोध स्थिति',
    'take_action' => 'कार्य गर्नुहोस्',
    'confirm_accept_logout_request' => 'के तपाईँ पक्का हुनुहुन्छ लगआउट अनुरोध स्वीकार गर्न चाहनुहुन्छ?',

    /** attendance */
    'attendance' => 'उपस्थिति',
    'employee_attendance_lists' => 'कर्मचारी उपस्थिति सूचिहरू',
    'attendance_of_the_day' => 'दिनको उपस्थिति',
    'date_placeholder_bs' => 'वर्ष/महिना/दिन',
    'csv_export' => 'CSV निर्यात',
    'attendance_status' => 'उपस्थिति स्थिति',
    'attendance_by' => 'द्वारा उपस्थिति',
    'show_detail' => 'विवरण देखाउनुहोस्',
    'show_checkin_location' => 'चेक-इन स्थान देखाउनुहोस्',
    'show_checkout_location' => 'चेक-आउट स्थान देखाउनुहोस्',
    'checkin' => 'चेक-इन',
    'checkout' => 'चेक-आउट',
    'approved' => 'स्वीकृत',
    'rejected' => 'अस्वीकृत',
    'self' => 'आफै',
    'admin' => 'प्रशासक',
    'edit_attendance_time' => 'उपस्थिति समय सम्पादन गर्नुहोस्',
    'employee_attendance_detail' => 'कर्मचारी उपस्थिति विवरण',
    'attendance_of' => 'को उपस्थिति',
    'total_days_in_month' => 'महिनामा कुल दिन',
    'present_days' => 'उपस्थित दिनहरू',
    'absent_days' => 'अनुपस्थित दिनहरू',
    'weekend_days' => 'सप्ताहन्तका दिनहरू',
    'holiday_days' => 'बिदाका दिनहरू',
    'leave_days' => 'छुट्टीका दिनहरू',
    'working_hours' => 'कार्य घण्टा',
    'worked_hours' => 'काम गरिएका घण्टा',
    'attendance_details_of' => 'को उपस्थिति विवरण',
    'all_month' => 'सबै महिना',
    'worked_hour' => 'काम गरिएका घण्टा',
    'add_attendance_time' => 'उपस्थिति समय थप्नुहोस्',
    'confirm_change_attendance_status' => 'के तपाईँ पक्का हुनुहुन्छ उपस्थिति स्थिति परिवर्तन गर्न चाहनुहुन्छ?',
    'check_in' => 'चेक इन',
    'check_out' => 'चेक आउट',
    'attendance_title' => 'उपस्थिति',
    'attendance_action' => 'कर्मचारी उपस्थिति विवरण',
    'filter_placeholder' => 'उपस्थिति वर्ष उदाहरण: :min_year',
    'filter_button' => 'फिल्टर',
    'csv_export_button' => 'CSV निर्यात',
    'reset_button' => 'रीसेट',
    'total_days' => 'महिनामा कुल दिन',
    'attendance_details' => 'को उपस्थिति विवरण :monthName',
    'date' => 'मिति',
    'change_attendance_status' => 'उपस्थिति स्थिति परिवर्तन गर्नुहोस्',
    'create_attendance' => 'उपस्थिति सिर्जना गर्नुहोस्',
    'admin_remark' => 'प्रशासक टिप्पणी',
    'edit_attendance' => 'उपस्थिति सम्पादन गर्नुहोस्',
    'admin_edit_remark' => 'प्रशासक सम्पादित टिप्पणी',
    'confirm_check_in' => 'के तपाईँ पक्का हुनुहुन्छ कर्मचारीलाई चेक-इन गर्न चाहनुहुन्छ?',
    'confirm_check_out' => 'के तपाईँ पक्का हुनुहुन्छ कर्मचारीलाई चेक-आउट गर्न चाहनुहुन्छ?',
    'edit_attendance_title' => 'उपस्थिति सम्पादन गर्नुहोस्(:name) :date को समय',
    'create_attendance_title' => 'उपस्थिति सिर्जना गर्नुहोस्(:name) :date को समय',
    'total_worked_hours' => 'कुल काम गरिएका घण्टा',
    'attendance_report' => 'उपस्थिति रिपोर्ट',

    /** clients */
    'client_listing' => 'ग्राहक सूची',
    'add_client' => 'ग्राहक थप्नुहोस्',
    'client_name' => 'ग्राहकको नाम',
    'client_email' => 'ग्राहक इमेल',
    'edit_client_detail' => 'ग्राहक विवरण सम्पादन गर्नुहोस्',
    'show_client_detail' => 'ग्राहक विवरण देखाउनुहोस्',
    'delete_client_detail' => 'ग्राहक विवरण हटाउनुहोस्',
    'client_invoices' => 'ग्राहक चलानहरू',
    'client_detail' => 'ग्राहक विवरण:',
    'client_project_lists' => 'ग्राहक परियोजना सूचीहरू:',
    'country' => 'देश',
    'edit_client' => 'ग्राहक सम्पादन गर्नुहोस्',
    'create_client' => 'ग्राहक सिर्जना गर्नुहोस्',
    'client_section' => 'ग्राहक खण्ड',
    'client_contact' => 'ग्राहक सम्पर्क',
    'client_address' => 'ठेगाना',
    'client_country' => 'देश',
    'upload_profile' => 'ग्राहक प्रोफाइल अपलोड गर्नुहोस्',
    'enter_client_name' => 'ग्राहकको नाम लेख्नुहोस्',
    'enter_client_email' => 'ग्राहक इमेल लेख्नुहोस्',
    'enter_contact_number' => 'सम्पर्क नम्बर लेख्नुहोस्',
    'enter_client_address' => 'ग्राहक ठेगाना लेख्नुहोस्',
    'enter_country' => 'देश लेख्नुहोस्',
    'confirm_status_change' => 'तपाईं निश्चित हुनुहुन्छ कि तपाईं स्थिति परिवर्तन गर्न चाहानुहुन्छ?',
    'confirm_delete_client' => 'तपाईं निश्चित हुनुहुन्छ कि तपाईं ग्राहक विवरण हटाउन चाहानुहुन्छ?',

    /** Project Management */
    'lists' => 'सूचीहरू',
    'create_project' => 'परियोजना सिर्जना गर्नुहोस्',
    'back' => 'फिर्ता',
    'project_filter' => 'परियोजना फिल्टर',
    'search_by_project' => 'परियोजनाद्वारा खोज्नुहोस्',
    'search_by_status' => 'स्थितिद्वारा खोज्नुहोस्',
    'search_by_priority' => 'प्राथमिकताद्वारा खोज्नुहोस्',
    'client' => 'ग्राहक',
    'all_tasks' => 'सबै कार्यहरू',
    'completed_tasks' => 'पूरा भएको कार्यहरू',
    'days_left' => 'दिनहरू बाँकी',
    'team_member' => 'टोली सदस्य',
    'start_date' => 'सुरुको मिति',
    'due_date' => 'समाप्ति मिति',
    'view' => 'हेर्नुहोस्',
    'projects' => 'परियोजनाहरू',
    'assign_employee' => 'कर्मचारी असाइन गर्नुहोस्',
    'add' => 'थप्नुहोस्',
    'client_contact_number' => 'ग्राहक सम्पर्क नम्बर',
    'upload_client_profile' => 'ग्राहक प्रोफाइल अपलोड गर्नुहोस्',
    'project_name' => 'प्रोजेक्ट नाम',
    'project_start_date' => 'प्रोजेक्ट सुरु मिति',
    'project_deadline' => 'प्रोजेक्ट अन्तिम मिति',
    'project_status' => 'प्रोजेक्ट स्थिति',
    'select_project_status' => 'प्रोजेक्ट स्थिति छान्नुहोस्',
    'project_cost' => 'प्रोजेक्ट लागत',
    'select_priority' => 'प्राथमिकता छान्नुहोस्',
    'estimated_hours' => 'अनुमानित घण्टा',
    'select_client' => 'ग्राहक छान्नुहोस्',
    'upload_project_logo' => 'प्रोजेक्ट लोगो अपलोड गर्नुहोस्',
    'uploaded_files_images' => 'अपलोड गरिएको फाइलहरू र छविहरू',
    'no_project_file_uploaded' => 'कुनै प्रोजेक्ट फाइल अपलोड गरिएको छैन',
    'update_project' => 'प्रोजेक्ट अद्यावधिक गर्नुहोस्',
    'project_leader' => 'प्रोजेक्ट नेता',
    'assign_member' => 'सदस्य नियुक्त गर्नुहोस्',
    'edit_project' => 'प्रोजेक्ट सम्पादन गर्नुहोस्',
    'project_document' => 'परियोजना कागजात',
    'upload_documents' => 'कागजातहरू अपलोड गर्नुहोस्',
    'upload_project_attachments' => 'परियोजना संलग्नहरू अपलोड गर्नुहोस्',
    'show_project_detail' => 'परियोजना विवरण देखाउनुहोस्',
    'upload_attachments' => 'संलग्नहरू अपलोड गर्नुहोस्',
    'project_attachments' => 'परियोजना संलग्नहरू',
    'uploaded_image_files' => 'अपलोड गरिएका चित्र फाइलहरू',
    'no_project_image_found' => 'कुनै परियोजना चित्र फेला परेन',
    'uploaded_files' => 'अपलोड गरिएका फाइलहरू',
    'no_project_files_found' => 'कुनै परियोजना फाइलहरू फेला परेनन्',
    'project_tasks_lists' => 'परियोजना कार्य सूचीहरू',
    'project_summary' => 'परियोजना सारांश',
    'cost' => 'लागत:',
    'total_hours' => 'कुल घण्टा:',
    'created' => 'सिर्जना गरिएको:',
    'remaining_days' => 'बाँकी दिनहरू:',
    'project_leaders' => 'परियोजना नेताहरू',
    'update_leader' => 'नेता अपडेट गर्नुहोस्',
    'project_members' => 'परियोजना सदस्यहरू',
    'update_member' => 'सदस्य अपडेट गर्नुहोस्',
    'project_client_detail' => 'परियोजना ग्राहक विवरण',
    'delete_project_detail' => 'के तपाईं परियोजना विवरण मेटाउन चाहनुहुन्छ?',
    'delete_project_document' => 'के तपाईं परियोजना निवेदन मेटाउन चाहनुहुन्छ?',
    'search_by_member' => 'सदस्य द्वारा खोजी',
    'add_employee_to_project' => 'परियोजनामा कर्मचारी थप्नुहोस्',

    /** Task Management */
    'tasks' => 'कार्यहरू',
    'task_filter' => 'कार्य फिल्टर',
    'search_by_task_name' => 'कार्य नामद्वारा खोज्नुहोस्',
    'not_started' => 'सुरु भएको छैन',
    'create_tasks' => 'कार्यहरू सिर्जना गर्नुहोस्',
    'end_date' => 'अन्तिम मिति',
    'task_name' => 'कार्य नाम',
    'enter_task_name' => 'कार्य नाम प्रविष्ट गर्नुहोस्',
    'select_project' => 'परियोजना छान्नुहोस्',
    'task_start_date' => 'कार्य सुरु मिति',
    'task_start_time' => 'कार्य सुरु समय',
    'task_end_date' => 'कार्य समाप्ति मिति',
    'task_end_time' => 'कार्य समाप्ति समय',
    'task_status' => 'कार्य स्थिति',
    'select_task_status' => 'कार्य स्थिति छान्नुहोस्',
    'uploaded_files_and_images' => 'अपलोड गरिएका फाइलहरू र छविहरू',
    'task_attachments' => 'कार्य संलग्नहरू',
    'update_task' => 'कार्य अपडेट गर्नुहोस्',
    'create_task' => 'कार्य सिर्जना गर्नुहोस्',
    'mention' => 'उल्लेख',
    'comment' => 'टिप्पणी',
    'close' => 'बन्द गर्नुहोस्',
    'write_comment' => 'टिप्पणी लेख्नुहोस्',
    'reply' => 'जवाफ दिनुहोस्',
    'delete_confirm' => 'के तपाईं निश्चित रूपमा :title मेटाउन चाहनुहुन्छ ?',
    'task_member_placeholder' => 'कार्यमा सदस्य तोक्नुहोस्',
    'project_placeholder' => 'परियोजना छान्नुहोस्',
    'project_filter_placeholder' => 'परियोजना अनुसार खोज्नुहोस्',
    'task_name_placeholder' => 'कार्य नाम अनुसार खोज्नुहोस्',
    'change_task_status_confirm' => 'के तपाईं निश्चित रूपमा कार्यको सक्रिय स्थिति परिवर्तन गर्न चाहनुहुन्छ?',
    'change_status_confirm' => 'के तपाईं निश्चित रूपमा स्थिति परिवर्तन गर्न चाहनुहुन्छ?',
    'delete_task_detail_confirm' => 'के तपाईं निश्चित रूपमा कार्य विवरण मेटाउन चाहनुहुन्छ?',
    'create_checklist_text' => 'जाँचसूची सिर्जना गर्नुहोस्',
    'close_checklist_text' => 'बन्द गर्नुहोस्',
    'remove_checklist_text' => 'हटाउनुहोस्',
    'remove_checklist_title' => 'जाँचसूची हटाउनुहोस्',
    'view_all_comments' => 'सबै टिप्पणीहरू हेर्नुहोस्',
    'comments' => 'टिप्पणीहरू',
    'edit_task' => 'कार्य सम्पादन गर्नुहोस्',
    'edit_task_detail' => 'कार्य विवरण सम्पादन गर्नुहोस्',
    'show_task_detail' => 'कार्य विवरण देखाउनुहोस्',
    'task_edit' => 'कार्य सम्पादन',
    'create_checklist' => 'जाँचसूची सिर्जना गर्नुहोस्',
    'upload_attachment' => 'संलग्नक अपलोड गर्नुहोस्',
    'total_checklist' => 'कुल जाँचसूची',
    'completed_checklist' => 'पूरा गरिएको जाँचसूची',
    'task_checklist_lists' => 'कार्य जाँचसूची सूचीहरू',
    'assigned_to' => 'लाई तोकिएको',
    'create_task_checklist' => 'कार्य जाँचसूची सिर्जना गर्नुहोस्',
    'enter_checklist_title' => 'जाँचसूची शीर्षक प्रविष्ट गर्नुहोस्',
    'select_member' => 'सदस्य छान्नुहोस्',
    'add_more_checklist' => 'थप जाँचसूची थप्नुहोस्',
    'image' => 'तस्वीर',
    'file' => 'फाइल',
    'edit_checklist' => 'जाँचसूची सम्पादन गर्नुहोस्',
    'delete_checklist' => 'जाँचसूची मेटाउनुहोस्',
    'checklist' => 'जाँचसूची',
    'edit_task_checklist' => 'कार्य जाँचसूची सम्पादन गर्नुहोस्',
    'checklist_name' => 'जाँचसूची नाम',
    'assign_task_checklist' => 'कार्य जाँचसूची तोक्नुहोस्',
    'task_summary' => 'कार्य सारांश',
    'task_members' => 'कार्य सदस्यहरू',
    'task_attachment_title' => 'कार्य अनुलग्नक',
    'upload_attachment_action' => 'अनुलग्नक अपलोड गर्नुहोस्',
    'upload_task_attachments' => 'कार्य अनुलग्नकहरू अपलोड गर्नुहोस्',
    'upload_task_attachments_text' => 'कार्य अनुलग्नकहरू अपलोड गर्नुहोस्',
    'choose_file_text' => 'फाइल छान्नुहोस्',

    /** Holiday */
    'holiday_section' => 'छुट्टी सेक्शन',
    'event' => 'घटना',
    'event_date' => 'घटना मिति',
    'is_public_holiday' => 'सार्वजनिक छुट्टी हो?',
    'confirm_delete_holiday' => 'के तपाईं निश्चय गर्नुहुन्छ कि तपाईं छुट्टी विवरण हटाउन चाहनुहुन्छ?',
    'holiday_detail_title' => 'छुट्टी विवरण',
    'holiday' => 'छुट्टी',
    'csv_import' => 'CSV आयात',
    'import' => 'आयात',
    'holiday_detail_csv' => 'छुट्टी विवरण CSV',
    'holiday_csv_example' => 'छुट्टी CSV उदाहरण',
    'add_holiday' => 'छुट्टी थप्नुहोस्',
    'import_holiday_csv' => 'छुट्टी CSV आयात गर्नुहोस्',
    'holiday_filter' => 'छुट्टी फिल्टर',
    'event_name' => 'घटना नाम',
    'leave_requested_year' => 'वर्षको छुट्टी अनुरोध',
    'holiday_detail' => 'छुट्टी विवरण',

    /** notice */
    'notices_section' => 'सूचना अनुभाग',
    'notice_title' => 'सूचना शीर्षक',
    'notice_description' => 'सूचना विवरण',
    'notice_receiver' => 'सूचना प्राप्तकर्ता',
    'send_notice' => 'सूचना पठाउनुहोस्',
    'all_employees' => 'सबै कर्मचारीहरू',
    'create_notice' => 'सूचना सिर्जना गर्नुहोस्',
    'edit_notice' => 'सूचना सम्पादन गर्नुहोस्',
    'notices' => 'सूचनाहरू',
    'receiver' => 'प्राप्तकर्ता',
    'published_from' => 'यहाँबाट प्रकाशित',
    'publish_to' => 'सम्म प्रकाशित',
    'publish_date' => 'प्रकाशन मिति',
    'show_notice_content' => 'सूचना सामग्री देखाउनुहोस्',
    'delete_notice_detail' => 'सूचना विवरण हटाउनुहोस्',
    'notice_lists' => 'सूचना सूचीहरू',
    'confirm_change_notice_status' => 'के तपाईं सुनावटको स्थिति परिवर्तन गर्न निश्चित हुनुहुन्छ?',
    'confirm_delete_notice' => 'के तपाईं सूचना हटाउन चाहनुहुन्छ?',
    'confirm_send_notice' => 'के तपाईं सूचना पठाउन चाहनुहुन्छ?',
    'notice_detail_modal_title' => 'सूचना :title विवरण',

    /** payroll */
    'employee_payroll'=>'कर्मचारी तलब',
    'payroll_generate'=>'तलब उत्पन्न गर्नुहोस्',
    'payroll_create'=>'तलब सिर्जना गर्नुहोस्',
    'payroll_edit'=>'तलब सम्पादन गर्नुहोस्',
    'select_year' => 'वर्ष चयन गर्नुहोस्',
    'salary_cycle' => 'तलब चक्र',
    'salary_month' => 'तलब महिना',
    'salary_week' => 'तलब हप्ता',
    'select_week' => 'हप्ता चयन गर्नुहोस्',
    'include_tada' => 'TADA समावेश गर्नुहोस्',
    'include_advance_salary' => 'अग्रिम तलब समावेश गर्नुहोस्',
    'use_attendance' => 'उपस्थिति प्रयोग गर्नुहोस्',
    'generate' => 'उत्पन्न गर्नुहोस्',
    'clear' => 'खाली गर्नुहोस्',
    'report' => 'रिपोर्ट:',
    'duration' => 'अवधि',
    'payroll_summary' => 'तलब सारांश',
    'total_basic_salary' => 'कुल आधारभूत तलब:',
    'total_net_salary' => 'कुल शुद्ध तलब:',
    'total_allowance' => 'कुल भत्ता:',
    'total_deduction' => 'कुल कटौती:',
    'total_overtime' => 'कुल अतिरिक्त समय:',
    'total_undertime' => 'कुल कम समय:',
    'paid_by'=>'द्वारा तिरेको',
    'net_salary'=>'शुद्ध तलब',
    'paid_on'=>'तलब तिरेको मिति',
    'pay_button' => 'तलब तिर्नुहोस्',
    'select_payment_method.'=>'कृपया तलब विधि चयन गर्नुहोस्।',
    'confirm_delete_payroll'=>'के तपाईं पक्का कर्मचारीको तलब मेटाउन चाहनुहुन्छ?',
    'confirm_generate_payroll'=>'के तपाईं पक्का तलब उत्पन्न गर्न चाहनुहुन्छ?',
    'confirm_change_cycle'=>'के तपाईं पक्का तलब चक्र परिवर्तन गर्न चाहनुहुन्छ?',
    'payment_title' => 'भुक्तानी गर्नुहोस्',
    'payment_method_placeholder' => 'तलब विधि चयन गर्नुहोस्',
    'payment_date' => 'भुक्तानी मिति',
    'hourly_rate' => 'प्रति घण्टा दर',
    'hourly' => 'प्रति घण्टा',
    'working_hours_in_week' => 'हप्तामा काम गर्ने घण्टा',
    'annual_salary' => 'वार्षिक तलब (CTC)',
    'annual' => 'वार्षिक',
    'basic_salary' => 'आधारभूत तलब',
    'fixed_allowance' => 'नियत भत्ता',
    'total' => 'कुल',
    'net_total' => 'शुद्ध कुल',
    'earnings' => 'कमाई',
    'deductions' => 'कटौती',
    'create_salary '=>'तलब सिर्जना गर्नुहोस्',
    'edit_salary '=>'तलब सम्पादन गर्नुहोस्',
    'add_salary '=>'तलब थप्नुहोस्',
    'calculation_type'=>'गणना प्रकार',
    'monthly_amount'=>'मासिक रकम',
    'annual_amount'=>'वार्षिक रकम',
    'salary_slip' => 'तलब पर्ची',
    'edit_salary_slip' => 'तलब पर्ची सम्पादन गर्नुहोस्',
    'payslip' => 'तलब पर्ची',
    'for_the_month_of' => 'महिनाको लागि',
    'from'=>'देखि',
    'to'=>'सम्म',
    'employee_id'=>'कर्मचारी ID',
    'earning' => 'कमाई',
    'deduction' => 'कटौती',
    'actual_salary' => 'वास्तविक तलब',
    'total_earning'=>'कुल कमाई',
    'actual_salary_formula' => '(कुल कमाई - कुल कटौती)',
    'bonus' => 'बोनस',
    'taxable_salary' => 'कर योग्य तलब',
    'taxable_salary_formula' => '(वास्तविक तलब + बोनस)',
    'tax' => 'कर',
    'salary_after_tax' => 'कर पछि तलब',
    'expenses_claim' => 'खर्च दाबी (TADA)',
    'absent' => 'अनुपस्थित',
    'absent_deduction_formula' => '((कुल तलब / कुल दिन) * अनुपस्थित दिन)',
    'net_salary_formula' => 'शुद्ध तलब = (वास्तविक तलब - अग्रिम तलब + TADA)',
    'monthly' => 'मासिक',
    'weekly' => 'साप्ताहिक',
    'salary_increment' => 'तलब वृद्धि',
    'increment' => 'वृद्धि',
    'current_salary' => 'वर्तमान तलब',
    'annual_increment_percent' => 'वार्षिक वृद्धि %',
    'annual_increment_amount' => 'वार्षिक वृद्धि रकम',
    'revised_salary_label' => 'संशोधित तलब',
    'fiscal_year_label' => 'आर्थिक वर्षको लागि वृद्धि',
    'applicable_from_label' => 'लागू मिति (तारीख)',
    'applicable_to_label' => 'लागू मिति सम्म (तारीख)',
    'remark' => 'टिप्पणी',
    'fiscal_year' => 'आर्थिक वर्ष',
    'select_fiscal_year' => 'आर्थिक वर्ष चयन गर्नुहोस्',
    'list'=>'सूची',
    'employee_salary_filter'=>'कर्मचारी तलब फिल्टर',
    'salary_review_history'=>'तलब समीक्षा इतिहास',
    'increase_salary'=>'तलब वृद्धि',
    'all'=>'सबै',
    'employee_payslip'=>'कर्मचारी तलब पर्ची',
    'salary_from'=>'तलब देखि',
    'salary_to'=>'तलब सम्म',
    'unpaid_leave'=>'अवैतनिक बिदा',
    'paid_leave'=>'तलब बिदा',
    'employee_gross_salary'=>'कर्मचारी कुल तलब',
    'salary_increment_log'=>'तलब वृद्धि लग',
    'log'=>'लग',
    'salary_revised_on'=>'तलब संशोधन गरियो',
    'increment_by'=>'वृद्धि द्वारा',
    'increment_value'=>'वृद्धि मूल्य',
    'old_salary'=>'पुरानो तलब',
    'new_salary'=>'नयाँ तलब',
    'date_to'=>'मिति सम्म',
    'date_from'=>'मिति देखि',
    'salary_increment_remark'=>'तलब वृद्धि टिप्पणी',
    'advance_salary_requests'=>'अग्रिम तलब अनुरोध',
    'advance_salary_request_filter'=>'अग्रिम तलब अनुरोध फिल्टर',
    'delete_confirmation'=>'के तपाईं मेटाउन पक्का हुनुहुन्छ?',
    'payslip_for_the_month_of'=>'महिनाको लागि तलब पर्ची',
    'absent_deduction'=>'अनुपस्थिति कटौती',

    /** Advance Salary */
    'is_paid' => 'पैसा तिर्नुभएको छ?',
    'released_on' => 'जारी गरिएको मिति',
    'requested_on' => 'अनुरोध गरिएको मिति',
    'released_amount' => 'जारी गरिएको रकम',
    'requested_amount' => 'अनुरोध गरिएको रकम',
    'search_by_month' => 'महिना अनुसार खोज्नुहोस्',
    'search_by_employee_name' => 'कर्मचारीको नाम अनुसार खोज्नुहोस्',
    'advance_salary_detail' => 'अग्रिम वेतन विवरण',
    'is_settled' => 'सुल्झाइएको छ',
    'verified_by' => 'द्वारा प्रमाणित',
    'amount_released_date' => 'रकम जारी गरिएको मिति',
    'advance_requested_date' => 'अग्रिम अनुरोध गरिएको मिति',
    'total_released_amount' => 'कुल जारी गरिएको रकम',
    'total_request_amount' => 'कुल अनुरोध गरिएको रकम',
    'employee' => 'कर्मचारी',
    'select_employee' => 'कर्मचारी चयन गर्नुहोस्',
    'advance_salary_request_detail' => 'अग्रिम वेतन अनुरोध विवरण',
    'proof_of_advance_salary_payment' => 'अग्रिम वेतन भुक्तानीको प्रमाण',
    'attachments' => 'संलग्नकहरू',
    'processing' => 'प्रक्रिया हुँदैछ',

    /** Tax report */
    'tax_report' => 'कर रिपोर्ट',
    'employee_tax_report' => 'कर्मचारी कर रिपोर्ट',
    'tax_report_edit' => 'कर रिपोर्ट सम्पादन',
    'tax_report_detail_of' => 'कर रिपोर्टको विवरण',
    'tax_report_detail' => 'कर रिपोर्ट विवरण',
    'salary_sheet' => 'तलब पत्रक',
    'particular' => 'विशेषता',
    'income' => 'आय',
    'tax_data_not_available' => 'वर्तमान वैवाहिक स्थितिको लागि कर डेटा उपलब्ध छैन',
    'remain_tds_formula' => '(कुल देय TDS / बाँकी महिनाको संख्या)',
    'remaining_month' => 'बाँकी महिना',
    'tds_calculation_msg' => 'हालको महिनाको लागि TDS गणना (गणना महिना)',
    'total_due_tds' => 'कुल देय TDS',
    'total_paid_tds' => 'कुल तिर्नु भएको TDS',
    'total_payable_tds' => 'कुल तिर्नु पर्ने TDS',
    'other_discount' => 'अन्य छुट',
    'female_discount' => 'महिला छुट',
    'medical_claim' => 'चिकित्सा दावी',
    'less' => 'कम',
    'less_tax_deduction' => 'कम: कर कटौती',
    'tax_amount' => 'कर रकम',
    'percent' => 'प्रतिशत',
    'tax_calculation_on_taxable_income' => 'कर योग्य आयमा कर गणना',
    'taxable_income' => 'कर योग्य आय',
    'ssf_contribution' => 'SSF योगदान',
    'ssf_contribution_salary' => 'SSF योगदान वेतन',
    'total_retirement_contribution_allowed' => 'कुल रिटायरमेंट योगदान अनुमत',
    'total_income' => 'कुल आय',
    'amount' => 'राशि',
    'additional_information' => 'थप जानकारी',
    'total_payable' => 'कुल तिर्नु पर्ने',
    'tds_paid' => 'तिर्नु भएको TDS',
    'ssf_deduction' => 'SSF कटौती',
    'tax_report_generate' => 'कर रिपोर्ट सिर्जना गर्नुहोस्',
    'print' => 'प्रिन्ट',
    'gross_earnings' => 'सकल आम्दानी',
    'tax_payable' => 'कर तिर्ने',

    /** Payroll Setting  */
    'advance_salary_limit' => 'अग्रिम तलबको सीमा',
    'select_month' => 'माह चयन गर्नुहोस्',
    'applicable_month' => 'लागू हुने महिना',
    'value' => 'मान',
    'value_type' => 'मान प्रकार',
    'enter_bonus_type' => 'बोनस प्रकार प्रविष्ट गर्नुहोस्',
    'salary_components' => 'तलबका भागहरु',
    'add_bonus' => 'बोनस थप्नुहोस्',
    'max_daily_ot' => 'अधिकतम दैनिक ओभरटाइम',
    'assign_overtime_to_employee' => 'कर्मचारीलाई ओभरटाइम सुम्पनुहोस्',
    'overtime_pay_rate' => 'ओभरटाइम तलब दर (प्रति घण्टा)',
    'overtime_rate_percent' => 'ओभरटाइम दर प्रतिशत (प्रति घण्टा)',
    'placeholder_overtime_pay_rate' => 'ओभरटाइम तलब दर प्रविष्ट गर्नुहोस्',
    'placeholder_overtime_rate_percent' => 'ओभरटाइम दर प्रतिशत प्रविष्ट गर्नुहोस्',
    'rate_type' => 'दर प्रकार',
    'select_rate_type' => 'दर प्रकार चयन गर्नुहोस्',
    'ot_valid_after_hour' => 'ओभरटाइम मान्य पछि ? घण्टा',
    'placeholder_ot_valid_after_hour' => 'घण्टा प्रविष्ट गर्नुहोस् जस पछि ओभरटाइम मान्य छ',
    'monthly_ot' => 'अधिकतम मासिक ओभरटाइम',
    'placeholder_monthly_ot' => 'अधिकतम मासिक ओभरटाइम प्रविष्ट गर्नुहोस्',
    'weekly_ot' => 'अधिकतम साप्ताहिक ओभरटाइम',
    'placeholder_weekly_ot' => 'अधिकतम साप्ताहिक ओभरटाइम प्रविष्ट गर्नुहोस्',
    'daily_ot' => 'अधिकतम दैनिक ओभरटाइम',
    'placeholder_daily_ot' => 'अधिकतम दैनिक ओभरटाइम प्रविष्ट गर्नुहोस्',
    'pay_percent' => 'भुक्तानी प्रतिशत/दर',
    'employee_count' => 'कर्मचारी संख्या',
    'hour' => 'घण्टा',
    'currency_setting' => 'मुद्रा सेटिङ',
    'payroll_currency' => 'पेरोल मुद्रा',
    'choose_payroll_currency' => 'पेरोल मुद्रा चयन गर्नुहोस्',
    'add_payment_method' => 'भुक्तानी विधि थप्नुहोस्',
    'payment_method_name' => 'भुक्तानी विधिको नाम',
    'update_payment_method' => 'भुक्तानी विधि अद्यावधिक गर्नुहोस्',
    'component_value' => 'घटक मान',
    'component_type' => 'घटक प्रकार',
    'add_salary_component' => 'तलबको भाग थप्नुहोस्',
    'apply_for_all' => 'सबैका लागि लागू गर्नुहोस्',
    'component_value_annual' => 'घटक मान (वार्षिक)',
    'select_value_type' => 'मान प्रकार चयन गर्नुहोस्',
    'select_component_type' => 'घटक प्रकार चयन गर्नुहोस्',
    'enter_salary_component_name' => 'तलबको भागको नाम प्रविष्ट गर्नुहोस्',
    'add_salary_group' => 'तलब समूह थप्नुहोस्',
    'delete_confirm_salary_group' => 'तपाईं पक्का हुनुहुन्छ कि तपाइँ समूह विवरण मेटाउन चाहानुहुन्छ?',
    'assign_employee_to_group' => 'कर्मचारीलाई समूहमा नियुक्त गर्नुहोस्',
    'choose_salary_component' => 'तलबको भाग चयन गर्नुहोस्',
    'assign_salary_components' => 'तलबका भागहरु नियुक्त गर्नुहोस्',
    'enter_salary_group_name' => 'तलब समूहको नाम प्रविष्ट गर्नुहोस्',
    'add_more_tds_detail' => 'थप TDS विवरण थप्नुहोस्',
    'enter_tds_in_percent' => 'TDS प्रतिशतमा प्रविष्ट गर्नुहोस्',
    'enter_annual_salary_to' => 'वार्षिक तलबसम्म प्रविष्ट गर्नुहोस्',
    'enter_annual_salary_from' => 'वार्षिक तलबबाट प्रविष्ट गर्नुहोस्',
    'select_marital_status' => 'वैवाहिक स्थिति चयन गर्नुहोस्',
    'create_salary_tds' => 'तलब TDS सिर्जना गर्नुहोस्',
    'update_salary_tds' => 'तलब TDS अद्यावधिक गर्नुहोस्',
    'salary_tds_detail_for_single' => 'अविवाहितहरूको लागि तलब TDS विवरण',
    'add_salary_tds' => 'तलब TDS थप्नुहोस्',
    'annual_salary_to' => 'वार्षिक तलबसम्म',
    'annual_salary_from' => 'वार्षिक तलबबाट',
    'tds' => 'TDS (%)',
    'salary_tds_detail_for_married' => 'विवाहितहरूको लागि तलब TDS विवरण',
    'ssf' => 'SSF',
    'employee_contribution' => 'कर्मचारी योगदान',
    'office_contribution' => 'कार्यालय योगदान',
    'assign_undertime_to_employee' => 'कर्मचारीलाई कम समय सौंपनुहोस्',
    'enter_title' => 'शीर्षक प्रविष्ट गर्नुहोस्',
    'undertime_after_minute' => 'कम समय लागू भएपछि मिनेट',
    'placeholder_ut_after' => 'घण्टा प्रविष्ट गर्नुहोस् जस पछि कम समय लागू हुन्छ',
    'penalty_type' => 'दण्ड प्रकार',
    'select_penalty_type' => 'दण्ड प्रकार चयन गर्नुहोस्',
    'penalty_percent' => 'दण्ड प्रतिशत (प्रति घण्टा)',
    'penalty_percent_placeholder' => 'कम समयको लागि दण्ड प्रतिशत प्रविष्ट गर्नुहोस्',
    'penalty_rate' => 'दण्ड दर (प्रति घण्टा)',
    'penalty_rate_placeholder' => 'कम समयको लागि दण्ड दर प्रविष्ट गर्नुहोस्',

    /** Leave */
    'leave_type_section' => 'अवकाश प्रकार खण्ड',
    'select_leave_type' => 'अवकाश प्रकार चयन गर्नुहोस्',
    'leave_type' => 'अवकाश प्रकार',
    'leave_allocated_days' => 'अवकाश आवंटित दिनहरू',
    'allocated_days' => 'आवंटित दिनहरू',
    'is_paid_leave' => 'पेड अवकाश हो',
    'leave_type_name' => 'अवकाश प्रकारको नाम',
    'leave_type_placeholder' => 'अवकाश प्रकार प्रविष्ट गर्नुहोस्',
    'add_leave_type' => 'अवकाश प्रकार थप्नुहोस्',
    'type' => 'प्रकार',
    'edit_leave_type_detail' => 'अवकाश प्रकार विवरण सम्पादित गर्नुहोस्',
    'delete_leave_type' => 'अवकाश प्रकार मेटाउनुहोस्',
    'delete_leave_confirmation' => 'के तपाईलाई निश्चित छ कि तपाई अवकाश प्रकार मेटाउन चाहनुहुन्छ?',
    'leave_request_section' => 'अवकाश अनुरोध खण्ड',
    'approve' => 'स्वीकृत गर्नुहोस्',
    'reject' => 'अस्वीकृत गर्नुहोस्',
    'from_date' => 'मिति देखि',
    'to_date' => 'मिति सम्म',
    'start_time' => 'सुरुवात समय',
    'end_time' => 'अन्तिम समय',
    'reason' => 'कारण',
    'requested_for' => 'को लागि अनुरोध गरिएको',
    'requested_by' => 'द्वारा अनुरोध गरिएको',
    'requested_days' => 'अनुरोध गरिएका दिनहरू',
    'requested_date' => 'अनुरोधको मिति',
    'all_status' => 'सबै स्थिति',
    'all_leave_type' => 'सबै अवकाश प्रकार',
    'leave_request_filter' => 'अवकाश अनुरोध फिल्टर',
    'create_leave_request' => 'अवकाश अनुरोध सिर्जना गर्नुहोस्',
    'leave_reason' => 'अवकाशको कारण',
    'referred_by' => 'सन्दर्भित द्वारा',
    'leave_date' => 'अवकाश मिति',
    'time_leave_request_filter' => 'समय आधारित अवकाश अनुरोध फिल्टर',
    'create_time_leave_request' => 'समय आधारित अवकाश अनुरोध सिर्जना गर्नुहोस्',
    'time_leave_request_section' => 'समय आधारित अवकाश अनुरोध खण्ड',
    'time_leave_status_update' => 'समय आधारित अवकाश स्थिति अद्यतन',

    /** Team Meeting */
    'team_meeting_section' => 'टिम बैठक खण्ड',
    'update_and' => 'अद्यावधिक र',
    'create_and' => 'सिर्जना र',
    'send' => 'पठाउनुहोस्',
    'meeting_participator' => 'बैठक सहभागी',
    'image_hint' => 'तस्वीरलाई परिदृश्यको रूपमा राख्न सिफारिश गरिएको छ',
    'meeting_description' => 'बैठकको विवरण',
    'upload_image' => 'तस्वीर अपलोड गर्नुहोस्',
    'meeting_start_time' => 'बैठकको सुरु समय',
    'meeting_date' => 'बैठकको मिति',
    'meeting_venue' => 'बैठक स्थल',
    'enter_venue_name' => 'स्थलको नाम प्रविष्ट गर्नुहोस्',
    'enter_content_title' => 'सामग्रीको शीर्षक प्रविष्ट गर्नुहोस्',
    'meeting_title' => 'बैठकको शीर्षक',
    'delete_team_meeting_confirmation' => 'तपाईं निश्चित हुनुहुन्छ कि तपाईं टिम बैठक हटाउन चाहनुहुन्छ?',
    'image_delete_confirmation' => 'तपाईं निश्चित हुनुहुन्छ कि तपाईं तस्वीर हटाउन चाहनुहुन्छ?',
    'create_team_meeting' => 'टिम बैठक सिर्जना गर्नुहोस्',
    'delete_team_meeting' => 'टिम बैठकको विवरण हटाउनुहोस्',
    'edit_meeting_detail' => 'बैठकको विवरण सम्पादित गर्नुहोस्',
    'show_team_meeting' => 'टिम बैठकको सामग्री देखाउनुहोस्',
    'participators' => 'सहभागीहरू',
    'participator' => 'सहभागी',
    'team_meeting_filter' => 'टिम बैठकको फिल्टर',
    'agenda' => 'एजेण्डा',
    'creator' => 'स्रष्टा',

    /** Tada */
    'tada_attachment' => 'Tada संलग्नक',
    'upload_tada_attachment' => 'Tada संलग्नक अपलोड गर्नुहोस्',
    'accepted' => 'स्वीकृत',
    'tada_status_change' => 'तपाईं निश्चित हुनुहुन्छ कि तपाईं Tada सम्झौतासम्बन्धी स्थिति परिवर्तन गर्न चाहनुहुन्छ?',
    'delete_tada_confirm' => 'तपाईं निश्चित हुनुहुन्छ कि तपाईं :title मेटाउन चाहनुहुन्छ?',
    'uploaded_attachment' => 'अपलोड गरिएको संलग्नक',
    'no_attachment_file' => 'कोई संलग्नक फाइल छैन',
    'total_expense' => 'कुल खर्च',
    'create_tada' => 'Tada सिर्जना गर्नुहोस्',
    'edit_tada' => 'Tada सम्पादित गर्नुहोस्',
    'tada_listing' => 'Tada सूची',
    'tada_filter' => 'Tada फिल्टर',
    'submitted_date' => 'प्रस्तुत मिति',
    'expense' => 'खर्च',
    'tada_detail' => 'Tada विवरण',
    'verified_date' => 'सत्यापित मिति',
    'tada_summary' => 'Tada संक्षेप',
    'update_status' => 'स्थिति अपडेट गर्नुहोस्',
    'category' => 'वर्ग',
    'select_category' => 'वर्ग चयन गर्नुहोस्',
    'opening_time' => 'खुल्ने समय',
    'closing_time' => 'बन्द गर्ने समय',
    'checkin_checkout_rule' => 'चेक-इन/चेक-आउट नियम',
    'early_check_in' => 'अर्ली चेक-इन',
    'check_in_before' => 'चेक-इन गर्न अघि (मिनेटमा) सक्छ',
    'checkin_before' => 'चेक-इन अघि',
    'enter_check_in_before' => 'कति मिनेट अघि चेक-इन गर्न सकिन्छ प्रविष्ट गर्नुहोस्',
    'early_check_out' => 'अर्ली चेक-आउट',
    'check_out_before' => 'चेक-आउट गर्न अघि (मिनेटमा) सक्छ',
    'checkout_before' => 'चेक-आउट अघि',
    'enter_check_out_before' => 'कति मिनेट अघि चेक-आउट गर्न सकिन्छ प्रविष्ट गर्नुहोस्',
    'late_check_in' => 'लेट चेक-इन',
    'check_in_after' => 'चेक-इन पछि (मिनेटमा) सक्छ',
    'checkin_after' => 'चेक-इन पछि',
    'enter_check_in_after' => 'कति मिनेट पछि चेक-इन गर्न सकिन्छ प्रविष्ट गर्नुहोस्',
    'late_check_out' => 'लेट चेक-आउट',
    'checkout_after' => 'चेक-आउट पछि',
    'check_out_after' => 'चेक-आउट गर्न पछि (मिनेटमा) सक्छ',
    'enter_check_out_after' => 'कति मिनेट पछि चेक-आउट गर्न सकिन्छ प्रविष्ट गर्नुहोस्',
    'enter_shift_name' => 'शिफ्ट नाम प्रविष्ट गर्नुहोस्',
    'select_shift' => 'शिफ्ट चयन गर्नुहोस्',
    'delete_office_time_confirm' => 'तपाईं निश्चित हुनुहुन्छ कि तपाईं कार्यालय तालिका मेटाउन चाहनुहुन्छ?',
    'office_time_detail' => 'कार्यालय समय विवरण',
    'office_schedule' => 'कार्यालय तालिका',
    'add_office_time' => 'कार्यालय समय थप्नुहोस्',

    /** Award Types */
    'award_distributed' => 'पुरस्कार वितरण गरियो',
    'add_award_types' => 'पुरस्कार प्रकार थप्नुहोस्',
    'gift_item' => 'उपहार वस्तु',
    'awarded_date' => 'पुरस्कारको मिति',

    /** Award */
    'award' => 'पुरस्कार',
    'award_name' => 'पुरस्कारको नाम',
    'select_award_type' => 'पुरस्कार प्रकार चयन गर्नुहोस्',
    'enter_gift_item' => 'उपहार वस्तु प्रविष्ट गर्नुहोस्',
    'award_base' => 'पुरस्कार आधार',
    'select_award_base' => 'पुरस्कार आधार चयन गर्नुहोस्',
    'awarded_by' => 'द्वारा प्रदान गरिएको',
    'enter_awarded_by' => 'प्रदानकर्ता प्रविष्ट गर्नुहोस्',
    'award_description' => 'पुरस्कार विवरण',
    'gift_description' => 'उपहार विवरण',
    'reward_code' => 'इनाम कोड',
    'enter_reward_code' => 'इनाम कोड प्रविष्ट गर्नुहोस्',
    'add_award' => 'पुरस्कार थप्नुहोस्',
    'attachment' => 'संलग्नक',
    'award_lists' => 'पुरस्कार सूची',

    /** Asset Types */
    'add_asset_types' => 'संपत्ति प्रकार थप्नुहोस्',
    'asset_item_count' => 'संपत्ति वस्तु गणना',
    'asset_type' => 'संपत्ति प्रकार',
    'asset_name' => 'संपत्ति नाम',
    'purchased_date' => 'खरिद मिति',
    'is_working' => 'सञ्चालनमा छ',
    'is_available' => 'उपलब्ध छ',
    'asset' => 'संपत्ति',

    /** Assets */
    'select_asset_type' => 'संपत्ति प्रकार चयन गर्नुहोस्',
    'assigned_date' => 'आवंटित मिति',
    'is_available_for_employee' => 'कर्मचारीका लागि उपलब्ध छ',
    'select_availability' => 'उपलब्धता चयन गर्नुहोस्',
    'warranty_end_date' => 'वारेन्टी समाप्ति मिति',
    'warranty_available' => 'वारेन्टी उपलब्ध छ',
    'select_warranty_availability' => 'वारेन्टी उपलब्धता चयन गर्नुहोस्',
    'asset_serial_number' => 'संपत्ति सिरियल नम्बर',
    'enter_asset_serial_number' => 'संपत्ति सिरियल नम्बर प्रविष्ट गर्नुहोस्',
    'asset_code' => 'संपत्ति कोड',
    'enter_asset_code' => 'संपत्ति कोड प्रविष्ट गर्नुहोस्',
    'change_availability_status' => 'के तपाईलाई उपलब्धता स्थिति परिवर्तन गर्न पक्का छ?',
    'delete_asset_confirm' => 'के तपाईलाई :title हटाउन पक्का छ?',
    'add_asset' => 'संपत्ति थप्नुहोस्',
    'asset_image' => 'संपत्ति छवि',
    'asset_assigned_employee' => 'संपत्ति आवंटित कर्मचारी',
    'assets_filter' => 'संपत्ति छान्नुहोस्',
    'working_status' => 'सञ्चालन स्थिति',
    'availability_status' => 'उपलब्धता स्थिति',
    'yes_available' => 'हो, उपलब्ध छ',
    'notavailable' => 'उपलब्ध छैन',
    'purchased_from' => 'खरिद गरियो',
    'purchased_to' => 'खरिद गरियो',

    /** Content Management */
    'content_section' => 'सामग्री खण्ड',
    'content' => 'सामग्री',
    'content_type' => 'सामग्री प्रकार',
    'content_title' => 'सामग्री शीर्षक',
    'select_content_type' => 'सामग्री प्रकार चयन गर्नुहोस्',
    'delete_content_confirm' => 'के तपाईं निश्चित हुनुहुन्छ कि तपाईं स्थिर पृष्ठ सामग्री मेटाउन चाहानुहुन्छ?',
    'company_static_content' => 'कम्पनीको स्थिर सामग्री',
    'add_content' => 'सामग्री थप्नुहोस्',

    /** Support */
    'delete_support_confirm' => 'के तपाईं निश्चित हुनुहुन्छ कि तपाईं :title मेटाउन चाहानुहुन्छ?',
    'ticket_lists' => 'टिकट सूचियाँ',
    'query_by' => 'पूछताछ द्वारा',
    'concerned_department' => 'संबंधित विभाग',
    'unseen' => 'अदृश्य',
    'read_status' => 'पढ्ने स्थिति',
    'seen' => 'देखिएको',
    'query_status' => 'पूछताछ स्थिति',
    'support_filter' => 'सहायता छान्नुहोस्',
    'query_lists' => 'पूछताछ सूचीहरू',
    'department_support_requested_from' => 'विभागबाट अनुरोध गरिएको समर्थन',
    'department_support_requested_to' => 'विभागलाई अनुरोध गरिएको समर्थन',
    'change_query_status' => 'पूछताछ स्थिति परिवर्तन गर्नुहोस्',

    /** Router */
    'router_section' => 'राउटर खण्ड',
    'router_bssid' => 'राउटर BSSID',
    'router' => 'राउटर',
    'router_detail' => 'राउटर विवरण',
    'add_router' => 'राउटर थप्नुहोस्',

    /** QR */
    'scan_me' => 'मास्कन गर्नुहोस्',
    'attendance_qr' => 'हाजिरी QR',
    'qr_image' => 'QR छवि',
    'add_qr' => 'QR थप्नुहोस्',
    'qr_section' => 'QR खण्ड',

    /** NFC */
    'nfc_section' => 'NFC खण्ड',
    'created_by' => 'द्वारा सिर्जना गरिएको',

    /** Role and permission */
    'role_section' => 'भूमिका खण्ड',
    'autorize_backend_login' => 'ब्याकेंड लगइनलाई अनुमति दिनुहोस्',
    'role_name' => 'भूमिका नाम',
    'permissions' => 'अनुमतिहरू',
    'check_all' => 'सबै जाँच गर्नुहोस्',
    'module' => 'मोड्युल',
    'add_role' => 'भूमिका थप्नुहोस्',
    'assign_permissions' => 'अनुमतिहरू असाइन गर्नुहोस्',
    'confirm_role_deletion' => 'तपाईं भूमिका मेटाउन चाहानुहुन्छ भन्ने कुरा सुनिश्चित गर्नुभएको छ?',
    'can_login' => 'लगइन गर्न सकिन्छ',
    'permission_setting' => 'अनुमति सेटिङ',
    'assign' => 'सुसज्जित गर्नुहोस्',

    /** General Setting */
    'general_setting_section' => 'सामान्य सेटिङ खण्ड',
    'general_setting' => 'सामान्य सेटिङ',

    /** App Setting */
    'export_database_data' => 'डाटाबेस डेटा निर्यात गर्नुहोस्',
    'check_router_bssid' =>'राउटर BSSID जाँच्नुहोस्',

    /** Fiscal Years */
    'fiscal_years' => 'आर्थिक वर्षहरू',
    'year' => 'वर्ष',
    'add_fiscal_year' => 'आर्थिक वर्ष थप्नुहोस्',

    /** Notifications */
    'notification_section' => 'सूचना खण्ड',
    'confirm_notification_send' => 'तपाईंलाई निश्चित छ कि तपाईं सूचना पठाउन चाहनुहुन्छ?',
    'notification' => 'सूचना',
    'published_date' => 'प्रकाशित मिति',
    'all_types' => 'सबै प्रकार',
    'notification_lists' => 'सूचना सूचिहरू',
    'notified_member' => 'सूचित सदस्य',
    'notification_title' => 'सूचनाको शीर्षक',
    'notification_description' => 'सूचनाको विवरण',
    'send_notification' => 'सूचना पठाउनुहोस्',
    'enter_notification_title' => 'सूचनाको शीर्षक भर्नुहोस्',

    /** feature control */
    'app_setting' => 'अनुप्रयोग सेटिंग',
    'sn' => 'अनुक्रमणिका',
    'group' => 'समूह',
    'export_table_data' => 'तालिका डाटा निर्यात गर्नुहोस्',
    'leave_requests' => 'छुट्टी अनुरोधहरू',
    'employee_lists' => 'कर्मचारी सूचीहरू',
    'attendances' => 'उपस्थितिहरू',
    'confirm_change_status' => 'के तपाईं निश्चय गर्न चाहानुहुन्छ कि तपाईं स्थिति परिवर्तन गर्न चाहनुहुन्छ?',
    'yes' => 'हो',
    'no' => 'होइन',

    /** Api response */
    /** Auth Controller */
    'invalid_login_credentials'=>'अमान्य लगइन प्रमाणपत्रहरू!',
    'authenticated'=>'प्रमाणित गरियो',
    'user_detail_not_found'=>'प्रयोगकर्ता विवरण फेला परेन',
    'partial_logout_successful'=>'आंशिक लगआउट सफल भयो',
    /** Dashboard Controller */
    'data_found'=>'डाटा फेला पर्‍यो',
    /** AdvanceSalary Controller */
    'advance_salary_pending_error'=>'अर्को अग्रिम तलब अनुरोध गर्न सकिँदैन जबसम्म पहिलेको अनुरोध पूरा हुँदैन।',
    'data_updated_successfully'=>'डाटा सफलतापूर्वक अद्यावधिक गरियो',
    'user_updated_advance_salary_request' => ':name ले अग्रिम तलब अनुरोधको विवरण अद्यावधिक गर्यो',
    'data_created_successfully'=>'डाटा सफलतापूर्वक सिर्जना गरियो',
    'advance_salary_request_alert'=>'अग्रिम तलब अनुरोध अलर्ट',
    'user_submitted_advance_salary_request' => ':name ले :amount को अग्रिम तलब अनुरोध पेश गर्यो',
    /** Attendance Api */
    'check_out_successful'=>'चेकआउट सफल भयो',
    'check_out_notification'=>'चेकआउट सूचना',
    'check_in_successful'=>'चेकइन सफल भयो',
    'check_in_notification'=>'चेकइन सूचना',
    'not_checked_in_yet'=>'अझै पनि चेकइन गरिएको छैन',
    'alert_multi_checkin_shift'=>'माफ गर्नुहोस्! कर्मचारी एक शिफ्टमा दुई पटक चेकइन गर्न सक्दैन।',
    'checkout_alert_for_shift'=>'कर्मचारीले शिफ्टबाट पहिले नै चेकआउट गरिसकेको छ',
    'alert_checkin'=>'माफ गर्नुहोस्! कर्मचारीले एक दिनमा दुई पटक चेकइन गर्न सक्दैन।',
    'checkout_alert'=>'कर्मचारीले आजका लागि पहिले नै चेकआउट गरिसकेको छ',
    'attendance_alert_status'=>':status पहिले नै सम्पन्न भएको छ',
    'employee_checked_in' => ':name ले :time मा चेकइन गर्यो',
    'employee_checked_out' => ':name ले :time मा चेकआउट गर्यो',
    'has_worked_for' => 'र :time का लागि काम गरेको छ',
    'multi_checkout_warning'=>'तपाईंले आजका लागि अनुमत अधिकतम चेकइन र चेकआउटको संख्या पूरा गरिसक्नुभएको छ।',
    'employee_checked_out_and_worked' => ':name ले :check_out_time मा चेकआउट गर्यो र :worked_time का लागि काम गर्यो',
    'invalid_attendance_type'=>'अमान्य उपस्थिति प्रकार।',
    'invalid_qr'=>'अमान्य QR वा QR उपलब्ध छैन',
    'invalid_nfc'=>'अमान्य NFC टोकन वा NFC उपलब्ध छैन',
    'validation_failed'=>'मान्यता असफल भयो',

    /** Leave Api Controller */
    'leave_request_cancelled' => 'अवकाश अनुरोध सफलतापूर्वक रद्द गरियो',
    'leave_request_cannot_be_cancelled' => 'अवकाश अनुरोध एक पटक स्थिर अवस्थाबाट अपडेट गरिसकेपछि रद्द गर्न सकिँदैन।',
    'leave_request_notification' => 'अवकाश अनुरोध सूचना',
    'leave_request_submitted' => ':name ले :issue_date मा :start_time देखि :end_time सम्मको अवकाश अनुरोध गरेको छ। कारण: :reasons',
    'leave_request_submitted_successfully' => 'अवकाश अनुरोध सफलतापूर्वक प्रस्तुत गरिएको छ',
    'leave_request_cancelled_successfully' => 'अवकाश अनुरोध सफलतापूर्वक रद्द गरिएको छ',
    'leave_request_submit' => ':name ले :leave_requested_date मा :leave_from देखि :no_of_days दिन(s)को अवकाश अनुरोध गरेको छ। कारण: :reasons',

    /** NFC api Controller */
    'nfc_token_already_exist' => 'NFC टोकन पहिले नै अवस्थित छ।',
    'nfc_added_successfully' => 'NFC सफलतापूर्वक थपियो',

    /** Notification Api Controller */
    'updated_successfully' => 'सफलतापूर्वक अपडेट गरियो',
    'successfully_sent_notification' => 'सूचना सफलतापूर्वक पठाइएको छ',
    'data_not_found' => 'डाटा फेला परेन',
    'content_not_found' => 'सामग्री फेला परेन',

    /** Support Api Controller */
    'support_notification' => 'समर्थन सूचना',
    'support_request_submitted' => ':name ले समर्थनको लागि अनुरोध गरेको छ।',
    'query_submitted_successfully' => 'प्रश्न सफलतापूर्वक प्रस्तुत गरिएको छ',

    /** Tada Api Controller  */
    'attachment_detail_not_found' => 'अट्याचमेन्ट विवरण फेला परेन',
    'cannot_delete_attachment_detail' => 'एक पटक प्रमाणित गरिसकेपछि अट्याचमेन्ट विवरण मेटाउन सकिँदैन',
    'upload_another_attachment_before_delete' => 'मेटाउनुअघि कृपया अर्को अट्याचमेन्ट अपलोड गर्नुहोस्।',
    'attachment_deleted_successfully' => 'अट्याचमेन्ट सफलतापूर्वक मेटाइयो',
    'tada_update_alert' => 'तपाईं प्रमाणित गरिसकेपछि विवरण अपडेट गर्न सक्नुहुन्न, कृपया व्यवस्थापकलाई सम्पर्क गर्नुहोस्',
    'tada_notification' => ':name ले :title को लागि नयाँ TADA प्रस्तुत गरेको छ',
    'tada_detail_notification' => ':name ले :title प्रस्तुत TADA विवरण अपडेट गरेको छ',
    'tada_alert' => 'TADA अलर्ट',

    /** TaskDetailApi Controller */
    'status_changed_successfully' => 'स्थिति सफलतापूर्वक परिवर्तन गरिएको छ',
    'task_detail_not_found' => 'कार्य विवरण फेला परेन',

    /** TaskCheckListApi Controller */
    'status_updated_successfully' => 'स्थिति सफलतापूर्वक अपडेट गरिएको छ',

    /** TaskCommentApi Controller */
    'comment_notification' => 'टिप्पणी सूचना',
    'task_mention' => 'तपाईंलाई कार्य :task :type मा उल्लेख गरिएको छ',
    'comment_reply' => 'टिप्पणीको उत्तर',
    'comment_reply_deleted_successfully' => 'टिप्पणीको उत्तर सफलतापूर्वक मेटाइयो',
    'comment_deleted_successfully' => 'टिप्पणी सफलतापूर्वक मेटाइयो',
    'comment_added_successfully' => 'टिप्पणी सफलतापूर्वक थपियो',

    /** userProfile Api */
    'invalid_base64_image' => 'Base64 मान एक मान्य चित्र होइन',
    'demo_version' => 'यो एक डेमो संस्करण हो। कृपया सम्पूर्ण विशेषताहरूको प्रयोग गर्न आवेदन किन्नुहोस्',
    'user_not_found' => 'प्रयोगकर्ता विवरण फेला परेन',
    'profile_updated' => 'प्रोफाइल सफलतापूर्वक अपडेट गरियो',
    'incorrect_current_password' => 'हालको पासवर्ड गलत छ',
    'new_password_same_as_old' => 'नयाँ पासवर्ड पुरानो पासवर्डको समान हुन सक्दैन',
    'password_changed' => 'पासवर्ड सफलतापूर्वक परिवर्तन गरियो',

];
