<?php

namespace App\Http\Controllers;

use App\UserCurrency;
use Illuminate\Http\Request;
use DB;
use Auth;
use App\Course;
use App\Currency;
use App\setting;
use Session;
use App\User;

class EnrollmentController extends Controller
{

    public function enroll(Request $request, $id)
    {
        $course = Course::where('id', $id)->first();

        DB::table('orders')->insert(
            array(
                'user_id' => Auth::User()->id,
                'instructor_id' => $course->user_id,
                'course_id' => $id,
                'total_amount' => 'Free',
                'created_at'  => \Carbon\Carbon::now()->toDateTimeString(),
            )
        );

        return back()->with('success', trans('flash.EnrolledSuccessfully'));
    }

    public function buynow(Request $request)
    {
        $user_check = User::where('id', $request->user_id)->first();
        $course = Course::where('id', $request->course_id)->first();

        // Get selected currency from form
        $selected_currency = $request->selected_currency;

        // Store selected currency in session
        Session::put('changed_currency', $selected_currency);

        // Get base currency from settings
        $base_currency = setting::first()->currency ?? 'USD';

        // Calculate base prices
        $price_total = $course->price;
        $offer_total = ($course->discount_price != 0 && $course->discount_price != null)
            ? $course->discount_price
            : $course->price;

        // Convert prices to selected currency
        $converted_price_total = currency(
            $price_total,
            $from = $base_currency,
            $to = $selected_currency,
            $format = false
        );

        $converted_offer_total = currency(
            $offer_total,
            $from = $base_currency,
            $to = $selected_currency,
            $format = false
        );

        // Calculate offer details
        $offer_amount = $price_total - $offer_total;
        $offer_percent = ($offer_amount / $price_total) * 100;

        // Store values in session
        Session::put('price_total', $converted_price_total);
        Session::put('offer_total', $converted_offer_total);
        Session::put('offer_percent', $offer_percent);
        Session::put('cart_total', $converted_offer_total);
        Session::put('one_order_course', $course->id);
        Session::put('one_order_user', $user_check->id);

        $meeting = null;

        // Prepare view data
        $cart = $course;
        $cart_total = $converted_offer_total;
        $one_course = 1;

        // Determine which theme to use
        $setting = setting::first();

        $currencyData = DB::table('currencies')
            ->where('code', $selected_currency)
            ->first();

        if (!$currencyData) {
            return back()->with('error', 'Currency not found.');
        }

        // Delete any previous entries for this user
        DB::table('user_currencies')
            ->where('user_id', $user_check->id)
            ->delete();

        // Insert the new currency data into the user_currencies table
        DB::table('user_currencies')
            ->insert([
                'user_id' => $user_check->id,
                'code' => $currencyData->code,
                'name' => $currencyData->name,
                'symbol' => $currencyData->symbol,
                'format' => $currencyData->format,
                'exchange_rate' => $currencyData->exchange_rate,
                'default' => 1,
                'created_at' => now(),
                'updated_at' => now(),
            ]);



        $view = $setting->theme == '1' ? 'front.checkout' : 'theme_2.front.checkout';

        return view($view, compact(
            'course',
            'cart',
            'price_total',
            'offer_total',
            'offer_percent',
            'cart_total',
            'one_course',
            'meeting'
        ));
    }



    public function freeenroll(Request $request, $price)
    {
        try {
            $txn_id = uniqid();
            $payment_method = 'Free Enroll';

            // Gather the other required parameters
            $userId = $request->user()->id; // assuming the user is authenticated
            $courseId = $request->input('course_id'); // get course_id from the request
            $quantity = 1; // for free enrollments, this might be a fixed value
            $discount = 0; // assuming there is no discount for free enrollments

            // Create a new instance of OrderStoreController
            $checkout = new OrderStoreController;

            // Call the orderstore method
            return $checkout->orderstore($txn_id, $payment_method, $userId, $courseId, $quantity, $discount, $price);
        } catch (\Exception $e) {
            // Log the error message for debugging purposes
            \Log::error('Free enrollment error: ' . $e->getMessage());

            // Return an error response
            return response()->json(['error' => 'Unable to complete enrollment. Please try again later.'], 500);
        }
    }
}
