<?php

namespace App;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class UserCurrency extends Model
{
    use HasFactory;

    // Specify the table name
    protected $table = 'user_currencies';

    // Specify the fillable fields
    protected $fillable = [
        'user_id',
        'code',
        'name',
        'symbol',
        'format',
        'exchange_rate',
        'default',
    ];

    // Optionally define relationships
    public function user()
    {
        return $this->belongsTo(\App\User::class);
    }
}
