@extends('admin.layouts.master')
@section('title', 'Payment Gateways Setting')
@section('maincontent')
<?php
$data['heading'] = 'Payment Gateways Settings';
$data['title'] = 'Payment Gateways Settings';
?>
@include('admin.layouts.topbar',$data)
<div class="contentbar dashboard-card">
    <div class="row">
        @if ($errors->any())  
            <div class="alert alert-danger" role="alert">
                @foreach($errors->all() as $error)     
                    <p>{{ $error}}<button type="button" class="close" data-dismiss="alert" aria-label="Close" title="{{ __('Close') }}">
                    <span aria-hidden="true" style="color:red;" title="{{ __('Close')}}">&times;</span></button></p>
                @endforeach  
            </div>
        @endif
        
        <div class="col-md-3">
             <div class="card dashboard-card p-3 mb-5">
                <div class="scroll-down api-setting-page">
                    <div class="nav flex-column nav-pills" id="v-pills-tab" role="tablist" aria-orientation="vertical">
                        <a class="nav-link active" id="v-pills-AWS-tab" data-toggle="pill" href="#v-pills-AWS" role="tab" aria-controls="v-pills-AWS" aria-selected="false" title="{{ __('AWS')}}"><img src="{{ url('images/payment/api_setting/aws.png') }}" class="img-fluid" width="40px" height="40px" alt="{{ __('AWS')}}"></a>
                        <a class="nav-link" id="v-pills-Bunny-tab" data-toggle="pill" href="#v-pills-Bunny" role="tab" aria-controls="v-pills-Bunny" aria-selected="false" title="{{ __('Bunny Upload')}}"><img src="{{ url('images/payment/api_setting/bunny.jpg') }}" class="img-fluid" width="90px" height="90px" alt="{{ __('Bunny Upload')}}"></a>
                        <a class="nav-link" id="v-pills-Wasabi-tab" data-toggle="pill" href="#v-pills-Wasabi" role="tab" aria-controls="v-pills-Wasabi" aria-selected="false" title="{{ __('Wasabi Upload')}}"><img src="{{ url('images/payment/api_setting/wasabi.png') }}" class="img-fluid" width="90px" height="90px" alt="{{ __('Wasabi Upload')}}"></a>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-9 mb-3">
            <form action="{{ route('storage.update') }}" class="mb-4" method="POST">
            {{ csrf_field() }}
            {{ method_field('POST') }}
                <div class="card dashboard-card p-3">
                    <div class="tab-content" id="v-pills-tabContent">
                        <div class="tab-pane fade show active" id="v-pills-AWS" role="tabpanel" aria-labelledby="v-pills-AWS-tab">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label class="text-dark" for="aws_enable">{{ __('AWS Settings') }}</label>
                                    </div>
                                </div>

                                <div class="col-md-12 form-group">
                                    <input type="checkbox" class="custom_toggle" id="customSwitch8" name="aws_check" {{ $gsetting->aws_enable == 1 ? 'checked' : '' }} />
                                </div>                                    
                                <div class="col-md-6">
                                    <div class="form-group api-payment-key">
                                        <label class="text-dark" for="AWS_ACCESS_KEY_ID">{{ __('AWS Access KeyID') }} <span class="text-danger">*</span></label>
                                        <input id="aws_access_key_id" value="{{ $env_files['AWS_ACCESS_KEY_ID'] }}" autofocus name="AWS_ACCESS_KEY_ID" type="text" class="form-control" placeholder="{{ __('Enter AWS Access Key Id')}}"/>
                                        <span toggle="#aws_access_key_id" class="fa fa-fw fa-eye field-icon toggle-password"></span>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group api-payment-key">
                                        <label class="text-dark" for="AWS_SECRET_ACCESS_KEY">{{ __('AWS Secret Access Key') }} <span class="text-danger">*</span></label>
                                        <input id="aws_secret_access_key" value="{{ $env_files['AWS_SECRET_ACCESS_KEY'] }}" autofocus name="AWS_SECRET_ACCESS_KEY" type="text" class="form-control" placeholder="{{ __('Enter AWS Secret Access Key')}}"/>
                                        <span toggle="#aws_secret_access_key" class="fa fa-fw fa-eye field-icon toggle-password"></span>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="text-dark" for="AWS_DEFAULT_REGION">{{ __('AWS Default Region') }} <span class="text-danger">*</span></label>
                                        <i class="fa fa-info-circle" data-toggle="tooltip" data-placement="top" title="eg:ap-south-1"></i>
                                        <input value="{{ $env_files['AWS_DEFAULT_REGION'] }}" autofocus name="AWS_DEFAULT_REGION" type="text" class="form-control" placeholder="{{ __('Enter AWS Default Region')}}"/>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="text-dark" for="AWS_BUCKET">{{ __('AWS Bucket Name') }} <span class="text-danger">*</span></label>
                                        <input value="{{ $env_files['AWS_BUCKET'] }}" autofocus name="AWS_BUCKET" type="text" class="form-control" placeholder="{{ __('Enter AWS Bucket Name')}}"/>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="text-dark" for="AWS_URL">{{ __('AWS URL') }} <span class="text-danger">*</span></label>
                                        <i class="fa fa-info-circle" data-toggle="tooltip" data-placement="top" title="eg:https://bucket-name.s3.Region.amazonaws.com/"></i>
                                        <input value="{{ $env_files['AWS_URL'] }}" autofocus name="AWS_URL" type="text" class="form-control" placeholder="{{ __('Enter AWS URL')}} eg:https://bucket-name.s3.Region.amazonaws.com/"/>
                                        <small class="text-info"><i class="fa fa-question-circle"></i> {{__(' eg: https://Region.amazonaws.com/bucket-name/')}}</small>
                                    </div>
                                </div>
                                <div class="form-group col-md-12">
                                    <button type="reset" class="btn btn-danger-rgba mr-1" title="{{ __('Reset')}}"><i class="fa fa-ban"></i> {{ __("Reset")}}</button>
                                    <button type="submit" class="btn btn-primary-rgba" title="{{ __('Update')}}"><i class="fa fa-check-circle"></i>
                                    {{ __("Update")}}</button>
                                </div>
                            </div>
                        </div>
                        <div class="tab-pane fade" id="v-pills-Bunny" role="tabpanel" aria-labelledby="v-pills-Bunny-tab">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label class="text-dark" for="aws_enable">{{ __('Bunny Settings') }}</label>
                                    </div>
                                </div>

                                <div class="col-md-12 form-group">
                                    <input type="checkbox" class="custom_toggle" id="customSwitch88" name="bunny_check" {{ $gsetting->bunny_enable == 1 ? 'checked' : '' }} />
                                </div>                                    
                                <div class="col-md-6">
                                    <div class="form-group api-payment-key">
                                        <label class="text-dark" for="WASABI_KEY_ID">{{ __('BUNNY KEY') }} <span class="text-danger">*</span></label>
                                        <input id="bunny_key" value="{{ $env_files['BUNNYCDN_API_KEY'] }}" autofocus name="BUNNYCDN_API_KEY" type="text" class="form-control" placeholder="{{ __('Enter Bunny Access Key Id')}}"/>
                                        <span toggle="#bunny_key" class="fa fa-fw fa-eye field-icon toggle-password"></span>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group api-payment-key">
                                        <label class="text-dark" for="WASABI_SECRET_ACCESS_KEY">{{ __('BUNNY STORAGE NAME') }} <span class="text-danger">*</span></label>
                                        <input id="bunny_storage_name" value="{{ $env_files['BUNNYCDN_STORAGE_ZONE_NAME'] }}" autofocus name="BUNNYCDN_STORAGE_ZONE_NAME" type="text" class="form-control" placeholder="{{ __('Enter Bunny Storage Name')}}"/>
                                        <span toggle="#bunny_storage_name" class="fa fa-fw fa-eye field-icon toggle-password"></span>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="text-dark" for="WASABI_DEFAULT_REGION">{{ __('BUNNY REGION') }} <span class="text-danger">*</span></label>
                                        <i class="fa fa-info-circle" data-toggle="tooltip" data-placement="top" title="eg:ap-south-1"></i>
                                        <input value="{{ $env_files['BUNNY_REGION'] }}" autofocus name="BUNNY_REGION" type="text" class="form-control" placeholder="{{ __('Enter Bunny Default Region')}}"/>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="text-dark" for="BUNNYCDN_PULL_ZONE">{{ __('Bunny Pull Zone') }} <span class="text-danger">*</span></label>
                                        <input value="{{ $env_files['BUNNYCDN_PULL_ZONE'] }}" autofocus name="BUNNYCDN_PULL_ZONE" type="text" class="form-control" placeholder="{{ __('Enter Bunny Pull Zone')}}"/>
                                    </div>
                                </div>
                                <div class="form-group col-md-12">
                                    <button type="reset" class="btn btn-danger-rgba mr-1" title="{{ __('Reset')}}"><i class="fa fa-ban"></i> {{ __("Reset")}}</button>
                                    <button type="submit" class="btn btn-primary-rgba" title="{{ __('Update')}}"><i class="fa fa-check-circle"></i>
                                    {{ __("Update")}}</button>
                                </div>
                            </div>
                        </div>
                        <div class="tab-pane fade" id="v-pills-Wasabi" role="tabpanel" aria-labelledby="v-pills-Wasabi-tab">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label class="text-dark" for="wasabi_enable">{{ __('Wasabi Settings') }}</label>
                                    </div>
                                </div>

                                <div class="col-md-12 form-group">
                                    <input type="checkbox" class="custom_toggle" id="customSwitch88" name="wasabi_check" {{ $gsetting->wasabi_enable == 1 ? 'checked' : '' }} />
                                </div>                                    
                                <div class="col-md-6">
                                    <div class="form-group api-payment-key">
                                        <label class="text-dark" for="WASABI_KEY_ID">{{ __('WASABI KEY') }} <span class="text-danger">*</span></label>
                                        <input id="wasabi_key" value="{{ $env_files['WASABI_KEY'] }}" autofocus name="WASABI_KEY" type="text" class="form-control" placeholder="{{ __('Enter Wasabi Access Key Id')}}"/>
                                        <span toggle="#wasabi_key" class="fa fa-fw fa-eye field-icon toggle-password"></span>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group api-payment-key">
                                        <label class="text-dark" for="WASABI_SECRET_ACCESS_KEY">{{ __('AWS Secret Access Key') }} <span class="text-danger">*</span></label>
                                        <input id="wasabi_secret_access_key" value="{{ $env_files['WASABI_SECRET'] }}" autofocus name="WASABI_SECRET" type="text" class="form-control" placeholder="{{ __('Enter Wasabi Secret Access Key')}}"/>
                                        <span toggle="#wasabi_secret_access_key" class="fa fa-fw fa-eye field-icon toggle-password"></span>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="text-dark" for="WASABI_DEFAULT_REGION">{{ __('Wasabi Default Region') }} <span class="text-danger">*</span></label>
                                        <i class="fa fa-info-circle" data-toggle="tooltip" data-placement="top" title="eg:ap-south-1"></i>
                                        <input value="{{ $env_files['WASABI_REGION'] }}" autofocus name="WASABI_REGION" type="text" class="form-control" placeholder="{{ __('Enter Wasabi Default Region')}}"/>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="text-dark" for="WASABI_BUCKET">{{ __('Wasabi Bucket Name') }} <span class="text-danger">*</span></label>
                                        <input value="{{ $env_files['WASABI_BUCKET'] }}" autofocus name="WASABI_BUCKET" type="text" class="form-control" placeholder="{{ __('Enter Wasabi Bucket Name')}}"/>
                                    </div>
                                </div>
                                <div class="form-group col-md-12">
                                    <button type="reset" class="btn btn-danger-rgba mr-1" title="{{ __('Reset')}}"><i class="fa fa-ban"></i> {{ __("Reset")}}</button>
                                    <button type="submit" class="btn btn-primary-rgba" title="{{ __('Update')}}"><i class="fa fa-check-circle"></i>
                                    {{ __("Update")}}</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@section('script')
<script>
(function($) {
  "use strict";
  $(function(){
      $('#customSwitch1').change(function(){
        if($('#customSwitch1').is(':checked')){
        	$('#s_sec').show('fast');
        }else{
        	$('#s_sec').hide('fast');
        }

      });
      $('#customSwitch2').change(function(){
        if($('#customSwitch2').is(':checked')){
        	$('#pay_sec').show('fast');
        }else{
        	$('#pay_sec').hide('fast');
        }

      });
      $('#payu_sec1').change(function(){
        if($('#payu_sec1').is(':checked')){
        	$('#payu_sec').show('fast');
        }else{
        	$('#payu_sec').hide('fast');
        }

      });
      $('#customSwitch3').change(function(){
        if($('#customSwitch3').is(':checked')){
        	$('#insta_sec').show('fast');
        }else{
        	$('#insta_sec').hide('fast');
        }

      });
      $('#customSwitch25').change(function(){
        if($('#customSwitch25').is(':checked')){
        	$('#brain_sec').show('fast');
        }else{
        	$('#brain_sec').hide('fast');
        }

      });
      $('#customSwitch4').change(function(){
        if($('#customSwitch4').is(':checked')){
        	$('#razor_sec').show('fast');
        }else{
        	$('#razor_sec').hide('fast');
        }

      });
      $('#customSwitch5').change(function(){
        if($('#customSwitch5').is(':checked')){
        	$('#paystack_sec').show('fast');
        }else{
        	$('#paystack_sec').hide('fast');
        }

      });
      $('#customSwitch6').change(function(){
        if($('#customSwitch6').is(':checked')){
        	$('#paytm_sec').show('fast');
        }else{
        	$('#paytm_sec').hide('fast');
        }

      });
      $('#customSwitch7').change(function(){
        if($('#customSwitch7').is(':checked')){
        	$('#captcha_sec').show('fast');
        }else{
        	$('#captcha_sec').hide('fast');
        }

      });
      	$('#customSwitch8').change(function(){
	        if($('#customSwitch8').is(':checked')){
	        	$('#aws_sec').show('fast');
	        }else{
	        	$('#aws_sec').hide('fast');
	        }

	    });
      	$('#customSwitch9').change(function () {
            if ($('#customSwitch9').is(':checked')) {
                $('#omise_sec').show('fast');
            } else {
                $('#omise_sec').hide('fast');
            }

        });
       	$('#customSwitch10').change(function () {
            if ($('#customSwitch10').is(':checked')) {
                $('#payu_sec').show('fast');
            } else {
                $('#payu_sec').hide('fast');
            }

        });
        $('#customSwitch12').change(function () {
            if ($('#customSwitch12').is(':checked')) {
                $('#moli_sec').show('fast');
            } else {
                $('#moli_sec').hide('fast');
            }

        });
        $('#customSwitch13').change(function () {
            if ($('#customSwitch13').is(':checked')) {
                $('#cf_sec').show('fast');
            } else {
                $('#cf_sec').hide('fast');
            }

        });
        $('#customSwitch14').change(function () {
            if ($('#customSwitch14').is(':checked')) {
                $('#sk_sec').show('fast');
            } else {
                $('#sk_sec').hide('fast');
            }

        });
        $('#customSwitch15').change(function () {
            if ($('#customSwitch15').is(':checked')) {
                $('#rave_sec').show('fast');
            } else {
                $('#rave_sec').hide('fast');
            }
        });
        $('#customSwitch16').change(function () {
            if ($('#customSwitch16').is(':checked')) {
                $('#payhere_sec').show('fast');
            } else {
                $('#payhere_sec').hide('fast');
            }
        });
        $('#customSwitch17').change(function () {
            if ($('#customSwitch17').is(':checked')) {
                $('#iyzico_sec').show('fast');
            } else {
                $('#iyzico_sec').hide('fast');
            }
        });
        $('#customSwitch18').change(function () {
            if ($('#customSwitch18').is(':checked')) {
                $('#ssl_sec').show('fast');
            } else {
                $('#ssl_sec').hide('fast');
            }
        });
        $('#customSwitch21').change(function () {
            if ($('#customSwitch21').is(':checked')) {
                $('#youtube_sec').show('fast');
            } else {
                $('#youtube_sec').hide('fast');
            }
        });
        $('#customSwitch22').change(function () {
            if ($('#customSwitch22').is(':checked')) {
                $('#vimeo_sec').show('fast');
            } else {
                $('#vimeo_sec').hide('fast');
            }
        });
        $('#customSwitch23').change(function () {
            if ($('#customSwitch23').is(':checked')) {
                $('#aamarpay_sec').show('fast');
            } else {
                $('#aamarpay_sec').hide('fast');
            }
        });
        $('#customSwitch26').change(function () {
            if ($('#customSwitch26').is(':checked')) {
                $('#gtm_sec').show('fast');
            } else {
                $('#gtm_sec').hide('fast');
            }
        });
        $('#customSwitch27').change(function(){
	        if($('#customSwitch27').is(':checked')){
	        	$('#payflexi_sec').show('fast');
	        }else{
	        	$('#payflexi_sec').hide('fast');
	        }
	    });
  });

})(jQuery);
</script>
@endsection
<!-- This section will contain javacsript end -->