<div id="cookie-consent" class="js-cookie-consent cookie-consent fixed bottom-0 inset-x-0 pb-2 z-50">
    <div class="max-w-7xl mx-auto px-6">
        <div class="p-4 md:p-2 rounded-lg bg-yellow-100">
            <div class="flex items-center justify-between flex-wrap">
                <div class="max-w-full flex-1 items-center md:w-0 md:inline">
                    <p class="md:ml-3 text-black cookie-consent__message">
                        {!! trans('cookie-consent::texts.message') !!}
                    </p>
                </div>
                <div class="mt-2 flex-shrink-0 w-full sm:mt-0 sm:w-auto">
                    <button id="cookie-decline" class="cookie-consent__false cursor-pointer flex items-center justify-center px-4 py-2 rounded-md text-sm font-medium text-yellow-800 bg-yellow-400 hover:bg-yellow-300">
                        {{ __('Decline Cookies') }}
                    </button>
                    <button id="cookie-agree" class="cookie-consent__agree cursor-pointer flex items-center justify-center px-4 py-2 rounded-md text-sm font-medium text-yellow-800 bg-yellow-400 hover:bg-yellow-300">
                        {{ trans('cookie-consent::texts.agree') }}
                    </button>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    // Check if the user has already declined cookies
    if (localStorage.getItem('cookie_declined') === 'true') {
        // Hide the cookie consent div
        document.getElementById('cookie-consent').style.display = 'none';
    }

    // Check if the user has already agreed to cookies
    if (localStorage.getItem('cookie_agreed') === 'true') {
        // Hide the cookie consent div
        document.getElementById('cookie-consent').style.display = 'none';
    }

    // Get the Decline button using its id
    const declineButton = document.getElementById('cookie-decline');

    // Get the Agree button using its id
    const agreeButton = document.getElementById('cookie-agree');

    // Get the entire cookie consent div using its id
    const cookieConsentDiv = document.getElementById('cookie-consent');

    // Add click event listener to the Decline button
    declineButton.addEventListener('click', function () {
        // Save the user's choice to localStorage
        localStorage.setItem('cookie_declined', 'true');

        // Hide the cookie consent div
        cookieConsentDiv.style.display = 'none';
    });

    // Add click event listener to the Agree button
    agreeButton.addEventListener('click', function () {
        // Save the user's choice to localStorage
        localStorage.setItem('cookie_agreed', 'true');

        // Hide the cookie consent div
        cookieConsentDiv.style.display = 'none';
    });
</script>
