<?php $__env->startSection('main-content'); ?>

<section class="section">
    <div class="section-header">
        <h1><?php echo e(__('language.language')); ?></h1>
        <?php echo e(Breadcrumbs::render('language')); ?>

    </div>

    <div class="section-body">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('language_create')): ?>
                    <div class="card-header">
                        <a href="<?php echo e(route('admin.language.create')); ?>" class="btn btn-icon icon-left btn-primary"><i
                                class="fas fa-plus"></i> <?php echo e(__('language.add_language')); ?>

                        </a>
                    <?php endif; ?>
                        <a href="<?php echo e(url('translations')); ?>" target="_blank"
                                class="btn btn-icon icon-left btn-primary text-right ml-2"> <i
                                    class="fas fa-cog"></i><?php echo e(__('language.translate')); ?>

                        </a>
                    </div>
                   
                  

                    <div class="card-body">
                        <div class="row">
                            <div class="col-sm-6 offset-sm-3">
                                <div class="input-group input-daterange" id="date-picker">
                                    <select class="form-control" id="status" name="status">
                                        <?php $__currentLoopData = trans('statuses'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($key); ?>"><?php echo e($status); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <div class="input-group-append">
                                        <button class="btn btn-outline-secondary" type="button" id="refresh">
                                            <?php echo e(__('levels.refresh')); ?></button>
                                    </div>
                                    <div class="input-group-append">
                                        <button class="btn btn-outline-secondary" type="button"
                                            id="date-search"><?php echo e(__('levels.search')); ?></button>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <br>
                        <div class="table-responsive">
                            <table class="table table-striped" id="maintable"
                                data-url="<?php echo e(route('admin.language.index')); ?>"
                                data-status="<?php echo e(\App\Enums\Status::ACTIVE); ?>"
                                data-hidecolumn="<?php echo e(auth()->user()->can('language_edit') || auth()->user()->can('language_delete')); ?>">
                                <thead>
                                    <tr>
                                        <th><?php echo e(__('levels.id')); ?></th>
                                        <th><?php echo e(__('language.language_name')); ?></th>
                                        <th><?php echo e(__('language.flag')); ?></th>
                                        <th><?php echo e(__('language.language_code')); ?></th>
                                        <th><?php echo e(__('levels.status')); ?></th>
                                        <th><?php echo e(__('levels.actions')); ?></th>
                                    </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('css'); ?>
<link rel="stylesheet" href="<?php echo e(asset('assets/modules/datatables.net-bs4/css/dataTables.bootstrap4.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/modules/datatables.net-select-bs4/css/select.bootstrap4.min.css')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script src="<?php echo e(asset('assets/modules/datatables/media/js/jquery.dataTables.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/modules/datatables.net-bs4/js/dataTables.bootstrap4.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/modules/datatables.net-select-bs4/js/select.bootstrap4.min.js')); ?>"></script>
<script src="<?php echo e(asset('js/language/index.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/kawsaruddin/Workspace/8.2/foodbank/resources/views/admin/language/index.blade.php ENDPATH**/ ?>