
/*
 * Editor client script for DB table Person
 * Created by http://editor.datatables.net/generator
 */

(function($){

$(document).ready(function() {
	var editor = new $.fn.dataTable.Editor( {
		ajax: 'php/table.Person.php',
		table: '#Person',
		fields: [
			{
				"label": "Name:",
				"name": "name"
			},
			{
				"label": "DoB:",
				"name": "dob",
				"type": "datetime",
				"format": "DD-MM-YY"
			},
			{
				"label": "Gender:",
				"name": "gender"
			}
		]
	} );

	var table = $('#Person').DataTable( {
		dom: 'Bfrtip',
		ajax: 'php/table.Person.php',
		columns: [
			{
				"data": "name"
			},
			{
				"data": "dob"
			},
			{
				"data": "gender"
			}
		],
		select: true,
		lengthChange: false,
		buttons: [
			{ extend: 'create', editor: editor },
			{ extend: 'edit',   editor: editor },
			{ extend: 'remove', editor: editor }
		]
	} );
} );

}(jQuery));

